/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.progressbar;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ProgressBar;
import com.facebook.react.bridge.JSApplicationIllegalArgumentException;
import com.facebook.react.uimanager.BaseViewPropertyApplicator;
import com.facebook.react.uimanager.CatalystStylesDiffMap;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.UIProp;
import com.facebook.react.uimanager.ViewManager;
import com.facebook.react.views.progressbar.ProgressBarShadowNode;
import javax.annotation.Nullable;

public class ReactProgressBarViewManager
extends ViewManager<FrameLayout, ProgressBarShadowNode> {
    @UIProp(value=UIProp.Type.STRING)
    public static final String PROP_STYLE = "styleAttr";
    static final String REACT_CLASS = "AndroidProgressBar";
    static final String DEFAULT_STYLE = "Large";

    @Override
    public String getName() {
        return REACT_CLASS;
    }

    @Override
    protected FrameLayout createViewInstance(ThemedReactContext context) {
        return new FrameLayout((Context)context);
    }

    @Override
    public void updateView(FrameLayout view, CatalystStylesDiffMap props) {
        BaseViewPropertyApplicator.applyCommonViewProperties((View)view, props);
        if (props.hasKey(PROP_STYLE)) {
            int style2 = ReactProgressBarViewManager.getStyleFromString(props.getString(PROP_STYLE));
            view.removeAllViews();
            view.addView((View)new ProgressBar(view.getContext(), null, style2), new ViewGroup.LayoutParams(-2, -2));
        }
    }

    @Override
    public ProgressBarShadowNode createCSSNodeInstance() {
        return new ProgressBarShadowNode();
    }

    @Override
    public void updateExtraData(FrameLayout root, Object extraData) {
    }

    static int getStyleFromString(@Nullable String styleStr) {
        if (styleStr == null) {
            throw new JSApplicationIllegalArgumentException("ProgressBar needs to have a style, null received");
        }
        if (styleStr.equals("Horizontal")) {
            return 16842872;
        }
        if (styleStr.equals("Small")) {
            return 16842873;
        }
        if (styleStr.equals(DEFAULT_STYLE)) {
            return 16842874;
        }
        if (styleStr.equals("Inverse")) {
            return 16843399;
        }
        if (styleStr.equals("SmallInverse")) {
            return 16843400;
        }
        if (styleStr.equals("LargeInverse")) {
            return 16843401;
        }
        throw new JSApplicationIllegalArgumentException("Unknown ProgressBar style: " + styleStr);
    }
}

