/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.text;

import android.content.Context;
import android.text.Layout;
import android.text.Spanned;
import android.widget.TextView;
import com.facebook.react.uimanager.ReactCompoundView;
import com.facebook.react.views.text.ReactTagSpan;

public class ReactTextView
extends TextView
implements ReactCompoundView {
    public ReactTextView(Context context) {
        super(context);
    }

    @Override
    public int reactTagForTouch(float touchX, float touchY) {
        int index;
        ReactTagSpan[] spans;
        Spanned text = (Spanned)this.getText();
        int target = this.getId();
        int x = (int)touchX;
        int y = (int)touchY;
        x -= this.getTotalPaddingLeft();
        y -= this.getTotalPaddingTop();
        Layout layout2 = this.getLayout();
        int line = layout2.getLineForVertical(y += this.getScrollY());
        int lineStartX = (int)layout2.getLineLeft(line);
        int lineEndX = (int)layout2.getLineRight(line);
        if ((x += this.getScrollX()) >= lineStartX && x <= lineEndX && (spans = (ReactTagSpan[])text.getSpans(index = layout2.getOffsetForHorizontal(line, (float)x), index, ReactTagSpan.class)) != null) {
            int targetSpanTextLength = text.length();
            for (int i = 0; i < spans.length; ++i) {
                int spanStart = text.getSpanStart((Object)spans[i]);
                int spanEnd = text.getSpanEnd((Object)spans[i]);
                if (spanEnd <= index || spanEnd - spanStart > targetSpanTextLength) continue;
                target = spans[i].getReactTag();
                targetSpanTextLength = spanEnd - spanStart;
            }
        }
        return target;
    }
}

