/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.text;

import android.content.Context;
import android.text.Spanned;
import android.text.TextUtils;
import android.view.View;
import com.facebook.react.bridge.JSApplicationIllegalArgumentException;
import com.facebook.react.common.annotations.VisibleForTesting;
import com.facebook.react.uimanager.BaseViewPropertyApplicator;
import com.facebook.react.uimanager.CatalystStylesDiffMap;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.UIProp;
import com.facebook.react.uimanager.ViewManager;
import com.facebook.react.views.text.ReactTextShadowNode;
import com.facebook.react.views.text.ReactTextView;

public class ReactTextViewManager
extends ViewManager<ReactTextView, ReactTextShadowNode> {
    @VisibleForTesting
    public static final String REACT_CLASS = "RCTText";
    @UIProp(value=UIProp.Type.NUMBER)
    public static final String PROP_NUMBER_OF_LINES = "numberOfLines";
    @UIProp(value=UIProp.Type.STRING)
    public static final String PROP_TEXT_ALIGN = "textAlign";
    @UIProp(value=UIProp.Type.NUMBER)
    public static final String PROP_LINE_HEIGHT = "lineHeight";

    @Override
    public String getName() {
        return REACT_CLASS;
    }

    @Override
    public ReactTextView createViewInstance(ThemedReactContext context) {
        return new ReactTextView((Context)context);
    }

    @Override
    public void updateView(ReactTextView view, CatalystStylesDiffMap props) {
        BaseViewPropertyApplicator.applyCommonViewProperties((View)view, props);
        if (props.hasKey(PROP_NUMBER_OF_LINES)) {
            view.setMaxLines(props.getInt(PROP_NUMBER_OF_LINES, Integer.MAX_VALUE));
            view.setEllipsize(TextUtils.TruncateAt.END);
        }
        if (props.hasKey(PROP_TEXT_ALIGN)) {
            String textAlign = props.getString(PROP_TEXT_ALIGN);
            if (textAlign == null || "auto".equals(textAlign)) {
                view.setGravity(0);
            } else if ("left".equals(textAlign)) {
                view.setGravity(3);
            } else if ("right".equals(textAlign)) {
                view.setGravity(5);
            } else if ("center".equals(textAlign)) {
                view.setGravity(1);
            } else {
                throw new JSApplicationIllegalArgumentException("Invalid textAlign: " + textAlign);
            }
        }
        if (props.hasKey(PROP_LINE_HEIGHT)) {
            if (props.isNull(PROP_LINE_HEIGHT)) {
                view.setLineSpacing(0.0f, 1.0f);
            } else {
                float lineHeight = PixelUtil.toPixelFromSP(props.getInt(PROP_LINE_HEIGHT, 0));
                view.setLineSpacing(lineHeight, 0.0f);
            }
        }
    }

    @Override
    public void updateExtraData(ReactTextView view, Object extraData) {
        view.setText((CharSequence)((Spanned)extraData));
    }

    @Override
    public ReactTextShadowNode createCSSNodeInstance() {
        return new ReactTextShadowNode(false);
    }
}

