/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drawee.components;

import android.os.Handler;
import android.os.Looper;
import java.util.HashSet;
import java.util.Set;

public class DeferredReleaser {
    private static DeferredReleaser sInstance = null;
    private final Set<Releasable> mPendingReleasables;
    private final Handler mUiHandler;
    private final Runnable releaseRunnable = new Runnable(){

        @Override
        public void run() {
            for (Releasable releasable : DeferredReleaser.this.mPendingReleasables) {
                releasable.release();
            }
            DeferredReleaser.this.mPendingReleasables.clear();
        }
    };

    public static synchronized DeferredReleaser getInstance() {
        if (sInstance == null) {
            sInstance = new DeferredReleaser();
        }
        return sInstance;
    }

    public DeferredReleaser() {
        this.mPendingReleasables = new HashSet<Releasable>();
        this.mUiHandler = new Handler(Looper.getMainLooper());
    }

    public void scheduleDeferredRelease(Releasable releasable) {
        if (!this.mPendingReleasables.add(releasable)) {
            return;
        }
        if (this.mPendingReleasables.size() == 1) {
            this.mUiHandler.post(this.releaseRunnable);
        }
    }

    public void cancelDeferredRelease(Releasable releasable) {
        this.mPendingReleasables.remove(releasable);
    }

    public static interface Releasable {
        public void release();
    }
}

