/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge;

import com.facebook.infer.annotation.Assertions;
import com.facebook.react.bridge.JavaScriptModule;
import com.facebook.react.common.MapBuilder;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.Immutable;

@Immutable
class JavaScriptModuleRegistration {
    private final int mModuleId;
    private final Class<? extends JavaScriptModule> mModuleInterface;
    private final Map<Method, Integer> mMethodsToIds;
    private final Map<Method, String> mMethodsToTracingNames;

    JavaScriptModuleRegistration(int moduleId, Class<? extends JavaScriptModule> moduleInterface) {
        this.mModuleId = moduleId;
        this.mModuleInterface = moduleInterface;
        this.mMethodsToIds = MapBuilder.newHashMap();
        this.mMethodsToTracingNames = MapBuilder.newHashMap();
        Method[] declaredMethods = this.mModuleInterface.getDeclaredMethods();
        Arrays.sort(declaredMethods, new Comparator<Method>(){

            @Override
            public int compare(Method lhs, Method rhs) {
                return lhs.getName().compareTo(rhs.getName());
            }
        });
        String previousName = null;
        for (int i = 0; i < declaredMethods.length; ++i) {
            Method method = declaredMethods[i];
            String name = method.getName();
            Assertions.assertCondition((!name.equals(previousName) ? 1 : 0) != 0, (String)("Method overloading is unsupported: " + this.mModuleInterface.getName() + "#" + name));
            previousName = name;
            this.mMethodsToIds.put(method, i);
            this.mMethodsToTracingNames.put(method, "JSCall__" + this.getName() + "_" + method.getName());
        }
    }

    public int getModuleId() {
        return this.mModuleId;
    }

    public int getMethodId(Method method) {
        Integer id = this.mMethodsToIds.get(method);
        Assertions.assertNotNull((Object)id, (String)("Unknown method: " + method.getName()));
        return id;
    }

    public String getTracingName(Method method) {
        return (String)Assertions.assertNotNull((Object)this.mMethodsToTracingNames.get(method));
    }

    public Class<? extends JavaScriptModule> getModuleInterface() {
        return this.mModuleInterface;
    }

    public String getName() {
        String name = this.mModuleInterface.getSimpleName();
        int dollarSignIndex = name.lastIndexOf(36);
        if (dollarSignIndex != -1) {
            name = name.substring(dollarSignIndex + 1);
        }
        return name;
    }

    public Set<Method> getMethods() {
        return this.mMethodsToIds.keySet();
    }
}

