/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge;

import android.os.Handler;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.bridge.JSDebuggerWebSocketClient;
import com.facebook.react.bridge.ProxyJavaScriptExecutor;
import java.util.HashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;

public class WebsocketJavaScriptExecutor
implements ProxyJavaScriptExecutor.JavaJSExecutor {
    private static final long CONNECT_TIMEOUT_MS = 5000L;
    private static final int CONNECT_RETRY_COUNT = 3;
    private final HashMap<String, String> mInjectedObjects = new HashMap();
    @Nullable
    private JSDebuggerWebSocketClient mWebSocketClient;

    public void connect(final String webSocketServerUrl, final JSExecutorConnectCallback callback) {
        final AtomicInteger retryCount = new AtomicInteger(3);
        JSExecutorConnectCallback retryProxyCallback = new JSExecutorConnectCallback(){

            @Override
            public void onSuccess() {
                callback.onSuccess();
            }

            @Override
            public void onFailure(Throwable cause) {
                if (retryCount.decrementAndGet() <= 0) {
                    callback.onFailure(cause);
                } else {
                    WebsocketJavaScriptExecutor.this.connectInternal(webSocketServerUrl, this);
                }
            }
        };
        this.connectInternal(webSocketServerUrl, retryProxyCallback);
    }

    private void connectInternal(String webSocketServerUrl, final JSExecutorConnectCallback callback) {
        final JSDebuggerWebSocketClient client = new JSDebuggerWebSocketClient();
        final Handler timeoutHandler = new Handler();
        client.connect(webSocketServerUrl, new JSDebuggerWebSocketClient.JSDebuggerCallback(){

            @Override
            public void onSuccess(@Nullable String response) {
                client.prepareJSRuntime(new JSDebuggerWebSocketClient.JSDebuggerCallback(){

                    @Override
                    public void onSuccess(@Nullable String response) {
                        timeoutHandler.removeCallbacksAndMessages(null);
                        WebsocketJavaScriptExecutor.this.mWebSocketClient = client;
                        callback.onSuccess();
                    }

                    @Override
                    public void onFailure(Throwable cause) {
                        timeoutHandler.removeCallbacksAndMessages(null);
                        callback.onFailure(cause);
                    }
                });
            }

            @Override
            public void onFailure(Throwable cause) {
                callback.onFailure(cause);
            }
        });
        timeoutHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                client.closeQuietly();
                callback.onFailure(new WebsocketExecutorTimeoutException("Timeout while connecting to remote debugger"));
            }
        }, 5000L);
    }

    @Override
    public void close() {
        if (this.mWebSocketClient != null) {
            this.mWebSocketClient.closeQuietly();
        }
    }

    @Override
    public void executeApplicationScript(String script, String sourceURL) throws ProxyJavaScriptExecutor.ProxyExecutorException {
        JSExecutorCallbackFuture callback = new JSExecutorCallbackFuture();
        ((JSDebuggerWebSocketClient)Assertions.assertNotNull((Object)this.mWebSocketClient)).executeApplicationScript(sourceURL, this.mInjectedObjects, callback);
        try {
            callback.get();
        }
        catch (Throwable cause) {
            throw new ProxyJavaScriptExecutor.ProxyExecutorException(cause);
        }
    }

    @Override
    @Nullable
    public String executeJSCall(String moduleName, String methodName, String jsonArgsArray) throws ProxyJavaScriptExecutor.ProxyExecutorException {
        JSExecutorCallbackFuture callback = new JSExecutorCallbackFuture();
        ((JSDebuggerWebSocketClient)Assertions.assertNotNull((Object)this.mWebSocketClient)).executeJSCall(moduleName, methodName, jsonArgsArray, callback);
        try {
            return callback.get();
        }
        catch (Throwable cause) {
            throw new ProxyJavaScriptExecutor.ProxyExecutorException(cause);
        }
    }

    @Override
    public void setGlobalVariable(String propertyName, String jsonEncodedValue) {
        this.mInjectedObjects.put(propertyName, jsonEncodedValue);
    }

    private static class JSExecutorCallbackFuture
    implements JSDebuggerWebSocketClient.JSDebuggerCallback {
        private final Semaphore mSemaphore = new Semaphore(0);
        @Nullable
        private Throwable mCause;
        @Nullable
        private String mResponse;

        private JSExecutorCallbackFuture() {
        }

        @Override
        public void onSuccess(@Nullable String response) {
            this.mResponse = response;
            this.mSemaphore.release();
        }

        @Override
        public void onFailure(Throwable cause) {
            this.mCause = cause;
            this.mSemaphore.release();
        }

        @Nullable
        public String get() throws Throwable {
            this.mSemaphore.acquire();
            if (this.mCause != null) {
                throw this.mCause;
            }
            return this.mResponse;
        }
    }

    public static class WebsocketExecutorTimeoutException
    extends Exception {
        public WebsocketExecutorTimeoutException(String message) {
            super(message);
        }
    }

    public static interface JSExecutorConnectCallback {
        public void onSuccess();

        public void onFailure(Throwable var1);
    }
}

