/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge.queue;

import android.os.Looper;
import com.facebook.common.logging.FLog;
import com.facebook.proguard.annotations.DoNotStrip;
import com.facebook.react.bridge.SoftAssertions;
import com.facebook.react.bridge.queue.MessageQueueThreadHandler;
import com.facebook.react.bridge.queue.MessageQueueThreadSpec;
import com.facebook.react.bridge.queue.QueueThreadExceptionHandler;
import com.facebook.react.common.futures.SimpleSettableFuture;

@DoNotStrip
public class MessageQueueThread {
    private final String mName;
    private final Looper mLooper;
    private final MessageQueueThreadHandler mHandler;
    private final String mAssertionErrorMessage;
    private volatile boolean mIsFinished = false;

    private MessageQueueThread(String name, Looper looper, QueueThreadExceptionHandler exceptionHandler) {
        this.mName = name;
        this.mLooper = looper;
        this.mHandler = new MessageQueueThreadHandler(looper, exceptionHandler);
        this.mAssertionErrorMessage = "Expected to be called from the '" + this.getName() + "' thread!";
    }

    @DoNotStrip
    public void runOnQueue(Runnable runnable) {
        if (this.mIsFinished) {
            FLog.w((String)"React", (String)("Tried to enqueue runnable on already finished thread: '" + this.getName() + "... dropping Runnable."));
        }
        this.mHandler.post(runnable);
    }

    public boolean isOnThread() {
        return this.mLooper.getThread() == Thread.currentThread();
    }

    public void assertIsOnThread() {
        SoftAssertions.assertCondition(this.isOnThread(), this.mAssertionErrorMessage);
    }

    public void quitSynchronous() {
        this.mIsFinished = true;
        this.mLooper.quit();
        if (this.mLooper.getThread() != Thread.currentThread()) {
            try {
                this.mLooper.getThread().join();
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Got interrupted waiting to join thread " + this.mName);
            }
        }
    }

    public Looper getLooper() {
        return this.mLooper;
    }

    public String getName() {
        return this.mName;
    }

    public static MessageQueueThread create(MessageQueueThreadSpec spec, QueueThreadExceptionHandler exceptionHandler) {
        switch (spec.getThreadType()) {
            case MAIN_UI: {
                return MessageQueueThread.createForMainThread(spec.getName(), exceptionHandler);
            }
            case NEW_BACKGROUND: {
                return MessageQueueThread.startNewBackgroundThread(spec.getName(), exceptionHandler);
            }
        }
        throw new RuntimeException("Unknown thread type: " + (Object)((Object)spec.getThreadType()));
    }

    private static MessageQueueThread createForMainThread(String name, QueueThreadExceptionHandler exceptionHandler) {
        Looper mainLooper = Looper.getMainLooper();
        return new MessageQueueThread(name, mainLooper, exceptionHandler);
    }

    private static MessageQueueThread startNewBackgroundThread(String name, QueueThreadExceptionHandler exceptionHandler) {
        final SimpleSettableFuture simpleSettableFuture = new SimpleSettableFuture();
        Thread bgThread = new Thread(new Runnable(){

            @Override
            public void run() {
                Looper.prepare();
                simpleSettableFuture.set(Looper.myLooper());
                Looper.loop();
            }
        }, "mqt_" + name);
        bgThread.start();
        return new MessageQueueThread(name, (Looper)simpleSettableFuture.get(5000L), exceptionHandler);
    }
}

