/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.devsupport;

import android.annotation.TargetApi;
import android.content.Context;
import android.view.Choreographer;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.facebook.common.logging.FLog;
import com.facebook.react.R;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.modules.debug.FpsDebugFrameCallback;
import java.util.Locale;

@TargetApi(value=16)
public class FpsView
extends FrameLayout {
    private static final int UPDATE_INTERVAL_MS = 500;
    private final TextView mTextView;
    private final FpsDebugFrameCallback mFrameCallback;
    private final FPSMonitorRunnable mFPSMonitorRunnable;

    public FpsView(ReactContext reactContext) {
        super((Context)reactContext);
        FpsView.inflate((Context)reactContext, (int)R.layout.fps_view, (ViewGroup)this);
        this.mTextView = (TextView)this.findViewById(R.id.fps_text);
        this.mFrameCallback = new FpsDebugFrameCallback(Choreographer.getInstance(), reactContext);
        this.mFPSMonitorRunnable = new FPSMonitorRunnable();
        this.setCurrentFPS(0.0, 0.0);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mFrameCallback.reset();
        this.mFrameCallback.start();
        this.mFPSMonitorRunnable.start();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mFrameCallback.stop();
        this.mFPSMonitorRunnable.stop();
    }

    private void setCurrentFPS(double currentFPS, double currentJSFPS) {
        String fpsString = String.format(Locale.US, "UI FPS: %.1f\nJS FPS: %.1f", currentFPS, currentJSFPS);
        this.mTextView.setText((CharSequence)fpsString);
        FLog.d((String)"React", (String)fpsString);
    }

    private class FPSMonitorRunnable
    implements Runnable {
        private boolean mShouldStop = false;

        private FPSMonitorRunnable() {
        }

        @Override
        public void run() {
            if (this.mShouldStop) {
                return;
            }
            FpsView.this.setCurrentFPS(FpsView.this.mFrameCallback.getFPS(), FpsView.this.mFrameCallback.getJSFPS());
            FpsView.this.mFrameCallback.reset();
            FpsView.this.postDelayed(this, 500L);
        }

        public void start() {
            this.mShouldStop = false;
            FpsView.this.post(this);
        }

        public void stop() {
            this.mShouldStop = true;
        }
    }
}

