/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import com.facebook.csslayout.CSSAlign;
import com.facebook.csslayout.CSSConstants;
import com.facebook.csslayout.CSSFlexDirection;
import com.facebook.csslayout.CSSJustify;
import com.facebook.csslayout.CSSPositionType;
import com.facebook.csslayout.CSSWrap;
import com.facebook.react.uimanager.CatalystStylesDiffMap;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.ReactShadowNode;
import com.facebook.react.uimanager.ViewProps;
import java.util.Locale;

public class BaseCSSPropertyApplicator {
    private static final String PROP_ON_LAYOUT = "onLayout";

    public static void applyCSSProperties(ReactShadowNode cssNode, CatalystStylesDiffMap props) {
        int i;
        if (props.hasKey("width")) {
            float width = props.getFloat("width", Float.NaN);
            cssNode.setStyleWidth(CSSConstants.isUndefined(width) ? width : PixelUtil.toPixelFromDIP(width));
        }
        if (props.hasKey("height")) {
            float height = props.getFloat("height", Float.NaN);
            cssNode.setStyleHeight(CSSConstants.isUndefined(height) ? height : PixelUtil.toPixelFromDIP(height));
        }
        if (props.hasKey("left")) {
            float left = props.getFloat("left", Float.NaN);
            cssNode.setPositionLeft(CSSConstants.isUndefined(left) ? left : PixelUtil.toPixelFromDIP(left));
        }
        if (props.hasKey("top")) {
            float top = props.getFloat("top", Float.NaN);
            cssNode.setPositionTop(CSSConstants.isUndefined(top) ? top : PixelUtil.toPixelFromDIP(top));
        }
        if (props.hasKey("bottom")) {
            float bottom = props.getFloat("bottom", Float.NaN);
            cssNode.setPositionBottom(CSSConstants.isUndefined(bottom) ? bottom : PixelUtil.toPixelFromDIP(bottom));
        }
        if (props.hasKey("right")) {
            float right = props.getFloat("right", Float.NaN);
            cssNode.setPositionRight(CSSConstants.isUndefined(right) ? right : PixelUtil.toPixelFromDIP(right));
        }
        if (props.hasKey("flex")) {
            cssNode.setFlex(props.getFloat("flex", 0.0f));
        }
        if (props.hasKey("flexDirection")) {
            String flexDirectionString = props.getString("flexDirection");
            cssNode.setFlexDirection(flexDirectionString == null ? CSSFlexDirection.COLUMN : CSSFlexDirection.valueOf(flexDirectionString.toUpperCase(Locale.US)));
        }
        if (props.hasKey("flexWrap")) {
            String flexWrapString = props.getString("flexWrap");
            cssNode.setWrap(flexWrapString == null ? CSSWrap.NOWRAP : CSSWrap.valueOf(flexWrapString.toUpperCase(Locale.US)));
        }
        if (props.hasKey("alignSelf")) {
            String alignSelfString = props.getString("alignSelf");
            cssNode.setAlignSelf(alignSelfString == null ? CSSAlign.AUTO : CSSAlign.valueOf(alignSelfString.toUpperCase(Locale.US).replace("-", "_")));
        }
        if (props.hasKey("alignItems")) {
            String alignItemsString = props.getString("alignItems");
            cssNode.setAlignItems(alignItemsString == null ? CSSAlign.STRETCH : CSSAlign.valueOf(alignItemsString.toUpperCase(Locale.US).replace("-", "_")));
        }
        if (props.hasKey("justifyContent")) {
            String justifyContentString = props.getString("justifyContent");
            cssNode.setJustifyContent(justifyContentString == null ? CSSJustify.FLEX_START : CSSJustify.valueOf(justifyContentString.toUpperCase(Locale.US).replace("-", "_")));
        }
        for (i = 0; i < ViewProps.MARGINS.length; ++i) {
            if (!props.hasKey(ViewProps.MARGINS[i])) continue;
            cssNode.setMargin(ViewProps.PADDING_MARGIN_SPACING_TYPES[i], PixelUtil.toPixelFromDIP(props.getFloat(ViewProps.MARGINS[i], 0.0f)));
        }
        for (i = 0; i < ViewProps.PADDINGS.length; ++i) {
            if (!props.hasKey(ViewProps.PADDINGS[i])) continue;
            float value = props.getFloat(ViewProps.PADDINGS[i], Float.NaN);
            cssNode.setPadding(ViewProps.PADDING_MARGIN_SPACING_TYPES[i], CSSConstants.isUndefined(value) ? value : PixelUtil.toPixelFromDIP(value));
        }
        for (i = 0; i < ViewProps.BORDER_WIDTHS.length; ++i) {
            if (!props.hasKey(ViewProps.BORDER_WIDTHS[i])) continue;
            cssNode.setBorder(ViewProps.BORDER_SPACING_TYPES[i], PixelUtil.toPixelFromDIP(props.getFloat(ViewProps.BORDER_WIDTHS[i], 0.0f)));
        }
        if (props.hasKey("position")) {
            String positionString = props.getString("position");
            CSSPositionType positionType = positionString == null ? CSSPositionType.RELATIVE : CSSPositionType.valueOf(positionString.toUpperCase(Locale.US));
            cssNode.setPositionType(positionType);
        }
        if (props.hasKey(PROP_ON_LAYOUT)) {
            cssNode.setShouldNotifyOnLayout(props.getBoolean(PROP_ON_LAYOUT, false));
        }
    }
}

