/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge;

import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.CallbackImpl;
import com.facebook.react.bridge.CatalystInstance;
import com.facebook.react.bridge.JsonGeneratorHelper;
import com.facebook.react.bridge.NativeArgumentsParseException;
import com.facebook.react.bridge.NativeModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableNativeArray;
import com.facebook.react.bridge.UnexpectedNativeTypeException;
import com.facebook.systrace.Systrace;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public abstract class BaseJavaModule
implements NativeModule {
    @Override
    public final Map<String, NativeModule.NativeMethod> getMethods() {
        HashMap<String, NativeModule.NativeMethod> methods = new HashMap<String, NativeModule.NativeMethod>();
        Method[] targetMethods = this.getClass().getDeclaredMethods();
        for (int i = 0; i < targetMethods.length; ++i) {
            Method targetMethod = targetMethods[i];
            if (targetMethod.getAnnotation(ReactMethod.class) == null) continue;
            String methodName = targetMethod.getName();
            if (methods.containsKey(methodName)) {
                throw new IllegalArgumentException("Java Module " + this.getName() + " method name already registered: " + methodName);
            }
            methods.put(methodName, new JavaMethod(targetMethod));
        }
        return methods;
    }

    @Nullable
    public Map<String, Object> getConstants() {
        return null;
    }

    @Override
    public final void writeConstantsField(JsonGenerator jg, String fieldName) throws IOException {
        Map<String, Object> constants = this.getConstants();
        if (constants == null || constants.isEmpty()) {
            return;
        }
        jg.writeObjectFieldStart(fieldName);
        for (Map.Entry<String, Object> constant : constants.entrySet()) {
            JsonGeneratorHelper.writeObjectField(jg, constant.getKey(), constant.getValue());
        }
        jg.writeEndObject();
    }

    @Override
    public void initialize() {
    }

    @Override
    public void onCatalystInstanceDestroy() {
    }

    private class JavaMethod
    implements NativeModule.NativeMethod {
        private Method method;

        public JavaMethod(Method method) {
            this.method = method;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void invoke(CatalystInstance catalystInstance, ReadableNativeArray parameters) {
            Systrace.beginSection(0L, "callJavaModuleMethod");
            try {
                int i;
                Class<?>[] types = this.method.getParameterTypes();
                if (types.length != parameters.size()) {
                    throw new NativeArgumentsParseException(BaseJavaModule.this.getName() + "." + this.method.getName() + " got " + parameters.size() + " arguments, expected " + types.length);
                }
                Object[] arguments = new Object[types.length];
                try {
                    for (i = 0; i < types.length; ++i) {
                        Class<?> argumentClass = types[i];
                        if (argumentClass == Boolean.class || argumentClass == Boolean.TYPE) {
                            arguments[i] = parameters.getBoolean(i);
                            continue;
                        }
                        if (argumentClass == Integer.class || argumentClass == Integer.TYPE) {
                            arguments[i] = (int)parameters.getDouble(i);
                            continue;
                        }
                        if (argumentClass == Double.class || argumentClass == Double.TYPE) {
                            arguments[i] = parameters.getDouble(i);
                            continue;
                        }
                        if (argumentClass == Float.class || argumentClass == Float.TYPE) {
                            arguments[i] = Float.valueOf((float)parameters.getDouble(i));
                            continue;
                        }
                        if (argumentClass == String.class) {
                            arguments[i] = parameters.getString(i);
                            continue;
                        }
                        if (argumentClass == Callback.class) {
                            if (parameters.isNull(i)) {
                                arguments[i] = null;
                                continue;
                            }
                            int id = (int)parameters.getDouble(i);
                            arguments[i] = new CallbackImpl(catalystInstance, id);
                            continue;
                        }
                        if (argumentClass == ReadableMap.class) {
                            arguments[i] = parameters.getMap(i);
                            continue;
                        }
                        if (argumentClass == ReadableArray.class) {
                            arguments[i] = parameters.getArray(i);
                            continue;
                        }
                        throw new RuntimeException("Got unknown argument class: " + argumentClass.getSimpleName());
                    }
                }
                catch (UnexpectedNativeTypeException e) {
                    throw new NativeArgumentsParseException(e.getMessage() + " (constructing arguments for " + BaseJavaModule.this.getName() + "." + this.method.getName() + " at argument index " + i + ")", e);
                }
                try {
                    this.method.invoke((Object)BaseJavaModule.this, arguments);
                }
                catch (IllegalArgumentException ie) {
                    throw new RuntimeException("Could not invoke " + BaseJavaModule.this.getName() + "." + this.method.getName(), ie);
                }
                catch (IllegalAccessException iae) {
                    throw new RuntimeException("Could not invoke " + BaseJavaModule.this.getName() + "." + this.method.getName(), iae);
                }
                catch (InvocationTargetException ite) {
                    if (ite.getCause() instanceof RuntimeException) {
                        throw (RuntimeException)ite.getCause();
                    }
                    throw new RuntimeException("Could not invoke " + BaseJavaModule.this.getName() + "." + this.method.getName(), ite);
                }
            }
            finally {
                Systrace.endSection(0L);
            }
        }
    }
}

