/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import android.view.View;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.touch.CatalystInterceptingViewGroup;
import com.facebook.react.touch.JSResponderHandler;
import com.facebook.react.uimanager.CatalystStylesDiffMap;
import com.facebook.react.uimanager.ReactShadowNode;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.UIProp;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public abstract class ViewManager<T extends View, C extends ReactShadowNode> {
    private static final Map<Class, Map<String, UIProp.Type>> CLASS_PROP_CACHE = new HashMap<Class, Map<String, UIProp.Type>>();

    public final T createView(ThemedReactContext reactContext, JSResponderHandler jsResponderHandler) {
        T view = this.createViewInstance(reactContext);
        this.addEventEmitters(reactContext, view);
        if (view instanceof CatalystInterceptingViewGroup) {
            ((CatalystInterceptingViewGroup)view).setOnInterceptTouchEventListener(jsResponderHandler);
        }
        return view;
    }

    public abstract String getName();

    public abstract C createCSSNodeInstance();

    protected abstract T createViewInstance(ThemedReactContext var1);

    public void onDropViewInstance(ThemedReactContext reactContext, T view) {
    }

    protected void addEventEmitters(ThemedReactContext reactContext, T view) {
    }

    public abstract void updateView(T var1, CatalystStylesDiffMap var2);

    public abstract void updateExtraData(T var1, Object var2);

    public void receiveCommand(T root, int commandId, @Nullable ReadableArray args) {
    }

    @Nullable
    public Map<String, Integer> getCommandsMap() {
        return null;
    }

    @Nullable
    public Map<String, Object> getExportedCustomBubblingEventTypeConstants() {
        return null;
    }

    @Nullable
    public Map<String, Object> getExportedCustomDirectEventTypeConstants() {
        return null;
    }

    @Nullable
    public Map<String, Object> getExportedViewConstants() {
        return null;
    }

    public Map<String, UIProp.Type> getNativeProps() {
        HashMap<String, UIProp.Type> nativeProps = new HashMap<String, UIProp.Type>();
        Class<?> cls = this.getClass();
        while (cls.getSuperclass() != null) {
            Map<String, UIProp.Type> props = this.getNativePropsForClass(cls);
            for (Map.Entry<String, UIProp.Type> entry : props.entrySet()) {
                nativeProps.put(entry.getKey(), entry.getValue());
            }
            cls = cls.getSuperclass();
        }
        return nativeProps;
    }

    private Map<String, UIProp.Type> getNativePropsForClass(Class cls) {
        Map<String, UIProp.Type> props = CLASS_PROP_CACHE.get(cls);
        if (props != null) {
            return props;
        }
        props = new HashMap<String, UIProp.Type>();
        for (Field f : cls.getDeclaredFields()) {
            UIProp annotation = f.getAnnotation(UIProp.class);
            if (annotation == null) continue;
            UIProp.Type type = annotation.value();
            try {
                String name = (String)f.get(this);
                props.put(name, type);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("UIProp " + cls.getName() + "." + f.getName() + " must be public.");
            }
        }
        CLASS_PROP_CACHE.put(cls, props);
        return props;
    }
}

