/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager.events;

import android.view.MotionEvent;
import com.facebook.react.uimanager.events.Event;
import com.facebook.react.uimanager.events.RCTEventEmitter;
import com.facebook.react.uimanager.events.TouchEventCoalescingKeyHelper;
import com.facebook.react.uimanager.events.TouchEventType;
import com.facebook.react.uimanager.events.TouchesHelper;

public class TouchEvent
extends Event<TouchEvent> {
    private final MotionEvent mMotionEvent;
    private final TouchEventType mTouchEventType;
    private final short mCoalescingKey;

    public TouchEvent(int viewTag, TouchEventType touchEventType, MotionEvent motionEventToCopy) {
        super(viewTag, motionEventToCopy.getEventTime());
        this.mTouchEventType = touchEventType;
        this.mMotionEvent = MotionEvent.obtain((MotionEvent)motionEventToCopy);
        short coalescingKey = 0;
        int action = this.mMotionEvent.getAction() & 0xFF;
        switch (action) {
            case 0: {
                TouchEventCoalescingKeyHelper.addCoalescingKey(this.mMotionEvent.getDownTime());
                break;
            }
            case 1: {
                TouchEventCoalescingKeyHelper.removeCoalescingKey(this.mMotionEvent.getDownTime());
                break;
            }
            case 5: 
            case 6: {
                TouchEventCoalescingKeyHelper.incrementCoalescingKey(this.mMotionEvent.getDownTime());
                break;
            }
            case 2: {
                coalescingKey = TouchEventCoalescingKeyHelper.getCoalescingKey(this.mMotionEvent.getDownTime());
                break;
            }
            case 3: {
                TouchEventCoalescingKeyHelper.removeCoalescingKey(this.mMotionEvent.getDownTime());
                break;
            }
            default: {
                throw new RuntimeException("Unhandled MotionEvent action: " + action);
            }
        }
        this.mCoalescingKey = coalescingKey;
    }

    @Override
    public String getEventName() {
        return this.mTouchEventType.getJSEventName();
    }

    @Override
    public boolean canCoalesce() {
        switch (this.mTouchEventType) {
            case START: 
            case END: 
            case CANCEL: {
                return false;
            }
            case MOVE: {
                return true;
            }
        }
        throw new RuntimeException("Unknown touch event type: " + (Object)((Object)this.mTouchEventType));
    }

    @Override
    public short getCoalescingKey() {
        return this.mCoalescingKey;
    }

    @Override
    public void dispatch(RCTEventEmitter rctEventEmitter) {
        TouchesHelper.sendTouchEvent(rctEventEmitter, this.mTouchEventType, this.getViewTag(), this.mMotionEvent);
    }

    @Override
    public void dispose() {
        this.mMotionEvent.recycle();
    }
}

