/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.progressbar;

import android.content.Context;
import android.util.SparseIntArray;
import android.view.View;
import android.widget.ProgressBar;
import com.facebook.csslayout.CSSNode;
import com.facebook.csslayout.MeasureOutput;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.uimanager.CatalystStylesDiffMap;
import com.facebook.react.uimanager.ReactShadowNode;
import com.facebook.react.views.progressbar.ReactProgressBarViewManager;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;

public class ProgressBarShadowNode
extends ReactShadowNode
implements CSSNode.MeasureFunction {
    @Nullable
    private String style;
    private final SparseIntArray mHeight = new SparseIntArray();
    private final SparseIntArray mWidth = new SparseIntArray();
    private final Set<Integer> mMeasured = new HashSet<Integer>();

    public ProgressBarShadowNode() {
        this.setMeasureFunction(this);
    }

    @Nullable
    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style2) {
        this.style = style2;
    }

    @Override
    public void measure(CSSNode node, float width, MeasureOutput measureOutput) {
        int style2 = ReactProgressBarViewManager.getStyleFromString(this.getStyle());
        if (!this.mMeasured.contains(style2)) {
            ProgressBar progressBar = new ProgressBar((Context)this.getThemedContext(), null, style2);
            int spec = View.MeasureSpec.makeMeasureSpec((int)-2, (int)0);
            progressBar.measure(spec, spec);
            this.mHeight.put(style2, progressBar.getMeasuredHeight());
            this.mWidth.put(style2, progressBar.getMeasuredWidth());
            this.mMeasured.add(style2);
        }
        measureOutput.height = this.mHeight.get(style2);
        measureOutput.width = this.mWidth.get(style2);
    }

    @Override
    public void updateProperties(CatalystStylesDiffMap styles) {
        super.updateProperties(styles);
        if (styles.hasKey("styleAttr")) {
            String style2 = styles.getString("styleAttr");
            Assertions.assertNotNull((Object)style2, (String)"style property should always be set for the progress bar component");
            this.setStyle(style2);
        } else {
            this.setStyle("Large");
        }
    }
}

