/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge.queue;

import android.os.Looper;
import com.facebook.react.bridge.queue.CatalystQueueConfigurationSpec;
import com.facebook.react.bridge.queue.MessageQueueThread;
import com.facebook.react.bridge.queue.MessageQueueThreadSpec;
import com.facebook.react.bridge.queue.QueueThreadExceptionHandler;
import com.facebook.react.common.MapBuilder;
import java.util.HashMap;

public class CatalystQueueConfiguration {
    private final MessageQueueThread mUIQueueThread;
    private final MessageQueueThread mNativeModulesQueueThread;
    private final MessageQueueThread mJSQueueThread;

    private CatalystQueueConfiguration(MessageQueueThread uiQueueThread, MessageQueueThread nativeModulesQueueThread, MessageQueueThread jsQueueThread) {
        this.mUIQueueThread = uiQueueThread;
        this.mNativeModulesQueueThread = nativeModulesQueueThread;
        this.mJSQueueThread = jsQueueThread;
    }

    public MessageQueueThread getUIQueueThread() {
        return this.mUIQueueThread;
    }

    public MessageQueueThread getNativeModulesQueueThread() {
        return this.mNativeModulesQueueThread;
    }

    public MessageQueueThread getJSQueueThread() {
        return this.mJSQueueThread;
    }

    public void destroy() {
        if (this.mNativeModulesQueueThread.getLooper() != Looper.getMainLooper()) {
            this.mNativeModulesQueueThread.quitSynchronous();
        }
        if (this.mJSQueueThread.getLooper() != Looper.getMainLooper()) {
            this.mJSQueueThread.quitSynchronous();
        }
    }

    public static CatalystQueueConfiguration create(CatalystQueueConfigurationSpec spec, QueueThreadExceptionHandler exceptionHandler) {
        MessageQueueThread nativeModulesThread;
        HashMap<MessageQueueThreadSpec, MessageQueueThread> specsToThreads = MapBuilder.newHashMap();
        MessageQueueThreadSpec uiThreadSpec = MessageQueueThreadSpec.mainThreadSpec();
        MessageQueueThread uiThread = MessageQueueThread.create(uiThreadSpec, exceptionHandler);
        specsToThreads.put(uiThreadSpec, uiThread);
        MessageQueueThread jsThread = (MessageQueueThread)specsToThreads.get(spec.getJSQueueThreadSpec());
        if (jsThread == null) {
            jsThread = MessageQueueThread.create(spec.getJSQueueThreadSpec(), exceptionHandler);
        }
        if ((nativeModulesThread = (MessageQueueThread)specsToThreads.get(spec.getNativeModulesQueueThreadSpec())) == null) {
            nativeModulesThread = MessageQueueThread.create(spec.getNativeModulesQueueThreadSpec(), exceptionHandler);
        }
        return new CatalystQueueConfiguration(uiThread, nativeModulesThread, jsThread);
    }
}

