/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import android.util.DisplayMetrics;
import android.widget.ImageView;
import com.facebook.react.common.MapBuilder;
import com.facebook.react.uimanager.PointerEvents;
import com.facebook.react.uimanager.events.TouchEventType;
import java.util.HashMap;
import java.util.Map;

class UIManagerModuleConstants {
    public static final String ACTION_DISMISSED = "dismissed";
    public static final String ACTION_ITEM_SELECTED = "itemSelected";

    UIManagerModuleConstants() {
    }

    static Map getBubblingEventTypeConstants() {
        return MapBuilder.builder().put("topChange", MapBuilder.of("phasedRegistrationNames", MapBuilder.of("bubbled", "onChange", "captured", "onChangeCapture"))).put("topSelect", MapBuilder.of("phasedRegistrationNames", MapBuilder.of("bubbled", "onSelect", "captured", "onSelectCapture"))).put(TouchEventType.START.getJSEventName(), MapBuilder.of("phasedRegistrationNames", MapBuilder.of("bubbled", "onTouchStart", "captured", "onTouchStartCapture"))).put(TouchEventType.MOVE.getJSEventName(), MapBuilder.of("phasedRegistrationNames", MapBuilder.of("bubbled", "onTouchMove", "captured", "onTouchMoveCapture"))).put(TouchEventType.END.getJSEventName(), MapBuilder.of("phasedRegistrationNames", MapBuilder.of("bubbled", "onTouchEnd", "captured", "onTouchEndCapture"))).build();
    }

    static Map getDirectEventTypeConstants() {
        return MapBuilder.builder().put("topSelectionChange", MapBuilder.of("registrationName", "onSelectionChange")).put("topLoadingStart", MapBuilder.of("registrationName", "onLoadingStart")).put("topLoadingFinish", MapBuilder.of("registrationName", "onLoadingFinish")).put("topLoadingError", MapBuilder.of("registrationName", "onLoadingError")).put("topLayout", MapBuilder.of("registrationName", "onLayout")).build();
    }

    public static Map<String, Object> getConstants(DisplayMetrics displayMetrics) {
        HashMap<String, Object> constants = new HashMap<String, Object>();
        constants.put("UIView", MapBuilder.of("ContentMode", MapBuilder.of("ScaleAspectFit", ImageView.ScaleType.CENTER_INSIDE.ordinal(), "ScaleAspectFill", ImageView.ScaleType.CENTER_CROP.ordinal())));
        constants.put("UIText", MapBuilder.of("AutocapitalizationType", MapBuilder.of("none", 1, "characters", 4096, "words", 8192, "sentences", 16384)));
        constants.put("Dimensions", MapBuilder.of("windowPhysicalPixels", MapBuilder.of("width", displayMetrics.widthPixels, "height", displayMetrics.heightPixels, "scale", Float.valueOf(displayMetrics.density), "fontScale", Float.valueOf(displayMetrics.scaledDensity), "densityDpi", displayMetrics.densityDpi)));
        constants.put("StyleConstants", MapBuilder.of("PointerEventsValues", MapBuilder.of("none", PointerEvents.NONE.ordinal(), "boxNone", PointerEvents.BOX_NONE.ordinal(), "boxOnly", PointerEvents.BOX_ONLY.ordinal(), "unspecified", PointerEvents.AUTO.ordinal())));
        constants.put("PopupMenu", MapBuilder.of(ACTION_DISMISSED, ACTION_DISMISSED, ACTION_ITEM_SELECTED, ACTION_ITEM_SELECTED));
        constants.put("AccessibilityEventTypes", MapBuilder.of("typeWindowStateChanged", 32, "typeViewClicked", 1));
        return constants;
    }
}

