/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.textinput;

import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.uimanager.events.Event;
import com.facebook.react.uimanager.events.RCTEventEmitter;

class ReactTextChangedEvent
extends Event<ReactTextChangedEvent> {
    public static final String EVENT_NAME = "topChange";
    private String mText;
    private int mContentWidth;
    private int mContentHeight;
    private int mEventCount;

    public ReactTextChangedEvent(int viewId, long timestampMs, String text, int contentSizeWidth, int contentSizeHeight, int eventCount) {
        super(viewId, timestampMs);
        this.mText = text;
        this.mContentWidth = contentSizeWidth;
        this.mContentHeight = contentSizeHeight;
        this.mEventCount = eventCount;
    }

    @Override
    public String getEventName() {
        return EVENT_NAME;
    }

    @Override
    public void dispatch(RCTEventEmitter rctEventEmitter) {
        rctEventEmitter.receiveEvent(this.getViewTag(), this.getEventName(), this.serializeEventData());
    }

    private WritableMap serializeEventData() {
        WritableMap eventData = Arguments.createMap();
        eventData.putString("text", this.mText);
        WritableMap contentSize = Arguments.createMap();
        contentSize.putDouble("width", this.mContentWidth);
        contentSize.putDouble("height", this.mContentHeight);
        eventData.putMap("contentSize", contentSize);
        eventData.putInt("eventCount", this.mEventCount);
        eventData.putInt("target", this.getViewTag());
        return eventData;
    }
}

