/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.view;

import android.content.Context;
import android.os.Build;
import android.view.View;
import com.facebook.csslayout.CSSConstants;
import com.facebook.react.bridge.JSApplicationIllegalArgumentException;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.common.MapBuilder;
import com.facebook.react.common.annotations.VisibleForTesting;
import com.facebook.react.uimanager.BaseViewPropertyApplicator;
import com.facebook.react.uimanager.CSSColorUtil;
import com.facebook.react.uimanager.CatalystStylesDiffMap;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.PointerEvents;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.UIProp;
import com.facebook.react.uimanager.ViewGroupManager;
import com.facebook.react.uimanager.ViewProps;
import com.facebook.react.views.view.ReactClippingViewGroupHelper;
import com.facebook.react.views.view.ReactDrawableHelper;
import com.facebook.react.views.view.ReactViewGroup;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;

public class ReactViewManager
extends ViewGroupManager<ReactViewGroup> {
    @VisibleForTesting
    public static final String REACT_CLASS = "RCTView";
    private static final int[] SPACING_TYPES = new int[]{8, 0, 2, 1, 3};
    private static final String[] PROPS_BORDER_COLOR = new String[]{"borderColor", "borderLeftColor", "borderRightColor", "borderTopColor", "borderBottomColor"};
    private static final int CMD_HOTSPOT_UPDATE = 1;
    private static final int CMD_SET_PRESSED = 2;
    private static final int[] sLocationBuf = new int[2];
    @UIProp(value=UIProp.Type.STRING)
    public static final String PROP_ACCESSIBLE = "accessible";
    @UIProp(value=UIProp.Type.NUMBER)
    public static final String PROP_BORDER_RADIUS = "borderRadius";
    @UIProp(value=UIProp.Type.STRING)
    public static final String PROP_BORDER_STYLE = "borderStyle";
    @UIProp(value=UIProp.Type.STRING)
    public static final String PROP_POINTER_EVENTS = "pointerEvents";
    @UIProp(value=UIProp.Type.MAP)
    public static final String PROP_NATIVE_BG = "nativeBackgroundAndroid";

    @Override
    public String getName() {
        return REACT_CLASS;
    }

    @Override
    public ReactViewGroup createViewInstance(ThemedReactContext context) {
        return new ReactViewGroup((Context)context);
    }

    @Override
    public Map<String, UIProp.Type> getNativeProps() {
        Map<String, UIProp.Type> nativeProps = super.getNativeProps();
        Map<String, UIProp.Type> baseProps = BaseViewPropertyApplicator.getCommonProps();
        for (Map.Entry<String, UIProp.Type> entry : baseProps.entrySet()) {
            nativeProps.put(entry.getKey(), entry.getValue());
        }
        for (int i = 0; i < SPACING_TYPES.length; ++i) {
            nativeProps.put(ViewProps.BORDER_WIDTHS[i], UIProp.Type.NUMBER);
            nativeProps.put(PROPS_BORDER_COLOR[i], UIProp.Type.STRING);
        }
        return nativeProps;
    }

    @Override
    public void updateView(ReactViewGroup view, CatalystStylesDiffMap props) {
        String pointerEventsStr;
        String key;
        int i;
        super.updateView(view, props);
        ReactClippingViewGroupHelper.applyRemoveClippedSubviewsProperty(view, props);
        for (i = 0; i < SPACING_TYPES.length; ++i) {
            key = ViewProps.BORDER_WIDTHS[i];
            if (!props.hasKey(key)) continue;
            float width = props.getFloat(key, Float.NaN);
            if (!CSSConstants.isUndefined(width)) {
                width = PixelUtil.toPixelFromDIP(width);
            }
            view.setBorderWidth(SPACING_TYPES[i], width);
        }
        for (i = 0; i < SPACING_TYPES.length; ++i) {
            key = PROPS_BORDER_COLOR[i];
            if (!props.hasKey(key)) continue;
            String color = props.getString(key);
            float colorFloat = color == null ? Float.NaN : (float)CSSColorUtil.getColor(color);
            view.setBorderColor(SPACING_TYPES[i], colorFloat);
        }
        if (props.hasKey(PROP_BORDER_RADIUS)) {
            view.setBorderRadius(PixelUtil.toPixelFromDIP(props.getFloat(PROP_BORDER_RADIUS, 0.0f)));
        }
        if (props.hasKey(PROP_BORDER_STYLE)) {
            view.setBorderStyle(props.getString(PROP_BORDER_STYLE));
        }
        if (props.hasKey(PROP_POINTER_EVENTS) && (pointerEventsStr = props.getString(PROP_POINTER_EVENTS)) != null) {
            PointerEvents pointerEvents = PointerEvents.valueOf(pointerEventsStr.toUpperCase(Locale.US).replace("-", "_"));
            view.setPointerEvents(pointerEvents);
        }
        if (props.hasKey(PROP_NATIVE_BG)) {
            ReadableMap map = props.getMap(PROP_NATIVE_BG);
            view.setTranslucentBackgroundDrawable(map == null ? null : ReactDrawableHelper.createDrawableFromJSDescription(view.getContext(), map));
        }
        if (props.hasKey(PROP_ACCESSIBLE)) {
            view.setFocusable(props.getBoolean(PROP_ACCESSIBLE, false));
        }
        if (props.hasKey("needsOffscreenAlphaCompositing")) {
            view.setNeedsOffscreenAlphaCompositing(props.getBoolean("needsOffscreenAlphaCompositing", false));
        }
    }

    @Override
    public Map<String, Integer> getCommandsMap() {
        return MapBuilder.of("hotspotUpdate", 1, "setPressed", 2);
    }

    @Override
    public void receiveCommand(ReactViewGroup root, int commandId, @Nullable ReadableArray args) {
        switch (commandId) {
            case 1: {
                if (args == null || args.size() != 2) {
                    throw new JSApplicationIllegalArgumentException("Illegal number of arguments for 'updateHotspot' command");
                }
                if (Build.VERSION.SDK_INT < 21) break;
                root.getLocationOnScreen(sLocationBuf);
                float x = PixelUtil.toPixelFromDIP(args.getDouble(0)) - (float)sLocationBuf[0];
                float y = PixelUtil.toPixelFromDIP(args.getDouble(1)) - (float)sLocationBuf[1];
                root.drawableHotspotChanged(x, y);
                break;
            }
            case 2: {
                if (args == null || args.size() != 1) {
                    throw new JSApplicationIllegalArgumentException("Illegal number of arguments for 'setPressed' command");
                }
                root.setPressed(args.getBoolean(0));
            }
        }
    }

    @Override
    public void addView(ReactViewGroup parent, View child, int index) {
        boolean removeClippedSubviews = parent.getRemoveClippedSubviews();
        if (removeClippedSubviews) {
            parent.addViewWithSubviewClippingEnabled(child, index);
        } else {
            parent.addView(child, index);
        }
    }

    @Override
    public int getChildCount(ReactViewGroup parent) {
        boolean removeClippedSubviews = parent.getRemoveClippedSubviews();
        if (removeClippedSubviews) {
            return parent.getAllChildrenCount();
        }
        return parent.getChildCount();
    }

    @Override
    public View getChildAt(ReactViewGroup parent, int index) {
        boolean removeClippedSubviews = parent.getRemoveClippedSubviews();
        if (removeClippedSubviews) {
            return parent.getChildAtWithSubviewClippingEnabled(index);
        }
        return parent.getChildAt(index);
    }

    @Override
    public void removeView(ReactViewGroup parent, View child) {
        boolean removeClippedSubviews = parent.getRemoveClippedSubviews();
        if (removeClippedSubviews) {
            if (child.getParent() != null) {
                parent.removeView(child);
            }
            parent.removeViewWithSubviewClippingEnabled(child);
        } else {
            parent.removeView(child);
        }
    }
}

