/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import android.net.Uri;
import android.util.Base64;
import com.facebook.common.executors.CallerThreadExecutor;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.internal.VisibleForTesting;
import com.facebook.imagepipeline.image.EncodedImage;
import com.facebook.imagepipeline.memory.PooledByteBufferFactory;
import com.facebook.imagepipeline.producers.LocalFetchProducer;
import com.facebook.imagepipeline.request.ImageRequest;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.concurrent.Executor;

public class DataFetchProducer
extends LocalFetchProducer {
    private static final String PRODUCER_NAME = "DataFetchProducer";

    public DataFetchProducer(PooledByteBufferFactory pooledByteBufferFactory) {
        super((Executor)CallerThreadExecutor.getInstance(), pooledByteBufferFactory);
    }

    @Override
    protected EncodedImage getEncodedImage(ImageRequest imageRequest) throws IOException {
        byte[] data = DataFetchProducer.getData(imageRequest.getSourceUri().toString());
        return this.getByteBufferBackedEncodedImage(new ByteArrayInputStream(data), data.length);
    }

    @Override
    protected String getProducerName() {
        return PRODUCER_NAME;
    }

    @VisibleForTesting
    static byte[] getData(String uri) {
        Preconditions.checkArgument((boolean)uri.substring(0, 5).equals("data:"));
        int commaPos = uri.indexOf(44);
        String dataStr = uri.substring(commaPos + 1, uri.length());
        if (DataFetchProducer.isBase64(uri.substring(0, commaPos))) {
            return Base64.decode((String)dataStr, (int)0);
        }
        String str = Uri.decode((String)dataStr);
        byte[] b = str.getBytes();
        return b;
    }

    @VisibleForTesting
    static boolean isBase64(String prefix) {
        if (!prefix.contains(";")) {
            return false;
        }
        String[] parameters = prefix.split(";");
        return parameters[parameters.length - 1].equals("base64");
    }
}

