import { ScreenHit, TimingHit, EventHit, ExceptionHit, SocialHit } from "./Hit";
import { CustomDimensionsFieldIndexMap } from "./CustomValues";
/**
 * @typicalname tracker
 */
declare class NewGoogleAnalyticsTracker {
    id: string;
    customDimensionsFieldsIndexMap: CustomDimensionsFieldIndexMap;
    /**
     * Save all tracker related data that is needed to call native methods with proper data.
     * @param {string} trackerId Your tracker id, something like: UA-12345-1
     * @param {{fieldName: fieldIndex}} customDimensionsFieldsIndexMap Custom dimensions field/index pairs
     * @example
     * ```js
     * import { GoogleAnalyticsTracker } from 'react-native-google-analytics-bridge';
     * let tracker = new GoogleAnalyticsTracker('UA-12345-1');
     * ```
     */
    constructor(trackerId: string, customDimensionsFieldsIndexMap?: CustomDimensionsFieldIndexMap);
    /**
     *
     *
     * @param {string} screenName
     * @memberof NewGoogleAnalyticsTracker
     */
    trackScreen(screenName: string): void;
    /**
     *
     *
     * @param {ScreenHit} hit
     * @memberof NewGoogleAnalyticsTracker
     */
    trackScreenHit(hit: ScreenHit): void;
    /**
     *
     *
     * @param {string} category
     * @param {string} action
     * @param {string} [label=null]
     * @param {number} [value=null]
     * @memberof NewGoogleAnalyticsTracker
     */
    trackEvent(category: string, action: string, label?: string, value?: number): void;
    /**
     *
     *
     * @param {EventHit} hit
     * @memberof NewGoogleAnalyticsTracker
     */
    trackEvenHit(hit: EventHit): void;
    /**
     *
     *
     * @param {string} category
     * @param {number} interval
     * @param {string} name
     * @param {string} [label=null]
     * @memberof NewGoogleAnalyticsTracker
     */
    trackTiming(category: string, interval: number, name: string, label?: string): void;
    /**
     *
     *
     * @param {TimingHit} hit
     * @memberof NewGoogleAnalyticsTracker
     */
    trackTimingHit(hit: TimingHit): void;
    /**
     *
     *
     * @param {string} error
     * @param {boolean} [fatal=false]
     * @memberof NewGoogleAnalyticsTracker
     */
    trackException(error: string, fatal?: boolean): void;
    /**
     *
     *
     * @param {ExceptionHit} hit
     * @memberof NewGoogleAnalyticsTracker
     */
    trackExceptionHit(hit: ExceptionHit): void;
    /**
     *
     *
     * @param {string} network
     * @param {string} action
     * @param {string} targetUrl
     * @memberof NewGoogleAnalyticsTracker
     */
    trackSocial(network: string, action: string, targetUrl: string): void;
    /**
     *
     *
     * @param {SocialHit} hit
     * @memberof NewGoogleAnalyticsTracker
     */
    trackSocialHit(hit: SocialHit): void;
    /**
     * Sets the current userId for tracking.
     * @param {string} userId The current userId
     */
    setUser(userId: string): void;
    /**
     * Sets the current clientId for tracking.
     * @param {string} clientId The current userId
     */
    setClient(clientId: string): void;
    /**
     * Sets if IDFA (identifier for advertisers) collection should be enabled
     * @param  {boolean} enabled (Optional) Defaults to true
     */
    allowIDFA(enabled?: boolean): void;
    /**
     * Sets the trackers appName
     * The Bundle name is used by default
     * @param {string} appName (Required) The app name
     */
    setAppName(appName: string): void;
    /**
     * Sets the trackers appVersion
     * @param {string} appVersion (Required) The app version
     */
    setAppVersion(appVersion: string): void;
    /**
     * Sets if AnonymizeIp is enabled
     * If enabled the last octet of the IP address will be removed
     * @param {boolean} enabled (Required) Enable anonymize IP
     */
    setAnonymizeIp(enabled: boolean): void;
    /**
     * Sets tracker sampling rate.
     * @param {number} sampleRatio (Required) Percentage 0 - 100
     */
    setSamplingRate(sampleRatio: number): void;
    /**
     * Sets the currency for tracking.
     * @param {string} currencyCode (Required) The currency ISO 4217 code
     */
    setCurrency(currencyCode: string): void;
    /**
     * Sets if uncaught exceptions should be tracked
     * Important to note: On iOS this option is set on all trackers. On Android it is set per tracker.
     * If you are using multiple trackers on iOS, this will enable & disable on all trackers.
     * @param {boolean} enabled Should enable uncaught exception tracking
     */
    setTrackUncaughtExceptions(enabled: boolean): void;
    /**
     * If Tracker has customDimensionsFieldsIndexMap, it will transform
     * customDimensions map pairs {field: value} to {fieldIndex: value}.
     * Otherwise customDimensions are passed trough untouched.
     * Underlying native methods will transform provided customDimensions map to expected format.
     * Google analytics expect dimensions to be tracker with 'dimension{index}' keys,
     * not dimension field names.
     * @ignore
     * @param {{fieldName: value}} customDimensions
     * @returns {{fieldIndex: value}}
     */
    private transformCustomDimensionsFieldsToIndexes(customDimensions);
    /**
     * Transforms payload so it is valid for native side
     *
     * @ignore
     */
    private sanitizePayload(payload);
}
export default NewGoogleAnalyticsTracker;
