/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.netinfo;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.support.v4.net.ConnectivityManagerCompat;
import com.facebook.common.logging.FLog;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.LifecycleEventListener;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.bridge.WritableNativeMap;
import com.facebook.react.modules.core.DeviceEventManagerModule;

public class NetInfoModule
extends ReactContextBaseJavaModule
implements LifecycleEventListener {
    private static final String CONNECTION_TYPE_NONE = "NONE";
    private static final String CONNECTION_TYPE_UNKNOWN = "UNKNOWN";
    private static final String MISSING_PERMISSION_MESSAGE = "To use NetInfo on Android, add the following to your AndroidManifest.xml:\n<uses-permission android:name=\"android.permission.ACCESS_NETWORK_STATE\" />";
    private final ConnectivityManager mConnectivityManager;
    private final ConnectivityManagerCompat mConnectivityManagerCompat;
    private final ConnectivityBroadcastReceiver mConnectivityBroadcastReceiver;
    private boolean mNoNetworkPermission = false;
    private String mConnectivity = "";

    public NetInfoModule(ReactApplicationContext reactContext) {
        super(reactContext);
        this.mConnectivityManager = (ConnectivityManager)reactContext.getSystemService("connectivity");
        this.mConnectivityManagerCompat = new ConnectivityManagerCompat();
        this.mConnectivityBroadcastReceiver = new ConnectivityBroadcastReceiver();
    }

    @Override
    public void onHostResume() {
        this.registerReceiver();
    }

    @Override
    public void onHostPause() {
        this.unregisterReceiver();
    }

    @Override
    public void onHostDestroy() {
    }

    @Override
    public void initialize() {
        this.getReactApplicationContext().addLifecycleEventListener(this);
    }

    @Override
    public String getName() {
        return "NetInfo";
    }

    @ReactMethod
    public void getCurrentConnectivity(Callback successCallback, Callback errorCallback) {
        if (this.mNoNetworkPermission) {
            if (errorCallback == null) {
                FLog.e((String)"React", (String)MISSING_PERMISSION_MESSAGE);
                return;
            }
            errorCallback.invoke(MISSING_PERMISSION_MESSAGE);
            return;
        }
        successCallback.invoke(this.createConnectivityEventMap());
    }

    @ReactMethod
    public void isConnectionMetered(Callback successCallback) {
        if (this.mNoNetworkPermission) {
            FLog.e((String)"React", (String)MISSING_PERMISSION_MESSAGE);
            return;
        }
        Object[] objectArray = new Object[1];
        objectArray[0] = ConnectivityManagerCompat.isActiveNetworkMetered((ConnectivityManager)this.mConnectivityManager);
        successCallback.invoke(objectArray);
    }

    private void registerReceiver() {
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
        this.getReactApplicationContext().registerReceiver(this.mConnectivityBroadcastReceiver, filter);
    }

    private void unregisterReceiver() {
        this.getReactApplicationContext().unregisterReceiver(this.mConnectivityBroadcastReceiver);
    }

    private void updateAndSendConnectionType() {
        String currentConnectivity = this.getCurrentConnectionType();
        if (!currentConnectivity.equalsIgnoreCase(this.mConnectivity)) {
            this.mConnectivity = currentConnectivity;
            this.sendConnectivityChangedEvent();
        }
    }

    private String getCurrentConnectionType() {
        try {
            NetworkInfo networkInfo = this.mConnectivityManager.getActiveNetworkInfo();
            if (networkInfo == null || !networkInfo.isConnected()) {
                return CONNECTION_TYPE_NONE;
            }
            if (ConnectivityManager.isNetworkTypeValid((int)networkInfo.getType())) {
                return networkInfo.getTypeName().toUpperCase();
            }
            return CONNECTION_TYPE_UNKNOWN;
        }
        catch (SecurityException e) {
            this.mNoNetworkPermission = true;
            return CONNECTION_TYPE_UNKNOWN;
        }
    }

    private void sendConnectivityChangedEvent() {
        this.getReactApplicationContext().getJSModule(DeviceEventManagerModule.RCTDeviceEventEmitter.class).emit("networkStatusDidChange", this.createConnectivityEventMap());
    }

    private WritableMap createConnectivityEventMap() {
        WritableNativeMap event = new WritableNativeMap();
        event.putString("network_info", this.mConnectivity);
        return event;
    }

    private class ConnectivityBroadcastReceiver
    extends BroadcastReceiver {
        private ConnectivityBroadcastReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals("android.net.conn.CONNECTIVITY_CHANGE")) {
                NetInfoModule.this.updateAndSendConnectionType();
            }
        }
    }
}

