/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.csslayout;

import com.facebook.csslayout.CSSConstants;
import com.facebook.csslayout.FloatUtil;
import java.util.Arrays;
import javax.annotation.Nullable;

public class Spacing {
    public static final int LEFT = 0;
    public static final int TOP = 1;
    public static final int RIGHT = 2;
    public static final int BOTTOM = 3;
    public static final int VERTICAL = 4;
    public static final int HORIZONTAL = 5;
    public static final int START = 6;
    public static final int END = 7;
    public static final int ALL = 8;
    private static final int[] sFlagsMap = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256};
    private final float[] mSpacing = Spacing.newFullSpacingArray();
    @Nullable
    private float[] mDefaultSpacing = null;
    private int mValueFlags = 0;
    private boolean mHasAliasesSet;

    public boolean set(int spacingType, float value) {
        if (!FloatUtil.floatsEqual(this.mSpacing[spacingType], value)) {
            this.mSpacing[spacingType] = value;
            this.mValueFlags = CSSConstants.isUndefined(value) ? (this.mValueFlags &= ~sFlagsMap[spacingType]) : (this.mValueFlags |= sFlagsMap[spacingType]);
            this.mHasAliasesSet = (this.mValueFlags & sFlagsMap[8]) != 0 || (this.mValueFlags & sFlagsMap[4]) != 0 || (this.mValueFlags & sFlagsMap[5]) != 0;
            return true;
        }
        return false;
    }

    public boolean setDefault(int spacingType, float value) {
        if (this.mDefaultSpacing == null) {
            this.mDefaultSpacing = Spacing.newSpacingResultArray();
        }
        if (!FloatUtil.floatsEqual(this.mDefaultSpacing[spacingType], value)) {
            this.mDefaultSpacing[spacingType] = value;
            return true;
        }
        return false;
    }

    public float get(int spacingType) {
        float defaultValue;
        float f = this.mDefaultSpacing != null ? this.mDefaultSpacing[spacingType] : (defaultValue = spacingType == 6 || spacingType == 7 ? Float.NaN : 0.0f);
        if (this.mValueFlags == 0) {
            return defaultValue;
        }
        if ((this.mValueFlags & sFlagsMap[spacingType]) != 0) {
            return this.mSpacing[spacingType];
        }
        if (this.mHasAliasesSet) {
            int secondType;
            int n = secondType = spacingType == 1 || spacingType == 3 ? 4 : 5;
            if ((this.mValueFlags & sFlagsMap[secondType]) != 0) {
                return this.mSpacing[secondType];
            }
            if ((this.mValueFlags & sFlagsMap[8]) != 0) {
                return this.mSpacing[8];
            }
        }
        return defaultValue;
    }

    public float getRaw(int spacingType) {
        return this.mSpacing[spacingType];
    }

    void reset() {
        Arrays.fill(this.mSpacing, Float.NaN);
        this.mDefaultSpacing = null;
        this.mHasAliasesSet = false;
        this.mValueFlags = 0;
    }

    float getWithFallback(int spacingType, int fallbackType) {
        return (this.mValueFlags & sFlagsMap[spacingType]) != 0 ? this.mSpacing[spacingType] : this.get(fallbackType);
    }

    private static float[] newFullSpacingArray() {
        return new float[]{Float.NaN, Float.NaN, Float.NaN, Float.NaN, Float.NaN, Float.NaN, Float.NaN, Float.NaN, Float.NaN};
    }

    private static float[] newSpacingResultArray() {
        return Spacing.newSpacingResultArray(0.0f);
    }

    private static float[] newSpacingResultArray(float defaultValue) {
        return new float[]{defaultValue, defaultValue, defaultValue, defaultValue, defaultValue, defaultValue, Float.NaN, Float.NaN, defaultValue};
    }
}

