/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.os.Bundle;
import android.view.LayoutInflater;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.bridge.ActivityEventListener;
import com.facebook.react.bridge.CatalystInstance;
import com.facebook.react.bridge.JavaScriptModule;
import com.facebook.react.bridge.LifecycleEventListener;
import com.facebook.react.bridge.NativeModule;
import com.facebook.react.bridge.NativeModuleCallExceptionHandler;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.bridge.queue.CatalystQueueConfiguration;
import com.facebook.react.bridge.queue.MessageQueueThread;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.annotation.Nullable;

public class ReactContext
extends ContextWrapper {
    private final CopyOnWriteArraySet<LifecycleEventListener> mLifecycleEventListeners = new CopyOnWriteArraySet();
    private final CopyOnWriteArraySet<ActivityEventListener> mActivityEventListeners = new CopyOnWriteArraySet();
    @Nullable
    private CatalystInstance mCatalystInstance;
    @Nullable
    private LayoutInflater mInflater;
    @Nullable
    private MessageQueueThread mUiMessageQueueThread;
    @Nullable
    private MessageQueueThread mNativeModulesMessageQueueThread;
    @Nullable
    private MessageQueueThread mJSMessageQueueThread;
    @Nullable
    private NativeModuleCallExceptionHandler mNativeModuleCallExceptionHandler;
    @Nullable
    private Activity mCurrentActivity;

    public ReactContext(Context base) {
        super(base);
    }

    public void initializeWithInstance(CatalystInstance catalystInstance) {
        if (catalystInstance == null) {
            throw new IllegalArgumentException("CatalystInstance cannot be null.");
        }
        if (this.mCatalystInstance != null) {
            throw new IllegalStateException("ReactContext has been already initialized");
        }
        this.mCatalystInstance = catalystInstance;
        CatalystQueueConfiguration queueConfig = catalystInstance.getCatalystQueueConfiguration();
        this.mUiMessageQueueThread = queueConfig.getUIQueueThread();
        this.mNativeModulesMessageQueueThread = queueConfig.getNativeModulesQueueThread();
        this.mJSMessageQueueThread = queueConfig.getJSQueueThread();
    }

    public void setNativeModuleCallExceptionHandler(@Nullable NativeModuleCallExceptionHandler nativeModuleCallExceptionHandler) {
        this.mNativeModuleCallExceptionHandler = nativeModuleCallExceptionHandler;
    }

    public Object getSystemService(String name) {
        if ("layout_inflater".equals(name)) {
            if (this.mInflater == null) {
                this.mInflater = LayoutInflater.from((Context)this.getBaseContext()).cloneInContext((Context)this);
            }
            return this.mInflater;
        }
        return this.getBaseContext().getSystemService(name);
    }

    public <T extends JavaScriptModule> T getJSModule(Class<T> jsInterface) {
        if (this.mCatalystInstance == null) {
            throw new RuntimeException("Trying to invoke JS before CatalystInstance has been set!");
        }
        return this.mCatalystInstance.getJSModule(jsInterface);
    }

    public <T extends NativeModule> T getNativeModule(Class<T> nativeModuleInterface) {
        if (this.mCatalystInstance == null) {
            throw new RuntimeException("Trying to invoke JS before CatalystInstance has been set!");
        }
        return this.mCatalystInstance.getNativeModule(nativeModuleInterface);
    }

    public CatalystInstance getCatalystInstance() {
        return (CatalystInstance)Assertions.assertNotNull((Object)this.mCatalystInstance);
    }

    public boolean hasActiveCatalystInstance() {
        return this.mCatalystInstance != null && !this.mCatalystInstance.isDestroyed();
    }

    public void addLifecycleEventListener(LifecycleEventListener listener) {
        this.mLifecycleEventListeners.add(listener);
    }

    public void removeLifecycleEventListener(LifecycleEventListener listener) {
        this.mLifecycleEventListeners.remove(listener);
    }

    public void addActivityEventListener(ActivityEventListener listener) {
        this.mActivityEventListeners.add(listener);
    }

    public void removeActivityEventListener(ActivityEventListener listener) {
        this.mActivityEventListeners.remove(listener);
    }

    public void onResume(@Nullable Activity activity) {
        UiThreadUtil.assertOnUiThread();
        this.mCurrentActivity = activity;
        for (LifecycleEventListener listener : this.mLifecycleEventListeners) {
            listener.onHostResume();
        }
    }

    public void onPause() {
        UiThreadUtil.assertOnUiThread();
        for (LifecycleEventListener listener : this.mLifecycleEventListeners) {
            listener.onHostPause();
        }
    }

    public void onDestroy() {
        UiThreadUtil.assertOnUiThread();
        for (LifecycleEventListener listener : this.mLifecycleEventListeners) {
            listener.onHostDestroy();
        }
        if (this.mCatalystInstance != null) {
            this.mCatalystInstance.destroy();
        }
        this.mCurrentActivity = null;
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        for (ActivityEventListener listener : this.mActivityEventListeners) {
            listener.onActivityResult(requestCode, resultCode, data);
        }
    }

    public void assertOnUiQueueThread() {
        ((MessageQueueThread)Assertions.assertNotNull((Object)this.mUiMessageQueueThread)).assertIsOnThread();
    }

    public boolean isOnUiQueueThread() {
        return ((MessageQueueThread)Assertions.assertNotNull((Object)this.mUiMessageQueueThread)).isOnThread();
    }

    public void runOnUiQueueThread(Runnable runnable) {
        ((MessageQueueThread)Assertions.assertNotNull((Object)this.mUiMessageQueueThread)).runOnQueue(runnable);
    }

    public void assertOnNativeModulesQueueThread() {
        ((MessageQueueThread)Assertions.assertNotNull((Object)this.mNativeModulesMessageQueueThread)).assertIsOnThread();
    }

    public boolean isOnNativeModulesQueueThread() {
        return ((MessageQueueThread)Assertions.assertNotNull((Object)this.mNativeModulesMessageQueueThread)).isOnThread();
    }

    public void runOnNativeModulesQueueThread(Runnable runnable) {
        ((MessageQueueThread)Assertions.assertNotNull((Object)this.mNativeModulesMessageQueueThread)).runOnQueue(runnable);
    }

    public void assertOnJSQueueThread() {
        ((MessageQueueThread)Assertions.assertNotNull((Object)this.mJSMessageQueueThread)).assertIsOnThread();
    }

    public boolean isOnJSQueueThread() {
        return ((MessageQueueThread)Assertions.assertNotNull((Object)this.mJSMessageQueueThread)).isOnThread();
    }

    public void runOnJSQueueThread(Runnable runnable) {
        ((MessageQueueThread)Assertions.assertNotNull((Object)this.mJSMessageQueueThread)).runOnQueue(runnable);
    }

    public void handleException(RuntimeException e) {
        if (this.mCatalystInstance == null || this.mCatalystInstance.isDestroyed() || this.mNativeModuleCallExceptionHandler == null) {
            throw e;
        }
        this.mNativeModuleCallExceptionHandler.handleException(e);
    }

    public boolean hasCurrentActivity() {
        return this.mCurrentActivity != null;
    }

    public boolean startActivityForResult(Intent intent, int code, Bundle bundle) {
        Assertions.assertNotNull((Object)this.mCurrentActivity);
        this.mCurrentActivity.startActivityForResult(intent, code, bundle);
        return true;
    }

    @Nullable
    Activity getCurrentActivity() {
        return this.mCurrentActivity;
    }
}

