/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.viewpager;

import android.content.Context;
import android.os.SystemClock;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.uimanager.UIManagerModule;
import com.facebook.react.uimanager.events.EventDispatcher;
import com.facebook.react.uimanager.events.NativeGestureUtil;
import com.facebook.react.views.viewpager.PageScrollEvent;
import com.facebook.react.views.viewpager.PageSelectedEvent;
import java.util.ArrayList;
import java.util.List;

class ReactViewPager
extends ViewPager {
    private final EventDispatcher mEventDispatcher;
    private boolean mIsCurrentItemFromJs;

    public ReactViewPager(ReactContext reactContext) {
        super((Context)reactContext);
        this.mEventDispatcher = reactContext.getNativeModule(UIManagerModule.class).getEventDispatcher();
        this.mIsCurrentItemFromJs = false;
        this.setOnPageChangeListener(new PageChangeListener());
        this.setAdapter(new Adapter());
    }

    public Adapter getAdapter() {
        return (Adapter)super.getAdapter();
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (super.onInterceptTouchEvent(ev)) {
            NativeGestureUtil.notifyNativeGestureStarted((View)this, ev);
            return true;
        }
        return false;
    }

    public void setCurrentItemFromJs(int item, boolean animated) {
        this.mIsCurrentItemFromJs = true;
        this.setCurrentItem(item, animated);
        this.mIsCurrentItemFromJs = false;
    }

    void addViewToAdapter(View child, int index) {
        this.getAdapter().addView(child, index);
    }

    void removeViewFromAdapter(int index) {
        this.getAdapter().removeViewAt(index);
    }

    int getViewCountInAdapter() {
        return this.getAdapter().getCount();
    }

    View getViewFromAdapter(int index) {
        return this.getAdapter().getViewAt(index);
    }

    private class PageChangeListener
    implements ViewPager.OnPageChangeListener {
        private PageChangeListener() {
        }

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            ReactViewPager.this.mEventDispatcher.dispatchEvent(new PageScrollEvent(ReactViewPager.this.getId(), SystemClock.uptimeMillis(), position, positionOffset));
        }

        public void onPageSelected(int position) {
            if (!ReactViewPager.this.mIsCurrentItemFromJs) {
                ReactViewPager.this.mEventDispatcher.dispatchEvent(new PageSelectedEvent(ReactViewPager.this.getId(), SystemClock.uptimeMillis(), position));
            }
        }

        public void onPageScrollStateChanged(int state) {
        }
    }

    private class Adapter
    extends PagerAdapter {
        private List<View> mViews = new ArrayList<View>();

        private Adapter() {
        }

        void addView(View child, int index) {
            this.mViews.add(index, child);
            this.notifyDataSetChanged();
            ReactViewPager.this.setOffscreenPageLimit(this.mViews.size());
        }

        void removeViewAt(int index) {
            this.mViews.remove(index);
            this.notifyDataSetChanged();
            ReactViewPager.this.setOffscreenPageLimit(this.mViews.size());
        }

        View getViewAt(int index) {
            return this.mViews.get(index);
        }

        public int getCount() {
            return this.mViews.size();
        }

        public Object instantiateItem(ViewGroup container, int position) {
            View view = this.mViews.get(position);
            container.addView(view, 0, ReactViewPager.this.generateDefaultLayoutParams());
            return view;
        }

        public void destroyItem(ViewGroup container, int position, Object object) {
            View view = this.mViews.get(position);
            container.removeView(view);
        }

        public boolean isViewFromObject(View view, Object object) {
            return view == object;
        }
    }
}

