/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.devsupport;

import android.os.Handler;
import android.os.Looper;
import com.facebook.common.logging.FLog;
import com.facebook.react.bridge.Inspector;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.ws.WebSocket;
import okhttp3.ws.WebSocketCall;
import okhttp3.ws.WebSocketListener;
import okio.Buffer;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class InspectorPackagerConnection {
    private static final String TAG = "InspectorPackagerConnection";
    private final Connection mConnection;
    private final Map<String, Inspector.LocalConnection> mInspectorConnections;

    public InspectorPackagerConnection(String url) {
        this.mConnection = new Connection(url);
        this.mInspectorConnections = new HashMap<String, Inspector.LocalConnection>();
    }

    public void connect() {
        this.mConnection.connect();
    }

    public void closeQuietly() {
        this.mConnection.close();
    }

    public void sendOpenEvent(String pageId) {
        try {
            JSONObject payload = this.makePageIdPayload(pageId);
            this.sendEvent("open", payload);
        }
        catch (IOException | JSONException e) {
            FLog.e((String)TAG, (String)"Failed to open page", (Throwable)e);
        }
    }

    void handleProxyMessage(JSONObject message) throws JSONException, IOException {
        String event;
        switch (event = message.getString("event")) {
            case "getPages": {
                this.sendEvent("getPages", this.getPages());
                break;
            }
            case "wrappedEvent": {
                this.handleWrappedEvent(message.getJSONObject("payload"));
                break;
            }
            case "connect": {
                this.handleConnect(message.getJSONObject("payload"));
                break;
            }
            case "disconnect": {
                this.handleDisconnect(message.getJSONObject("payload"));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown event: " + event);
            }
        }
    }

    void closeAllConnections() {
        for (Map.Entry<String, Inspector.LocalConnection> entry : this.mInspectorConnections.entrySet()) {
            entry.getValue().disconnect();
        }
        this.mInspectorConnections.clear();
    }

    private void handleConnect(JSONObject payload) throws JSONException, IOException {
        final String pageId = payload.getString("pageId");
        Inspector.LocalConnection inspectorConnection = this.mInspectorConnections.remove(pageId);
        if (inspectorConnection != null) {
            throw new IllegalStateException("Already connected: " + pageId);
        }
        try {
            inspectorConnection = Inspector.connect(Integer.parseInt(pageId), new Inspector.RemoteConnection(){

                @Override
                public void onMessage(String message) {
                    try {
                        InspectorPackagerConnection.this.sendWrappedEvent(pageId, message);
                    }
                    catch (IOException | JSONException e) {
                        FLog.w((String)InspectorPackagerConnection.TAG, (String)"Couldn't send event to packager", (Throwable)e);
                    }
                }

                @Override
                public void onDisconnect() {
                    try {
                        InspectorPackagerConnection.this.mInspectorConnections.remove(pageId);
                        InspectorPackagerConnection.this.sendEvent("disconnect", InspectorPackagerConnection.this.makePageIdPayload(pageId));
                    }
                    catch (IOException | JSONException e) {
                        FLog.w((String)InspectorPackagerConnection.TAG, (String)"Couldn't send event to packager", (Throwable)e);
                    }
                }
            });
            this.mInspectorConnections.put(pageId, inspectorConnection);
        }
        catch (Exception e) {
            FLog.w((String)TAG, (String)("Failed to open page: " + pageId), (Throwable)e);
            this.sendEvent("disconnect", this.makePageIdPayload(pageId));
        }
    }

    private void handleDisconnect(JSONObject payload) throws JSONException {
        String pageId = payload.getString("pageId");
        Inspector.LocalConnection inspectorConnection = this.mInspectorConnections.remove(pageId);
        if (inspectorConnection == null) {
            return;
        }
        inspectorConnection.disconnect();
    }

    private void handleWrappedEvent(JSONObject payload) throws JSONException, IOException {
        String pageId = payload.getString("pageId");
        String wrappedEvent = payload.getString("wrappedEvent");
        Inspector.LocalConnection inspectorConnection = this.mInspectorConnections.get(pageId);
        if (inspectorConnection == null) {
            throw new IllegalStateException("Not connected: " + pageId);
        }
        inspectorConnection.sendMessage(wrappedEvent);
    }

    private JSONArray getPages() throws JSONException {
        List<Inspector.Page> pages = Inspector.getPages();
        JSONArray array = new JSONArray();
        for (Inspector.Page page : pages) {
            JSONObject jsonPage = new JSONObject();
            jsonPage.put("id", (Object)String.valueOf(page.getId()));
            jsonPage.put("title", (Object)page.getTitle());
            array.put((Object)jsonPage);
        }
        return array;
    }

    private void sendWrappedEvent(String pageId, String message) throws IOException, JSONException {
        JSONObject payload = new JSONObject();
        payload.put("pageId", (Object)pageId);
        payload.put("wrappedEvent", (Object)message);
        this.sendEvent("wrappedEvent", payload);
    }

    private void sendEvent(String name, Object payload) throws JSONException, IOException {
        JSONObject jsonMessage = new JSONObject();
        jsonMessage.put("event", (Object)name);
        jsonMessage.put("payload", payload);
        this.mConnection.send(jsonMessage);
    }

    private JSONObject makePageIdPayload(String pageId) throws JSONException {
        JSONObject payload = new JSONObject();
        payload.put("pageId", (Object)pageId);
        return payload;
    }

    private class Connection
    implements WebSocketListener {
        private static final int RECONNECT_DELAY_MS = 2000;
        private final String mUrl;
        @Nullable
        private WebSocket mWebSocket;
        private final Handler mHandler;
        private boolean mClosed;
        private boolean mSuppressConnectionErrors;

        public Connection(String url) {
            this.mUrl = url;
            this.mHandler = new Handler(Looper.getMainLooper());
        }

        public void onOpen(WebSocket webSocket, Response response) {
            this.mWebSocket = webSocket;
        }

        public void onFailure(IOException e, Response response) {
            if (this.mWebSocket != null) {
                this.abort("Websocket exception", e);
            }
            if (!this.mClosed) {
                this.reconnect();
            }
        }

        public void onMessage(ResponseBody message) throws IOException {
            try {
                InspectorPackagerConnection.this.handleProxyMessage(new JSONObject(message.string()));
            }
            catch (JSONException e) {
                throw new IOException(e);
            }
            finally {
                message.close();
            }
        }

        public void onPong(Buffer payload) {
        }

        public void onClose(int code, String reason) {
            this.mWebSocket = null;
            InspectorPackagerConnection.this.closeAllConnections();
            if (!this.mClosed) {
                this.reconnect();
            }
        }

        public void connect() {
            if (this.mClosed) {
                throw new IllegalStateException("Can't connect closed client");
            }
            OkHttpClient httpClient = new OkHttpClient.Builder().connectTimeout(10L, TimeUnit.SECONDS).writeTimeout(10L, TimeUnit.SECONDS).readTimeout(0L, TimeUnit.MINUTES).build();
            Request request = new Request.Builder().url(this.mUrl).build();
            WebSocketCall call = WebSocketCall.create((OkHttpClient)httpClient, (Request)request);
            call.enqueue((WebSocketListener)this);
        }

        private void reconnect() {
            if (this.mClosed) {
                throw new IllegalStateException("Can't reconnect closed client");
            }
            if (!this.mSuppressConnectionErrors) {
                FLog.w((String)InspectorPackagerConnection.TAG, (String)"Couldn't connect to packager, will silently retry");
                this.mSuppressConnectionErrors = true;
            }
            this.mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (!Connection.this.mClosed) {
                        Connection.this.connect();
                    }
                }
            }, 2000L);
        }

        public void close() {
            this.mClosed = true;
            if (this.mWebSocket != null) {
                try {
                    this.mWebSocket.close(1000, "End of session");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.mWebSocket = null;
            }
        }

        public void send(JSONObject object) throws IOException {
            if (this.mWebSocket == null) {
                return;
            }
            this.mWebSocket.sendMessage(RequestBody.create((MediaType)WebSocket.TEXT, (String)object.toString()));
        }

        private void abort(String message, Throwable cause) {
            FLog.e((String)InspectorPackagerConnection.TAG, (String)("Error occurred, shutting down websocket connection: " + message), (Throwable)cause);
            InspectorPackagerConnection.this.closeAllConnections();
            this.closeWebSocketQuietly();
        }

        private void closeWebSocketQuietly() {
            if (this.mWebSocket != null) {
                try {
                    this.mWebSocket.close(1000, "End of session");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.mWebSocket = null;
            }
        }
    }
}

