/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.flat;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.DashPathEffect;
import android.graphics.Paint;
import android.graphics.Path;
import com.facebook.react.flat.AbstractDrawBorder;
import javax.annotation.Nullable;

final class DrawBorder
extends AbstractDrawBorder {
    private static final Paint PAINT = new Paint(1);
    private static final float[] TMP_FLOAT_ARRAY = new float[4];
    private static final int BORDER_STYLE_SOLID = 0;
    private static final int BORDER_STYLE_DOTTED = 1;
    private static final int BORDER_STYLE_DASHED = 2;
    private static final int BORDER_LEFT_COLOR_SET = 2;
    private static final int BORDER_TOP_COLOR_SET = 4;
    private static final int BORDER_RIGHT_COLOR_SET = 8;
    private static final int BORDER_BOTTOM_COLOR_SET = 16;
    private static final int BORDER_PATH_EFFECT_DIRTY = 32;
    private float mBorderLeftWidth;
    private float mBorderTopWidth;
    private float mBorderRightWidth;
    private float mBorderBottomWidth;
    private int mBorderLeftColor;
    private int mBorderTopColor;
    private int mBorderRightColor;
    private int mBorderBottomColor;
    private int mBorderStyle = 0;
    private int mBackgroundColor;
    @Nullable
    private DashPathEffect mPathEffectForBorderStyle;
    @Nullable
    private Path mPathForBorder;

    DrawBorder() {
    }

    public void setBorderWidth(int position, float borderWidth) {
        switch (position) {
            case 0: {
                this.mBorderLeftWidth = borderWidth;
                break;
            }
            case 1: {
                this.mBorderTopWidth = borderWidth;
                break;
            }
            case 2: {
                this.mBorderRightWidth = borderWidth;
                break;
            }
            case 3: {
                this.mBorderBottomWidth = borderWidth;
                break;
            }
            case 8: {
                this.setBorderWidth(borderWidth);
            }
        }
    }

    public float getBorderWidth(int position) {
        switch (position) {
            case 0: {
                return this.mBorderLeftWidth;
            }
            case 1: {
                return this.mBorderTopWidth;
            }
            case 2: {
                return this.mBorderRightWidth;
            }
            case 3: {
                return this.mBorderBottomWidth;
            }
            case 8: {
                return this.getBorderWidth();
            }
        }
        return 0.0f;
    }

    public void setBorderStyle(@Nullable String style2) {
        this.mBorderStyle = "dotted".equals(style2) ? 1 : ("dashed".equals(style2) ? 2 : 0);
        this.setFlag(32);
    }

    public void resetBorderColor(int position) {
        switch (position) {
            case 0: {
                this.resetFlag(2);
                break;
            }
            case 1: {
                this.resetFlag(4);
                break;
            }
            case 2: {
                this.resetFlag(8);
                break;
            }
            case 3: {
                this.resetFlag(16);
                break;
            }
            case 8: {
                this.setBorderColor(-16777216);
            }
        }
    }

    public void setBorderColor(int position, int borderColor) {
        switch (position) {
            case 0: {
                this.mBorderLeftColor = borderColor;
                this.setFlag(2);
                break;
            }
            case 1: {
                this.mBorderTopColor = borderColor;
                this.setFlag(4);
                break;
            }
            case 2: {
                this.mBorderRightColor = borderColor;
                this.setFlag(8);
                break;
            }
            case 3: {
                this.mBorderBottomColor = borderColor;
                this.setFlag(16);
                break;
            }
            case 8: {
                this.setBorderColor(borderColor);
            }
        }
    }

    public int getBorderColor(int position) {
        int defaultColor = this.getBorderColor();
        switch (position) {
            case 0: {
                return this.resolveBorderColor(2, this.mBorderLeftColor, defaultColor);
            }
            case 1: {
                return this.resolveBorderColor(4, this.mBorderTopColor, defaultColor);
            }
            case 2: {
                return this.resolveBorderColor(8, this.mBorderRightColor, defaultColor);
            }
            case 3: {
                return this.resolveBorderColor(16, this.mBorderBottomColor, defaultColor);
            }
            case 8: {
                return defaultColor;
            }
        }
        return defaultColor;
    }

    public void setBackgroundColor(int backgroundColor) {
        this.mBackgroundColor = backgroundColor;
    }

    public int getBackgroundColor() {
        return this.mBackgroundColor;
    }

    @Override
    protected void onDraw(Canvas canvas) {
        if (this.getBorderRadius() >= 0.5f || this.getPathEffectForBorderStyle() != null) {
            this.drawRoundedBorders(canvas);
        } else {
            this.drawRectangularBorders(canvas);
        }
    }

    @Nullable
    protected DashPathEffect getPathEffectForBorderStyle() {
        if (this.isFlagSet(32)) {
            switch (this.mBorderStyle) {
                case 1: {
                    this.mPathEffectForBorderStyle = DrawBorder.createDashPathEffect(this.getBorderWidth());
                    break;
                }
                case 2: {
                    this.mPathEffectForBorderStyle = DrawBorder.createDashPathEffect(this.getBorderWidth() * 3.0f);
                    break;
                }
                default: {
                    this.mPathEffectForBorderStyle = null;
                }
            }
            this.resetFlag(32);
        }
        return this.mPathEffectForBorderStyle;
    }

    private void drawRoundedBorders(Canvas canvas) {
        if (this.mBackgroundColor != 0) {
            PAINT.setColor(this.mBackgroundColor);
            canvas.drawPath(this.getPathForBorderRadius(), PAINT);
        }
        this.drawBorders(canvas);
    }

    private boolean isBorderColorDifferentAtIntersectionPoints() {
        return this.isFlagSet(4) || this.isFlagSet(16) || this.isFlagSet(2) || this.isFlagSet(8);
    }

    private void drawRectangularBorders(Canvas canvas) {
        int defaultColor = this.getBorderColor();
        float defaultWidth = this.getBorderWidth();
        float top = this.getTop();
        float topWidth = DrawBorder.resolveWidth(this.mBorderTopWidth, defaultWidth);
        float bottomOfTheTop = top + topWidth;
        int topColor = this.resolveBorderColor(4, this.mBorderTopColor, defaultColor);
        float bottom = this.getBottom();
        float bottomWidth = DrawBorder.resolveWidth(this.mBorderBottomWidth, defaultWidth);
        float topOfTheBottom = bottom - bottomWidth;
        int bottomColor = this.resolveBorderColor(16, this.mBorderBottomColor, defaultColor);
        float left = this.getLeft();
        float leftWidth = DrawBorder.resolveWidth(this.mBorderLeftWidth, defaultWidth);
        float rightOfTheLeft = left + leftWidth;
        int leftColor = this.resolveBorderColor(2, this.mBorderLeftColor, defaultColor);
        float right = this.getRight();
        float rightWidth = DrawBorder.resolveWidth(this.mBorderRightWidth, defaultWidth);
        float leftOfTheRight = right - rightWidth;
        int rightColor = this.resolveBorderColor(8, this.mBorderRightColor, defaultColor);
        boolean isDrawPathRequired = this.isBorderColorDifferentAtIntersectionPoints();
        if (isDrawPathRequired && this.mPathForBorder == null) {
            this.mPathForBorder = new Path();
        }
        if (Color.alpha((int)topColor) != 0 && topWidth != 0.0f) {
            PAINT.setColor(topColor);
            if (isDrawPathRequired) {
                this.updatePathForTopBorder(top, bottomOfTheTop, left, rightOfTheLeft, right, leftOfTheRight);
                canvas.drawPath(this.mPathForBorder, PAINT);
            } else {
                canvas.drawRect(left, top, right, bottomOfTheTop, PAINT);
            }
        }
        if (Color.alpha((int)bottomColor) != 0 && bottomWidth != 0.0f) {
            PAINT.setColor(bottomColor);
            if (isDrawPathRequired) {
                this.updatePathForBottomBorder(bottom, topOfTheBottom, left, rightOfTheLeft, right, leftOfTheRight);
                canvas.drawPath(this.mPathForBorder, PAINT);
            } else {
                canvas.drawRect(left, topOfTheBottom, right, bottom, PAINT);
            }
        }
        if (Color.alpha((int)leftColor) != 0 && leftWidth != 0.0f) {
            PAINT.setColor(leftColor);
            if (isDrawPathRequired) {
                this.updatePathForLeftBorder(top, bottomOfTheTop, bottom, topOfTheBottom, left, rightOfTheLeft);
                canvas.drawPath(this.mPathForBorder, PAINT);
            } else {
                canvas.drawRect(left, bottomOfTheTop, rightOfTheLeft, topOfTheBottom, PAINT);
            }
        }
        if (Color.alpha((int)rightColor) != 0 && rightWidth != 0.0f) {
            PAINT.setColor(rightColor);
            if (isDrawPathRequired) {
                this.updatePathForRightBorder(top, bottomOfTheTop, bottom, topOfTheBottom, right, leftOfTheRight);
                canvas.drawPath(this.mPathForBorder, PAINT);
            } else {
                canvas.drawRect(leftOfTheRight, bottomOfTheTop, right, topOfTheBottom, PAINT);
            }
        }
        if (Color.alpha((int)this.mBackgroundColor) != 0) {
            PAINT.setColor(this.mBackgroundColor);
            canvas.drawRect(rightOfTheLeft, bottomOfTheTop, leftOfTheRight, topOfTheBottom, PAINT);
        }
    }

    private void updatePathForTopBorder(float top, float bottomOfTheTop, float left, float rightOfTheLeft, float right, float leftOfTheRight) {
        if (this.mPathForBorder == null) {
            this.mPathForBorder = new Path();
        }
        this.mPathForBorder.reset();
        this.mPathForBorder.moveTo(left, top);
        this.mPathForBorder.lineTo(rightOfTheLeft, bottomOfTheTop);
        this.mPathForBorder.lineTo(leftOfTheRight, bottomOfTheTop);
        this.mPathForBorder.lineTo(right, top);
        this.mPathForBorder.lineTo(left, top);
    }

    private void updatePathForBottomBorder(float bottom, float topOfTheBottom, float left, float rightOfTheLeft, float right, float leftOfTheRight) {
        if (this.mPathForBorder == null) {
            this.mPathForBorder = new Path();
        }
        this.mPathForBorder.reset();
        this.mPathForBorder.moveTo(left, bottom);
        this.mPathForBorder.lineTo(right, bottom);
        this.mPathForBorder.lineTo(leftOfTheRight, topOfTheBottom);
        this.mPathForBorder.lineTo(rightOfTheLeft, topOfTheBottom);
        this.mPathForBorder.lineTo(left, bottom);
    }

    private void updatePathForLeftBorder(float top, float bottomOfTheTop, float bottom, float topOfTheBottom, float left, float rightOfTheLeft) {
        if (this.mPathForBorder == null) {
            this.mPathForBorder = new Path();
        }
        this.mPathForBorder.reset();
        this.mPathForBorder.moveTo(left, top);
        this.mPathForBorder.lineTo(rightOfTheLeft, bottomOfTheTop);
        this.mPathForBorder.lineTo(rightOfTheLeft, topOfTheBottom);
        this.mPathForBorder.lineTo(left, bottom);
        this.mPathForBorder.lineTo(left, top);
    }

    private void updatePathForRightBorder(float top, float bottomOfTheTop, float bottom, float topOfTheBottom, float right, float leftOfTheRight) {
        if (this.mPathForBorder == null) {
            this.mPathForBorder = new Path();
        }
        this.mPathForBorder.reset();
        this.mPathForBorder.moveTo(right, top);
        this.mPathForBorder.lineTo(right, bottom);
        this.mPathForBorder.lineTo(leftOfTheRight, topOfTheBottom);
        this.mPathForBorder.lineTo(leftOfTheRight, bottomOfTheTop);
        this.mPathForBorder.lineTo(right, top);
    }

    private int resolveBorderColor(int flag, int color, int defaultColor) {
        return this.isFlagSet(flag) ? color : defaultColor;
    }

    private static float resolveWidth(float width, float defaultWidth) {
        return width == 0.0f || width != width ? defaultWidth : width;
    }

    private static DashPathEffect createDashPathEffect(float borderWidth) {
        for (int i = 0; i < 4; ++i) {
            DrawBorder.TMP_FLOAT_ARRAY[i] = borderWidth;
        }
        return new DashPathEffect(TMP_FLOAT_ARRAY, 0.0f);
    }
}

