/*
 * Decompiled with CFR 0.152.
 */
package com.oblador.vectoricons;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Typeface;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.views.text.ReactFontManager;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

public class VectorIconsModule
extends ReactContextBaseJavaModule {
    private static final Map<String, Typeface> sTypefaceCache = new HashMap<String, Typeface>();
    public static final String REACT_CLASS = "RNVectorIconsModule";

    public String getName() {
        return REACT_CLASS;
    }

    public VectorIconsModule(ReactApplicationContext reactContext) {
        super(reactContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ReactMethod
    public void getImageForFont(String fontFamily, String glyph, Integer fontSize, Integer color, Callback callback) {
        ReactApplicationContext context = this.getReactApplicationContext();
        File cacheFolder = context.getCacheDir();
        String cacheFolderPath = cacheFolder.getAbsolutePath() + "/";
        float scale = context.getResources().getDisplayMetrics().density;
        String scaleSuffix = "@" + (scale == (float)((int)scale) ? Integer.toString((int)scale) : Float.toString(scale)) + "x";
        int size = Math.round((float)fontSize.intValue() * scale);
        String cacheKey = fontFamily + ":" + glyph + ":" + color;
        String hash = Integer.toString(cacheKey.hashCode(), 32);
        String cacheFilePath = cacheFolderPath + hash + "_" + Integer.toString(fontSize) + scaleSuffix + ".png";
        String cacheFileUrl = "file://" + cacheFilePath;
        File cacheFile = new File(cacheFilePath);
        if (cacheFile.exists()) {
            callback.invoke(new Object[]{null, cacheFileUrl});
        } else {
            FileOutputStream fos = null;
            Typeface typeface = ReactFontManager.getInstance().getTypeface(fontFamily, 0, context.getAssets());
            Paint paint = new Paint();
            paint.setTypeface(typeface);
            paint.setColor(color.intValue());
            paint.setTextSize((float)size);
            paint.setAntiAlias(true);
            Rect textBounds = new Rect();
            paint.getTextBounds(glyph, 0, glyph.length(), textBounds);
            Bitmap bitmap = Bitmap.createBitmap((int)textBounds.width(), (int)textBounds.height(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(bitmap);
            canvas.drawText(glyph, (float)(-textBounds.left), (float)(-textBounds.top), paint);
            try {
                fos = new FileOutputStream(cacheFile);
                bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)fos);
                fos.flush();
                fos.close();
                fos = null;
                callback.invoke(new Object[]{null, cacheFileUrl});
            }
            catch (FileNotFoundException e) {
                callback.invoke(new Object[]{e.getMessage()});
            }
            catch (IOException e) {
                callback.invoke(new Object[]{e.getMessage()});
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                        fos = null;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }
}

