/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.fbui.textlayoutbuilder;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.support.annotation.AttrRes;
import android.support.annotation.StyleRes;
import android.text.TextUtils;
import android.util.AttributeSet;
import com.facebook.fbui.textlayoutbuilder.R;
import com.facebook.fbui.textlayoutbuilder.TextLayoutBuilder;

public class ResourceTextLayoutHelper {
    private static final int DEFAULT_TEXT_SIZE_PX = 15;

    public static void updateFromStyleResource(TextLayoutBuilder builder, Context context, @StyleRes int styleRes) {
        ResourceTextLayoutHelper.updateFromStyleResource(builder, context, 0, styleRes);
    }

    public static void updateFromStyleResource(TextLayoutBuilder builder, Context context, @AttrRes int styleAttr, @StyleRes int styleRes) {
        ResourceTextLayoutHelper.updateFromStyleResource(builder, context, null, styleAttr, styleRes);
    }

    public static void updateFromStyleResource(TextLayoutBuilder builder, Context context, AttributeSet attrs, @AttrRes int styleAttr, @StyleRes int styleRes) {
        TypedArray customAttrs = context.obtainStyledAttributes(attrs, R.styleable.TextStyle, styleAttr, styleRes);
        int textAppearanceId = customAttrs.getResourceId(R.styleable.TextStyle_android_textAppearance, -1);
        if (textAppearanceId > 0) {
            ResourceTextLayoutHelper.setTextAppearance(builder, context, textAppearanceId);
        }
        ColorStateList textColor = customAttrs.getColorStateList(R.styleable.TextStyle_android_textColor);
        int textSize = customAttrs.getDimensionPixelSize(R.styleable.TextStyle_android_textSize, 15);
        int shadowColor = customAttrs.getInt(R.styleable.TextStyle_android_shadowColor, 0);
        float dx = customAttrs.getFloat(R.styleable.TextStyle_android_shadowDx, 0.0f);
        float dy = customAttrs.getFloat(R.styleable.TextStyle_android_shadowDy, 0.0f);
        float radius = customAttrs.getFloat(R.styleable.TextStyle_android_shadowRadius, 0.0f);
        int textStyle = customAttrs.getInt(R.styleable.TextStyle_android_textStyle, -1);
        int ellipsize = customAttrs.getInt(R.styleable.TextStyle_android_ellipsize, 0);
        boolean singleLine = customAttrs.getBoolean(R.styleable.TextStyle_android_singleLine, false);
        int maxLines = customAttrs.getInt(R.styleable.TextStyle_android_maxLines, Integer.MAX_VALUE);
        customAttrs.recycle();
        builder.setTextColor(textColor);
        builder.setTextSize(textSize);
        builder.setShadowLayer(radius, dx, dy, shadowColor);
        if (textStyle != -1) {
            builder.setTypeface(Typeface.defaultFromStyle((int)textStyle));
        } else {
            builder.setTypeface(null);
        }
        if (ellipsize > 0 && ellipsize < 4) {
            builder.setEllipsize(TextUtils.TruncateAt.values()[ellipsize - 1]);
        } else {
            builder.setEllipsize(null);
        }
        builder.setSingleLine(singleLine);
        builder.setMaxLines(maxLines);
    }

    public static void setTextAppearance(TextLayoutBuilder builder, Context context, @StyleRes int resId) {
        TypedArray customAttrs = context.obtainStyledAttributes(resId, R.styleable.TextAppearance);
        ColorStateList textColor = customAttrs.getColorStateList(R.styleable.TextAppearance_android_textColor);
        int textSize = customAttrs.getDimensionPixelSize(R.styleable.TextAppearance_android_textSize, 0);
        int shadowColor = customAttrs.getInt(R.styleable.TextAppearance_android_shadowColor, 0);
        if (shadowColor != 0) {
            float dx = customAttrs.getFloat(R.styleable.TextAppearance_android_shadowDx, 0.0f);
            float dy = customAttrs.getFloat(R.styleable.TextAppearance_android_shadowDy, 0.0f);
            float radius = customAttrs.getFloat(R.styleable.TextAppearance_android_shadowRadius, 0.0f);
            builder.setShadowLayer(radius, dx, dy, shadowColor);
        }
        int textStyle = customAttrs.getInt(R.styleable.TextAppearance_android_textStyle, -1);
        customAttrs.recycle();
        if (textColor != null) {
            builder.setTextColor(textColor);
        }
        if (textSize != 0) {
            builder.setTextSize(textSize);
        }
        if (textStyle != -1) {
            builder.setTypeface(Typeface.defaultFromStyle((int)textStyle));
        }
    }
}

