/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import com.facebook.imagepipeline.common.Priority;
import com.facebook.imagepipeline.producers.ProducerContext;
import com.facebook.imagepipeline.producers.ProducerContextCallbacks;
import com.facebook.imagepipeline.producers.ProducerListener;
import com.facebook.imagepipeline.request.ImageRequest;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

public class BaseProducerContext
implements ProducerContext {
    private final ImageRequest mImageRequest;
    private final String mId;
    private final ProducerListener mProducerListener;
    private final Object mCallerContext;
    private final ImageRequest.RequestLevel mLowestPermittedRequestLevel;
    @GuardedBy(value="this")
    private boolean mIsPrefetch;
    @GuardedBy(value="this")
    private Priority mPriority;
    @GuardedBy(value="this")
    private boolean mIsIntermediateResultExpected;
    @GuardedBy(value="this")
    private boolean mIsCancelled;
    @GuardedBy(value="this")
    private final List<ProducerContextCallbacks> mCallbacks;

    public BaseProducerContext(ImageRequest imageRequest, String id, ProducerListener producerListener, Object callerContext, ImageRequest.RequestLevel lowestPermittedRequestLevel, boolean isPrefetch, boolean isIntermediateResultExpected, Priority priority) {
        this.mImageRequest = imageRequest;
        this.mId = id;
        this.mProducerListener = producerListener;
        this.mCallerContext = callerContext;
        this.mLowestPermittedRequestLevel = lowestPermittedRequestLevel;
        this.mIsPrefetch = isPrefetch;
        this.mPriority = priority;
        this.mIsIntermediateResultExpected = isIntermediateResultExpected;
        this.mIsCancelled = false;
        this.mCallbacks = new ArrayList<ProducerContextCallbacks>();
    }

    @Override
    public ImageRequest getImageRequest() {
        return this.mImageRequest;
    }

    @Override
    public String getId() {
        return this.mId;
    }

    @Override
    public ProducerListener getListener() {
        return this.mProducerListener;
    }

    @Override
    public Object getCallerContext() {
        return this.mCallerContext;
    }

    @Override
    public ImageRequest.RequestLevel getLowestPermittedRequestLevel() {
        return this.mLowestPermittedRequestLevel;
    }

    @Override
    public synchronized boolean isPrefetch() {
        return this.mIsPrefetch;
    }

    @Override
    public synchronized Priority getPriority() {
        return this.mPriority;
    }

    @Override
    public synchronized boolean isIntermediateResultExpected() {
        return this.mIsIntermediateResultExpected;
    }

    public synchronized boolean isCancelled() {
        return this.mIsCancelled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCallbacks(ProducerContextCallbacks callbacks) {
        boolean cancelImmediately = false;
        BaseProducerContext baseProducerContext = this;
        synchronized (baseProducerContext) {
            this.mCallbacks.add(callbacks);
            if (this.mIsCancelled) {
                cancelImmediately = true;
            }
        }
        if (cancelImmediately) {
            callbacks.onCancellationRequested();
        }
    }

    public void cancel() {
        BaseProducerContext.callOnCancellationRequested(this.cancelNoCallbacks());
    }

    @Nullable
    public synchronized List<ProducerContextCallbacks> setIsPrefetchNoCallbacks(boolean isPrefetch) {
        if (isPrefetch == this.mIsPrefetch) {
            return null;
        }
        this.mIsPrefetch = isPrefetch;
        return new ArrayList<ProducerContextCallbacks>(this.mCallbacks);
    }

    @Nullable
    public synchronized List<ProducerContextCallbacks> setPriorityNoCallbacks(Priority priority) {
        if (priority == this.mPriority) {
            return null;
        }
        this.mPriority = priority;
        return new ArrayList<ProducerContextCallbacks>(this.mCallbacks);
    }

    @Nullable
    public synchronized List<ProducerContextCallbacks> setIsIntermediateResultExpectedNoCallbacks(boolean isIntermediateResultExpected) {
        if (isIntermediateResultExpected == this.mIsIntermediateResultExpected) {
            return null;
        }
        this.mIsIntermediateResultExpected = isIntermediateResultExpected;
        return new ArrayList<ProducerContextCallbacks>(this.mCallbacks);
    }

    @Nullable
    public synchronized List<ProducerContextCallbacks> cancelNoCallbacks() {
        if (this.mIsCancelled) {
            return null;
        }
        this.mIsCancelled = true;
        return new ArrayList<ProducerContextCallbacks>(this.mCallbacks);
    }

    public static void callOnCancellationRequested(@Nullable List<ProducerContextCallbacks> callbacks) {
        if (callbacks == null) {
            return;
        }
        for (ProducerContextCallbacks callback : callbacks) {
            callback.onCancellationRequested();
        }
    }

    public static void callOnIsPrefetchChanged(@Nullable List<ProducerContextCallbacks> callbacks) {
        if (callbacks == null) {
            return;
        }
        for (ProducerContextCallbacks callback : callbacks) {
            callback.onIsPrefetchChanged();
        }
    }

    public static void callOnIsIntermediateResultExpectedChanged(@Nullable List<ProducerContextCallbacks> callbacks) {
        if (callbacks == null) {
            return;
        }
        for (ProducerContextCallbacks callback : callbacks) {
            callback.onIsIntermediateResultExpectedChanged();
        }
    }

    public static void callOnPriorityChanged(@Nullable List<ProducerContextCallbacks> callbacks) {
        if (callbacks == null) {
            return;
        }
        for (ProducerContextCallbacks callback : callbacks) {
            callback.onPriorityChanged();
        }
    }
}

