/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.packagerconnection;

import android.os.Handler;
import android.os.Looper;
import com.facebook.common.logging.FLog;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.ws.WebSocket;
import okhttp3.ws.WebSocketCall;
import okhttp3.ws.WebSocketListener;
import okio.Buffer;

public final class ReconnectingWebSocket
implements WebSocketListener {
    private static final String TAG = ReconnectingWebSocket.class.getSimpleName();
    private static final int RECONNECT_DELAY_MS = 2000;
    private final String mUrl;
    private final Handler mHandler;
    private boolean mClosed = false;
    private boolean mSuppressConnectionErrors;
    @Nullable
    private WebSocket mWebSocket;
    @Nullable
    private MessageCallback mCallback;

    public ReconnectingWebSocket(String url, MessageCallback callback) {
        this.mUrl = url;
        this.mCallback = callback;
        this.mHandler = new Handler(Looper.getMainLooper());
    }

    public void connect() {
        if (this.mClosed) {
            throw new IllegalStateException("Can't connect closed client");
        }
        OkHttpClient httpClient = new OkHttpClient.Builder().connectTimeout(10L, TimeUnit.SECONDS).writeTimeout(10L, TimeUnit.SECONDS).readTimeout(0L, TimeUnit.MINUTES).build();
        Request request = new Request.Builder().url(this.mUrl).build();
        WebSocketCall call = WebSocketCall.create((OkHttpClient)httpClient, (Request)request);
        call.enqueue((WebSocketListener)this);
    }

    private synchronized void delayedReconnect() {
        if (!this.mClosed) {
            this.connect();
        }
    }

    private void reconnect() {
        if (this.mClosed) {
            throw new IllegalStateException("Can't reconnect closed client");
        }
        if (!this.mSuppressConnectionErrors) {
            FLog.w((String)TAG, (String)("Couldn't connect to \"" + this.mUrl + "\", will silently retry"));
            this.mSuppressConnectionErrors = true;
        }
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                ReconnectingWebSocket.this.delayedReconnect();
            }
        }, 2000L);
    }

    public void closeQuietly() {
        this.mClosed = true;
        this.closeWebSocketQuietly();
        this.mCallback = null;
    }

    private void closeWebSocketQuietly() {
        if (this.mWebSocket != null) {
            try {
                this.mWebSocket.close(1000, "End of session");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.mWebSocket = null;
        }
    }

    private void abort(String message, Throwable cause) {
        FLog.e((String)TAG, (String)("Error occurred, shutting down websocket connection: " + message), (Throwable)cause);
        this.closeWebSocketQuietly();
    }

    public synchronized void onOpen(WebSocket webSocket, Response response) {
        this.mWebSocket = webSocket;
        this.mSuppressConnectionErrors = false;
    }

    public synchronized void onFailure(IOException e, Response response) {
        if (this.mWebSocket != null) {
            this.abort("Websocket exception", e);
        }
        if (!this.mClosed) {
            this.reconnect();
        }
    }

    public synchronized void onMessage(ResponseBody message) {
        if (this.mCallback != null) {
            this.mCallback.onMessage(message);
        }
    }

    public synchronized void onPong(Buffer payload) {
    }

    public synchronized void onClose(int code, String reason) {
        this.mWebSocket = null;
        if (!this.mClosed) {
            this.reconnect();
        }
    }

    public synchronized void sendMessage(RequestBody message) throws IOException {
        if (this.mWebSocket == null) {
            throw new ClosedChannelException();
        }
        this.mWebSocket.sendMessage(message);
    }

    public static interface MessageCallback {
        public void onMessage(ResponseBody var1);
    }
}

