/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.dialog;

import android.app.Activity;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.LifecycleEventListener;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.common.MapBuilder;
import com.facebook.react.modules.dialog.AlertFragment;
import com.facebook.react.modules.dialog.SupportAlertFragment;
import java.util.Map;
import javax.annotation.Nullable;

public class DialogModule
extends ReactContextBaseJavaModule
implements LifecycleEventListener {
    static final String FRAGMENT_TAG = "com.facebook.catalyst.react.dialog.DialogModule";
    static final String NAME = "DialogManagerAndroid";
    static final String ACTION_BUTTON_CLICKED = "buttonClicked";
    static final String ACTION_DISMISSED = "dismissed";
    static final String KEY_TITLE = "title";
    static final String KEY_MESSAGE = "message";
    static final String KEY_BUTTON_POSITIVE = "buttonPositive";
    static final String KEY_BUTTON_NEGATIVE = "buttonNegative";
    static final String KEY_BUTTON_NEUTRAL = "buttonNeutral";
    static final Map<String, Object> CONSTANTS = MapBuilder.of("buttonClicked", "buttonClicked", "dismissed", "dismissed", "buttonPositive", -1, "buttonNegative", -2, "buttonNeutral", -3);
    private boolean mIsInForeground;

    public DialogModule(ReactApplicationContext reactContext) {
        super(reactContext);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Map<String, Object> getConstants() {
        return CONSTANTS;
    }

    @Override
    public void initialize() {
        this.getReactApplicationContext().addLifecycleEventListener(this);
    }

    @Override
    public void onHostPause() {
        this.mIsInForeground = false;
    }

    @Override
    public void onHostDestroy() {
    }

    @Override
    public void onHostResume() {
        this.mIsInForeground = true;
        FragmentManagerHelper fragmentManagerHelper = this.getFragmentManagerHelper();
        Assertions.assertNotNull((Object)fragmentManagerHelper, (String)"Attached DialogModule to host with pending alert but no FragmentManager (not attached to an Activity).");
        fragmentManagerHelper.showPendingAlert();
    }

    @ReactMethod
    public void showAlert(ReadableMap options, Callback errorCallback, Callback actionCallback) {
        FragmentManagerHelper fragmentManagerHelper = this.getFragmentManagerHelper();
        if (fragmentManagerHelper == null) {
            errorCallback.invoke("Tried to show an alert while not attached to an Activity");
            return;
        }
        Bundle args = new Bundle();
        if (options.hasKey(KEY_TITLE)) {
            args.putString(KEY_TITLE, options.getString(KEY_TITLE));
        }
        if (options.hasKey(KEY_MESSAGE)) {
            args.putString(KEY_MESSAGE, options.getString(KEY_MESSAGE));
        }
        if (options.hasKey(KEY_BUTTON_POSITIVE)) {
            args.putString("button_positive", options.getString(KEY_BUTTON_POSITIVE));
        }
        if (options.hasKey(KEY_BUTTON_NEGATIVE)) {
            args.putString("button_negative", options.getString(KEY_BUTTON_NEGATIVE));
        }
        if (options.hasKey(KEY_BUTTON_NEUTRAL)) {
            args.putString("button_neutral", options.getString(KEY_BUTTON_NEUTRAL));
        }
        fragmentManagerHelper.showNewAlert(this.mIsInForeground, args, actionCallback);
    }

    @Nullable
    private FragmentManagerHelper getFragmentManagerHelper() {
        Activity activity = this.getCurrentActivity();
        if (activity == null) {
            return null;
        }
        if (activity instanceof FragmentActivity) {
            return new FragmentManagerHelper(((FragmentActivity)activity).getSupportFragmentManager());
        }
        return new FragmentManagerHelper(activity.getFragmentManager());
    }

    class AlertFragmentListener
    implements DialogInterface.OnClickListener,
    DialogInterface.OnDismissListener {
        private final Callback mCallback;
        private boolean mCallbackConsumed = false;

        public AlertFragmentListener(Callback callback) {
            this.mCallback = callback;
        }

        public void onClick(DialogInterface dialog, int which) {
            if (!this.mCallbackConsumed && DialogModule.this.getReactApplicationContext().hasActiveCatalystInstance()) {
                this.mCallback.invoke(DialogModule.ACTION_BUTTON_CLICKED, which);
                this.mCallbackConsumed = true;
            }
        }

        public void onDismiss(DialogInterface dialog) {
            if (!this.mCallbackConsumed && DialogModule.this.getReactApplicationContext().hasActiveCatalystInstance()) {
                this.mCallback.invoke(DialogModule.ACTION_DISMISSED);
                this.mCallbackConsumed = true;
            }
        }
    }

    private class FragmentManagerHelper {
        @Nullable
        private final android.app.FragmentManager mFragmentManager;
        @Nullable
        private final FragmentManager mSupportFragmentManager;
        @Nullable
        private Object mFragmentToShow;

        private boolean isUsingSupportLibrary() {
            return this.mSupportFragmentManager != null;
        }

        public FragmentManagerHelper(FragmentManager supportFragmentManager) {
            this.mFragmentManager = null;
            this.mSupportFragmentManager = supportFragmentManager;
        }

        public FragmentManagerHelper(android.app.FragmentManager fragmentManager) {
            this.mFragmentManager = fragmentManager;
            this.mSupportFragmentManager = null;
        }

        public void showPendingAlert() {
            if (this.mFragmentToShow == null) {
                return;
            }
            if (this.isUsingSupportLibrary()) {
                ((SupportAlertFragment)((Object)this.mFragmentToShow)).show(this.mSupportFragmentManager, DialogModule.FRAGMENT_TAG);
            } else {
                ((AlertFragment)((Object)this.mFragmentToShow)).show(this.mFragmentManager, DialogModule.FRAGMENT_TAG);
            }
            this.mFragmentToShow = null;
        }

        private void dismissExisting() {
            if (this.isUsingSupportLibrary()) {
                SupportAlertFragment oldFragment = (SupportAlertFragment)this.mSupportFragmentManager.findFragmentByTag(DialogModule.FRAGMENT_TAG);
                if (oldFragment != null) {
                    oldFragment.dismiss();
                }
            } else {
                AlertFragment oldFragment = (AlertFragment)this.mFragmentManager.findFragmentByTag(DialogModule.FRAGMENT_TAG);
                if (oldFragment != null) {
                    oldFragment.dismiss();
                }
            }
        }

        public void showNewAlert(boolean isInForeground, Bundle arguments, Callback actionCallback) {
            AlertFragmentListener actionListener;
            this.dismissExisting();
            AlertFragmentListener alertFragmentListener = actionListener = actionCallback != null ? new AlertFragmentListener(actionCallback) : null;
            if (this.isUsingSupportLibrary()) {
                SupportAlertFragment alertFragment = new SupportAlertFragment(actionListener, arguments);
                if (isInForeground) {
                    alertFragment.show(this.mSupportFragmentManager, DialogModule.FRAGMENT_TAG);
                } else {
                    this.mFragmentToShow = alertFragment;
                }
            } else {
                AlertFragment alertFragment = new AlertFragment(actionListener, arguments);
                if (isInForeground) {
                    alertFragment.show(this.mFragmentManager, DialogModule.FRAGMENT_TAG);
                } else {
                    this.mFragmentToShow = alertFragment;
                }
            }
        }
    }
}

