/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.soloader;

import android.content.Context;
import com.facebook.soloader.DirectorySoSource;
import com.facebook.soloader.FileLocker;
import com.facebook.soloader.SysUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ApkSoSource
extends DirectorySoSource {
    private static final String TAG = "SoLoader";
    private static final boolean DEBUG = false;

    public ApkSoSource(Context context) throws IOException {
        super(SysUtil.createLibsDirectory(context), 1);
        try (JarFile apk = new JarFile(context.getApplicationInfo().publicSourceDir);){
            File libsDir = this.soDirectory;
            Map<String, SoInfo> providedLibraries = ApkSoSource.findProvidedLibraries(apk);
            try (FileLocker lock = SysUtil.lockLibsDirectory(context);){
                File[] extantFiles = libsDir.listFiles();
                for (int i = 0; i < extantFiles.length; ++i) {
                    boolean upToDate;
                    File extantFile = extantFiles[i];
                    String name = extantFile.getName();
                    SoInfo so = providedLibraries.get(name);
                    boolean shouldDelete = so == null || so.entry.getSize() != extantFile.length() || so.entry.getTime() != extantFile.lastModified();
                    boolean bl = upToDate = so != null && !shouldDelete;
                    if (shouldDelete) {
                        SysUtil.deleteOrThrow(extantFile);
                    }
                    if (!upToDate) continue;
                    providedLibraries.remove(name);
                }
                for (SoInfo so : providedLibraries.values()) {
                    JarEntry entry = so.entry;
                    try (InputStream is = apk.getInputStream(entry);){
                        SysUtil.reliablyCopyExecutable(is, new File(libsDir, so.soName), entry.getSize(), entry.getTime());
                    }
                    SysUtil.freeCopyBuffer();
                }
            }
        }
    }

    private static Map<String, SoInfo> findProvidedLibraries(JarFile apk) {
        Pattern libPattern = Pattern.compile("^lib/([^/]+)/([^/]+\\.so)$");
        HashMap<String, SoInfo> providedLibraries = new HashMap<String, SoInfo>();
        String[] supportedAbis = SysUtil.getSupportedAbis();
        Enumeration<JarEntry> entries = apk.entries();
        while (entries.hasMoreElements()) {
            SoInfo so;
            JarEntry entry = entries.nextElement();
            Matcher m = libPattern.matcher(entry.getName());
            if (!m.matches()) continue;
            String libraryAbi = m.group(1);
            String soName = m.group(2);
            int abiScore = SysUtil.findAbiScore(supportedAbis, libraryAbi);
            if (abiScore < 0 || (so = providedLibraries.get(soName)) != null && abiScore >= so.abiScore) continue;
            providedLibraries.put(soName, new SoInfo(soName, entry, abiScore));
        }
        return providedLibraries;
    }

    private static final class SoInfo {
        public final String soName;
        public final JarEntry entry;
        public final int abiScore;

        SoInfo(String soName, JarEntry entry, int abiScore) {
            this.soName = soName;
            this.entry = entry;
            this.abiScore = abiScore;
        }
    }
}

