/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react;

import android.annotation.TargetApi;
import android.app.Application;
import android.content.ComponentCallbacks;
import android.content.ComponentCallbacks2;
import android.content.Context;
import android.content.res.Configuration;
import com.facebook.react.bridge.MemoryPressure;
import com.facebook.react.bridge.MemoryPressureListener;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public class MemoryPressureRouter {
    private static final String ACTION_TRIM_MEMORY_UI_HIDDEN = "com.facebook.rnfeed.ACTION_TRIM_MEMORY_UI_HIDDEN";
    private static final String ACTION_TRIM_MEMORY_MODERATE = "com.facebook.rnfeed.ACTION_TRIM_MEMORY_MODERATE";
    private static final String ACTION_TRIM_MEMORY_CRITICAL = "com.facebook.rnfeed.ACTION_TRIM_MEMORY_CRITICAL";
    private final Set<MemoryPressureListener> mListeners = Collections.synchronizedSet(new LinkedHashSet());
    private final ComponentCallbacks2 mCallbacks = new ComponentCallbacks2(){

        public void onTrimMemory(int level) {
            MemoryPressureRouter.this.trimMemory(level);
        }

        public void onConfigurationChanged(Configuration newConfig) {
        }

        public void onLowMemory() {
        }
    };

    @TargetApi(value=16)
    public static boolean handleDebugIntent(Application application, String action) {
        switch (action) {
            case "com.facebook.rnfeed.ACTION_TRIM_MEMORY_UI_HIDDEN": {
                MemoryPressureRouter.simulateTrimMemory(application, 20);
                break;
            }
            case "com.facebook.rnfeed.ACTION_TRIM_MEMORY_MODERATE": {
                MemoryPressureRouter.simulateTrimMemory(application, 60);
                break;
            }
            case "com.facebook.rnfeed.ACTION_TRIM_MEMORY_CRITICAL": {
                MemoryPressureRouter.simulateTrimMemory(application, 80);
            }
            default: {
                return false;
            }
        }
        return true;
    }

    MemoryPressureRouter(Context context) {
        context.getApplicationContext().registerComponentCallbacks((ComponentCallbacks)this.mCallbacks);
    }

    public void addMemoryPressureListener(MemoryPressureListener listener) {
        this.mListeners.add(listener);
    }

    public void removeMemoryPressureListener(MemoryPressureListener listener) {
        this.mListeners.remove(listener);
    }

    public void destroy(Context context) {
        context.getApplicationContext().unregisterComponentCallbacks((ComponentCallbacks)this.mCallbacks);
    }

    private void trimMemory(int level) {
        if (level >= 80) {
            this.dispatchMemoryPressure(MemoryPressure.CRITICAL);
        } else if (level >= 40 || level == 15) {
            this.dispatchMemoryPressure(MemoryPressure.MODERATE);
        } else if (level == 20) {
            this.dispatchMemoryPressure(MemoryPressure.UI_HIDDEN);
        }
    }

    private void dispatchMemoryPressure(MemoryPressure level) {
        MemoryPressureListener[] listeners;
        for (MemoryPressureListener listener : listeners = this.mListeners.toArray(new MemoryPressureListener[this.mListeners.size()])) {
            listener.handleMemoryPressure(level);
        }
    }

    private static void simulateTrimMemory(Application application, int level) {
        application.onTrimMemory(level);
    }
}

