/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.cxxbridge;

import com.facebook.infer.annotation.Assertions;
import com.facebook.proguard.annotations.DoNotStrip;
import com.facebook.react.bridge.NativeModule;
import com.facebook.react.bridge.ReactMarker;
import com.facebook.react.bridge.ReactMarkerConstants;
import com.facebook.react.cxxbridge.CxxModuleWrapper;
import com.facebook.react.cxxbridge.SoftAssertions;
import com.facebook.react.module.model.ReactModuleInfo;
import com.facebook.systrace.Systrace;
import com.facebook.systrace.SystraceMessage;
import javax.annotation.Nullable;
import javax.inject.Provider;

@DoNotStrip
public class ModuleHolder {
    private final String mName;
    private final boolean mCanOverrideExistingModule;
    private final boolean mHasConstants;
    @Nullable
    private Provider<? extends NativeModule> mProvider;
    @Nullable
    private NativeModule mModule;
    private boolean mInitializeNeeded;

    public ModuleHolder(ReactModuleInfo moduleInfo, Provider<? extends NativeModule> provider) {
        this.mName = moduleInfo.name();
        this.mCanOverrideExistingModule = moduleInfo.canOverrideExistingModule();
        this.mHasConstants = moduleInfo.hasConstants();
        this.mProvider = provider;
        if (moduleInfo.needsEagerInit()) {
            this.mModule = this.create();
        }
    }

    public ModuleHolder(NativeModule nativeModule) {
        this.mName = nativeModule.getName();
        this.mCanOverrideExistingModule = nativeModule.canOverrideExistingModule();
        this.mHasConstants = true;
        this.mModule = nativeModule;
    }

    public synchronized void initialize() {
        if (this.mModule != null) {
            this.doInitialize(this.mModule);
        } else {
            this.mInitializeNeeded = true;
        }
    }

    public synchronized boolean isInitialized() {
        return this.mModule != null;
    }

    public synchronized void destroy() {
        if (this.mModule != null) {
            this.mModule.onCatalystInstanceDestroy();
        }
    }

    @DoNotStrip
    public String getName() {
        return this.mName;
    }

    public boolean getCanOverrideExistingModule() {
        return this.mCanOverrideExistingModule;
    }

    public boolean getHasConstants() {
        return this.mHasConstants;
    }

    @DoNotStrip
    public synchronized NativeModule getModule() {
        if (this.mModule == null) {
            this.mModule = this.create();
        }
        return this.mModule;
    }

    private NativeModule create() {
        NativeModule module;
        SoftAssertions.assertCondition(this.mModule == null, "Creating an already created module.");
        ReactMarker.logMarker(ReactMarkerConstants.CREATE_MODULE_START, this.mName);
        SystraceMessage.beginSection(0L, "createModule").arg("name", this.mName).flush();
        try {
            module = (NativeModule)((Provider)Assertions.assertNotNull(this.mProvider)).get();
            this.mProvider = null;
            if (this.mInitializeNeeded) {
                this.doInitialize(module);
                this.mInitializeNeeded = false;
            }
        }
        finally {
            Systrace.endSection(0L);
            ReactMarker.logMarker(ReactMarkerConstants.CREATE_MODULE_END);
        }
        return module;
    }

    private void doInitialize(NativeModule module) {
        SystraceMessage.Builder section = SystraceMessage.beginSection(0L, "initialize");
        if (module instanceof CxxModuleWrapper) {
            section.arg("className", module.getClass().getSimpleName());
        } else {
            section.arg("name", this.mName);
        }
        section.flush();
        ReactMarker.logMarker(ReactMarkerConstants.INITIALIZE_MODULE_START, this.mName);
        try {
            module.initialize();
        }
        finally {
            ReactMarker.logMarker(ReactMarkerConstants.INITIALIZE_MODULE_END);
            Systrace.endSection(0L);
        }
    }
}

