/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.app;

import android.content.res.Resources;
import android.os.Build;
import android.support.annotation.NonNull;
import android.util.Log;
import android.util.LongSparseArray;
import java.lang.reflect.Field;
import java.util.Map;

class ResourcesFlusher {
    private static final String TAG = "ResourcesFlusher";
    private static Field sDrawableCacheField;
    private static boolean sDrawableCacheFieldFetched;
    private static Class sThemedResourceCacheClazz;
    private static boolean sThemedResourceCacheClazzFetched;
    private static Field sThemedResourceCache_mUnthemedEntriesField;
    private static boolean sThemedResourceCache_mUnthemedEntriesFieldFetched;
    private static Field sResourcesImplField;
    private static boolean sResourcesImplFieldFetched;

    ResourcesFlusher() {
    }

    static boolean flush(@NonNull Resources resources) {
        int sdk = Build.VERSION.SDK_INT;
        if (sdk >= 24) {
            return ResourcesFlusher.flushNougats(resources);
        }
        if (sdk >= 23) {
            return ResourcesFlusher.flushMarshmallows(resources);
        }
        if (sdk >= 21) {
            return ResourcesFlusher.flushLollipops(resources);
        }
        return false;
    }

    private static boolean flushLollipops(@NonNull Resources resources) {
        if (!sDrawableCacheFieldFetched) {
            try {
                sDrawableCacheField = Resources.class.getDeclaredField("mDrawableCache");
                sDrawableCacheField.setAccessible(true);
            }
            catch (NoSuchFieldException e) {
                Log.e((String)TAG, (String)"Could not retrieve Resources#mDrawableCache field", (Throwable)e);
            }
            sDrawableCacheFieldFetched = true;
        }
        if (sDrawableCacheField != null) {
            Map drawableCache = null;
            try {
                drawableCache = (Map)sDrawableCacheField.get(resources);
            }
            catch (IllegalAccessException e) {
                Log.e((String)TAG, (String)"Could not retrieve value from Resources#mDrawableCache", (Throwable)e);
            }
            if (drawableCache != null) {
                drawableCache.clear();
                return true;
            }
        }
        return false;
    }

    private static boolean flushMarshmallows(@NonNull Resources resources) {
        if (!sDrawableCacheFieldFetched) {
            try {
                sDrawableCacheField = Resources.class.getDeclaredField("mDrawableCache");
                sDrawableCacheField.setAccessible(true);
            }
            catch (NoSuchFieldException e) {
                Log.e((String)TAG, (String)"Could not retrieve Resources#mDrawableCache field", (Throwable)e);
            }
            sDrawableCacheFieldFetched = true;
        }
        Object drawableCache = null;
        if (sDrawableCacheField != null) {
            try {
                drawableCache = sDrawableCacheField.get(resources);
            }
            catch (IllegalAccessException e) {
                Log.e((String)TAG, (String)"Could not retrieve value from Resources#mDrawableCache", (Throwable)e);
            }
        }
        if (drawableCache == null) {
            return false;
        }
        return drawableCache != null && ResourcesFlusher.flushThemedResourcesCache(drawableCache);
    }

    private static boolean flushNougats(@NonNull Resources resources) {
        if (!sResourcesImplFieldFetched) {
            try {
                sResourcesImplField = Resources.class.getDeclaredField("mResourcesImpl");
                sResourcesImplField.setAccessible(true);
            }
            catch (NoSuchFieldException e) {
                Log.e((String)TAG, (String)"Could not retrieve Resources#mResourcesImpl field", (Throwable)e);
            }
            sResourcesImplFieldFetched = true;
        }
        if (sResourcesImplField == null) {
            return false;
        }
        Object resourcesImpl = null;
        try {
            resourcesImpl = sResourcesImplField.get(resources);
        }
        catch (IllegalAccessException e) {
            Log.e((String)TAG, (String)"Could not retrieve value from Resources#mResourcesImpl", (Throwable)e);
        }
        if (resourcesImpl == null) {
            return false;
        }
        if (!sDrawableCacheFieldFetched) {
            try {
                sDrawableCacheField = resourcesImpl.getClass().getDeclaredField("mDrawableCache");
                sDrawableCacheField.setAccessible(true);
            }
            catch (NoSuchFieldException e) {
                Log.e((String)TAG, (String)"Could not retrieve ResourcesImpl#mDrawableCache field", (Throwable)e);
            }
            sDrawableCacheFieldFetched = true;
        }
        Object drawableCache = null;
        if (sDrawableCacheField != null) {
            try {
                drawableCache = sDrawableCacheField.get(resourcesImpl);
            }
            catch (IllegalAccessException e) {
                Log.e((String)TAG, (String)"Could not retrieve value from ResourcesImpl#mDrawableCache", (Throwable)e);
            }
        }
        return drawableCache != null && ResourcesFlusher.flushThemedResourcesCache(drawableCache);
    }

    private static boolean flushThemedResourcesCache(@NonNull Object cache) {
        if (!sThemedResourceCacheClazzFetched) {
            try {
                sThemedResourceCacheClazz = Class.forName("android.content.res.ThemedResourceCache");
            }
            catch (ClassNotFoundException e) {
                Log.e((String)TAG, (String)"Could not find ThemedResourceCache class", (Throwable)e);
            }
            sThemedResourceCacheClazzFetched = true;
        }
        if (sThemedResourceCacheClazz == null) {
            return false;
        }
        if (!sThemedResourceCache_mUnthemedEntriesFieldFetched) {
            try {
                sThemedResourceCache_mUnthemedEntriesField = sThemedResourceCacheClazz.getDeclaredField("mUnthemedEntries");
                sThemedResourceCache_mUnthemedEntriesField.setAccessible(true);
            }
            catch (NoSuchFieldException ee) {
                Log.e((String)TAG, (String)"Could not retrieve ThemedResourceCache#mUnthemedEntries field", (Throwable)ee);
            }
            sThemedResourceCache_mUnthemedEntriesFieldFetched = true;
        }
        if (sThemedResourceCache_mUnthemedEntriesField == null) {
            return false;
        }
        LongSparseArray unthemedEntries = null;
        try {
            unthemedEntries = (LongSparseArray)sThemedResourceCache_mUnthemedEntriesField.get(cache);
        }
        catch (IllegalAccessException e) {
            Log.e((String)TAG, (String)"Could not retrieve value from ThemedResourceCache#mUnthemedEntries", (Throwable)e);
        }
        if (unthemedEntries != null) {
            unthemedEntries.clear();
            return true;
        }
        return false;
    }
}

