/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.fresco;

import android.util.Pair;
import com.facebook.imagepipeline.listener.BaseRequestListener;
import com.facebook.imagepipeline.request.ImageRequest;
import com.facebook.systrace.Systrace;
import java.util.HashMap;
import java.util.Map;

public class SystraceRequestListener
extends BaseRequestListener {
    int mCurrentID = 0;
    Map<String, Pair<Integer, String>> mProducerID = new HashMap<String, Pair<Integer, String>>();
    Map<String, Pair<Integer, String>> mRequestsID = new HashMap<String, Pair<Integer, String>>();

    public void onProducerStart(String requestId, String producerName) {
        if (!Systrace.isTracing(0L)) {
            return;
        }
        StringBuilder entryName = new StringBuilder();
        entryName.append("FRESCO_PRODUCER_");
        entryName.append(producerName.replace(':', '_'));
        Pair requestPair = Pair.create((Object)this.mCurrentID, (Object)entryName.toString());
        Systrace.beginAsyncSection(0L, (String)requestPair.second, this.mCurrentID);
        this.mProducerID.put(requestId, (Pair<Integer, String>)requestPair);
        ++this.mCurrentID;
    }

    public void onProducerFinishWithSuccess(String requestId, String producerName, Map<String, String> extraMap) {
        if (!Systrace.isTracing(0L)) {
            return;
        }
        if (this.mProducerID.containsKey(requestId)) {
            Pair<Integer, String> entry = this.mProducerID.get(requestId);
            Systrace.endAsyncSection(0L, (String)entry.second, (Integer)entry.first);
            this.mProducerID.remove(requestId);
        }
    }

    public void onProducerFinishWithFailure(String requestId, String producerName, Throwable throwable, Map<String, String> extraMap) {
        if (!Systrace.isTracing(0L)) {
            return;
        }
        if (this.mProducerID.containsKey(requestId)) {
            Pair<Integer, String> entry = this.mProducerID.get(requestId);
            Systrace.endAsyncSection(0L, (String)entry.second, (Integer)entry.first);
            this.mProducerID.remove(requestId);
        }
    }

    public void onProducerFinishWithCancellation(String requestId, String producerName, Map<String, String> extraMap) {
        if (!Systrace.isTracing(0L)) {
            return;
        }
        if (this.mProducerID.containsKey(requestId)) {
            Pair<Integer, String> entry = this.mProducerID.get(requestId);
            Systrace.endAsyncSection(0L, (String)entry.second, (Integer)entry.first);
            this.mProducerID.remove(requestId);
        }
    }

    public void onProducerEvent(String requestId, String producerName, String producerEventName) {
        if (!Systrace.isTracing(0L)) {
            return;
        }
        StringBuilder entryName = new StringBuilder();
        entryName.append("FRESCO_PRODUCER_EVENT_");
        entryName.append(requestId.replace(':', '_'));
        entryName.append("_");
        entryName.append(producerName.replace(':', '_'));
        entryName.append("_");
        entryName.append(producerEventName.replace(':', '_'));
        Systrace.traceInstant(0L, entryName.toString(), Systrace.EventScope.THREAD);
    }

    public void onRequestStart(ImageRequest request, Object callerContext, String requestId, boolean isPrefetch) {
        if (!Systrace.isTracing(0L)) {
            return;
        }
        StringBuilder entryName = new StringBuilder();
        entryName.append("FRESCO_REQUEST_");
        entryName.append(request.getSourceUri().toString().replace(':', '_'));
        Pair requestPair = Pair.create((Object)this.mCurrentID, (Object)entryName.toString());
        Systrace.beginAsyncSection(0L, (String)requestPair.second, this.mCurrentID);
        this.mRequestsID.put(requestId, (Pair<Integer, String>)requestPair);
        ++this.mCurrentID;
    }

    public void onRequestSuccess(ImageRequest request, String requestId, boolean isPrefetch) {
        if (!Systrace.isTracing(0L)) {
            return;
        }
        if (this.mRequestsID.containsKey(requestId)) {
            Pair<Integer, String> entry = this.mRequestsID.get(requestId);
            Systrace.endAsyncSection(0L, (String)entry.second, (Integer)entry.first);
            this.mRequestsID.remove(requestId);
        }
    }

    public void onRequestFailure(ImageRequest request, String requestId, Throwable throwable, boolean isPrefetch) {
        if (!Systrace.isTracing(0L)) {
            return;
        }
        if (this.mRequestsID.containsKey(requestId)) {
            Pair<Integer, String> entry = this.mRequestsID.get(requestId);
            Systrace.endAsyncSection(0L, (String)entry.second, (Integer)entry.first);
            this.mRequestsID.remove(requestId);
        }
    }

    public void onRequestCancellation(String requestId) {
        if (!Systrace.isTracing(0L)) {
            return;
        }
        if (this.mRequestsID.containsKey(requestId)) {
            Pair<Integer, String> entry = this.mRequestsID.get(requestId);
            Systrace.endAsyncSection(0L, (String)entry.second, (Integer)entry.first);
            this.mRequestsID.remove(requestId);
        }
    }

    public boolean requiresExtraMap(String id) {
        return false;
    }
}

