/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge;

import com.facebook.infer.annotation.Assertions;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.CatalystInstance;
import com.facebook.react.bridge.JavaScriptModule;
import com.facebook.react.bridge.JavaScriptModuleRegistration;
import com.facebook.react.bridge.WritableNativeArray;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;

public class JavaScriptModuleRegistry {
    private final HashMap<Class<? extends JavaScriptModule>, JavaScriptModule> mModuleInstances = new HashMap();
    private final HashMap<Class<? extends JavaScriptModule>, JavaScriptModuleRegistration> mModuleRegistrations = new HashMap();

    public JavaScriptModuleRegistry(List<JavaScriptModuleRegistration> config) {
        for (JavaScriptModuleRegistration registration : config) {
            this.mModuleRegistrations.put(registration.getModuleInterface(), registration);
        }
    }

    public synchronized <T extends JavaScriptModule> T getJavaScriptModule(CatalystInstance instance, Class<T> moduleInterface) {
        JavaScriptModule module = this.mModuleInstances.get(moduleInterface);
        if (module != null) {
            return (T)module;
        }
        JavaScriptModuleRegistration registration = (JavaScriptModuleRegistration)Assertions.assertNotNull((Object)this.mModuleRegistrations.get(moduleInterface), (String)("JS module " + moduleInterface.getSimpleName() + " hasn't been registered!"));
        JavaScriptModule interfaceProxy = (JavaScriptModule)Proxy.newProxyInstance(moduleInterface.getClassLoader(), new Class[]{moduleInterface}, (InvocationHandler)new JavaScriptModuleInvocationHandler(instance, registration));
        this.mModuleInstances.put(moduleInterface, interfaceProxy);
        return (T)interfaceProxy;
    }

    private static class JavaScriptModuleInvocationHandler
    implements InvocationHandler {
        private final CatalystInstance mCatalystInstance;
        private final JavaScriptModuleRegistration mModuleRegistration;

        public JavaScriptModuleInvocationHandler(CatalystInstance catalystInstance, JavaScriptModuleRegistration moduleRegistration) {
            this.mCatalystInstance = catalystInstance;
            this.mModuleRegistration = moduleRegistration;
        }

        @Override
        @Nullable
        public Object invoke(Object proxy, Method method, @Nullable Object[] args) throws Throwable {
            WritableNativeArray jsArgs = args != null ? Arguments.fromJavaArgs(args) : new WritableNativeArray();
            this.mCatalystInstance.callFunction(this.mModuleRegistration.getName(), method.getName(), jsArgs);
            return null;
        }
    }

    public static class Builder {
        private List<JavaScriptModuleRegistration> mModules = new ArrayList<JavaScriptModuleRegistration>();

        public Builder add(Class<? extends JavaScriptModule> moduleInterfaceClass) {
            this.mModules.add(new JavaScriptModuleRegistration(moduleInterfaceClass));
            return this;
        }

        public JavaScriptModuleRegistry build() {
            return new JavaScriptModuleRegistry(this.mModules);
        }
    }
}

