/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.soloader;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.os.Build;
import com.facebook.soloader.ApkSoSource;
import com.facebook.soloader.DirectorySoSource;
import com.facebook.soloader.ExoSoSource;
import com.facebook.soloader.NoopSoSource;
import com.facebook.soloader.SoSource;
import com.facebook.soloader.SysUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;

@SuppressLint(value={"BadMethodUse-android.util.Log.v", "BadMethodUse-android.util.Log.d", "BadMethodUse-android.util.Log.i", "BadMethodUse-android.util.Log.w", "BadMethodUse-android.util.Log.e"})
public class SoLoader {
    static final String TAG = "SoLoader";
    static final boolean DEBUG = false;
    @Nullable
    private static SoSource[] sSoSources = null;
    private static final Set<String> sLoadedLibraries = new HashSet<String>();

    public static synchronized void init(@Nullable Context context, boolean isNativeExopackageEnabled) {
        if (sSoSources == null) {
            ArrayList<DirectorySoSource> soSources = new ArrayList<DirectorySoSource>();
            String LD_LIBRARY_PATH = System.getenv("LD_LIBRARY_PATH");
            if (LD_LIBRARY_PATH == null) {
                LD_LIBRARY_PATH = "/vendor/lib:/system/lib";
            }
            String[] systemLibraryDirectories = LD_LIBRARY_PATH.split(":");
            for (int i = 0; i < systemLibraryDirectories.length; ++i) {
                File systemSoDirectory = new File(systemLibraryDirectories[i]);
                soSources.add(new DirectorySoSource(systemSoDirectory, 2));
            }
            if (context != null) {
                ApplicationInfo applicationInfo = context.getApplicationInfo();
                boolean isSystemApplication = (applicationInfo.flags & 1) != 0 && (applicationInfo.flags & 0x80) == 0;
                try {
                    if (isNativeExopackageEnabled) {
                        soSources.add(0, new ExoSoSource(context));
                    } else if (isSystemApplication) {
                        soSources.add(0, new ApkSoSource(context));
                    } else {
                        SysUtil.dumbDeleteRecrusive(SysUtil.getLibsDirectory(context));
                        int ourSoSourceFlags = 0;
                        if (Build.VERSION.SDK_INT <= 17) {
                            ourSoSourceFlags |= 1;
                        }
                        DirectorySoSource ourSoSource = new DirectorySoSource(new File(applicationInfo.nativeLibraryDir), ourSoSourceFlags);
                        soSources.add(0, ourSoSource);
                    }
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
            sSoSources = soSources.toArray(new SoSource[soSources.size()]);
        }
    }

    public static void setInTestMode() {
        sSoSources = new SoSource[]{new NoopSoSource()};
    }

    public static synchronized void loadLibrary(String shortName) throws UnsatisfiedLinkError {
        if (sSoSources == null) {
            if ("http://www.android.com/".equals(System.getProperty("java.vendor.url"))) {
                SoLoader.assertInitialized();
            } else {
                System.loadLibrary(shortName);
                return;
            }
        }
        try {
            SoLoader.loadLibraryBySoName(System.mapLibraryName(shortName), 0);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static File unpackLibraryAndDependencies(String shortName) throws UnsatisfiedLinkError {
        SoLoader.assertInitialized();
        try {
            return SoLoader.unpackLibraryBySoName(System.mapLibraryName(shortName));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    static void loadLibraryBySoName(String soName, int loadFlags) throws IOException {
        int result = sLoadedLibraries.contains(soName) ? 1 : 0;
        for (int i = 0; result == 0 && i < sSoSources.length; ++i) {
            result = sSoSources[i].loadLibrary(soName, loadFlags);
        }
        if (result == 0) {
            throw new UnsatisfiedLinkError("could find DSO to load: " + soName);
        }
        if (result == 1) {
            sLoadedLibraries.add(soName);
        }
    }

    static File unpackLibraryBySoName(String soName) throws IOException {
        for (int i = 0; i < sSoSources.length; ++i) {
            File unpacked = sSoSources[i].unpackLibrary(soName);
            if (unpacked == null) continue;
            return unpacked;
        }
        throw new FileNotFoundException(soName);
    }

    private static void assertInitialized() {
        if (sSoSources == null) {
            throw new RuntimeException("SoLoader.init() not yet called");
        }
    }
}

