/*
 * Decompiled with CFR 0.152.
 */
package android.support.design.internal;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.RestrictTo;
import android.support.design.R;
import android.support.design.widget.BaseTransientBottomBar;
import android.support.v4.view.ViewCompat;
import android.util.AttributeSet;
import android.view.View;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.TextView;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class SnackbarContentLayout
extends LinearLayout
implements BaseTransientBottomBar.ContentViewCallback {
    private TextView mMessageView;
    private Button mActionView;
    private int mMaxWidth;
    private int mMaxInlineActionWidth;

    public SnackbarContentLayout(Context context) {
        this(context, null);
    }

    public SnackbarContentLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.SnackbarLayout);
        this.mMaxWidth = a.getDimensionPixelSize(R.styleable.SnackbarLayout_android_maxWidth, -1);
        this.mMaxInlineActionWidth = a.getDimensionPixelSize(R.styleable.SnackbarLayout_maxActionInlineWidth, -1);
        a.recycle();
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.mMessageView = (TextView)this.findViewById(R.id.snackbar_text);
        this.mActionView = (Button)this.findViewById(R.id.snackbar_action);
    }

    public TextView getMessageView() {
        return this.mMessageView;
    }

    public Button getActionView() {
        return this.mActionView;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.mMaxWidth > 0 && this.getMeasuredWidth() > this.mMaxWidth) {
            widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)this.mMaxWidth, (int)0x40000000);
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }
        int multiLineVPadding = this.getResources().getDimensionPixelSize(R.dimen.design_snackbar_padding_vertical_2lines);
        int singleLineVPadding = this.getResources().getDimensionPixelSize(R.dimen.design_snackbar_padding_vertical);
        boolean isMultiLine = this.mMessageView.getLayout().getLineCount() > 1;
        boolean remeasure = false;
        if (isMultiLine && this.mMaxInlineActionWidth > 0 && this.mActionView.getMeasuredWidth() > this.mMaxInlineActionWidth) {
            if (this.updateViewsWithinLayout(1, multiLineVPadding, multiLineVPadding - singleLineVPadding)) {
                remeasure = true;
            }
        } else {
            int messagePadding;
            int n = messagePadding = isMultiLine ? multiLineVPadding : singleLineVPadding;
            if (this.updateViewsWithinLayout(0, messagePadding, messagePadding)) {
                remeasure = true;
            }
        }
        if (remeasure) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }
    }

    private boolean updateViewsWithinLayout(int orientation, int messagePadTop, int messagePadBottom) {
        boolean changed = false;
        if (orientation != this.getOrientation()) {
            this.setOrientation(orientation);
            changed = true;
        }
        if (this.mMessageView.getPaddingTop() != messagePadTop || this.mMessageView.getPaddingBottom() != messagePadBottom) {
            SnackbarContentLayout.updateTopBottomPadding((View)this.mMessageView, messagePadTop, messagePadBottom);
            changed = true;
        }
        return changed;
    }

    private static void updateTopBottomPadding(View view, int topPadding, int bottomPadding) {
        if (ViewCompat.isPaddingRelative((View)view)) {
            ViewCompat.setPaddingRelative((View)view, (int)ViewCompat.getPaddingStart((View)view), (int)topPadding, (int)ViewCompat.getPaddingEnd((View)view), (int)bottomPadding);
        } else {
            view.setPadding(view.getPaddingLeft(), topPadding, view.getPaddingRight(), bottomPadding);
        }
    }

    @Override
    public void animateContentIn(int delay, int duration) {
        ViewCompat.setAlpha((View)this.mMessageView, (float)0.0f);
        ViewCompat.animate((View)this.mMessageView).alpha(1.0f).setDuration((long)duration).setStartDelay((long)delay).start();
        if (this.mActionView.getVisibility() == 0) {
            ViewCompat.setAlpha((View)this.mActionView, (float)0.0f);
            ViewCompat.animate((View)this.mActionView).alpha(1.0f).setDuration((long)duration).setStartDelay((long)delay).start();
        }
    }

    @Override
    public void animateContentOut(int delay, int duration) {
        ViewCompat.setAlpha((View)this.mMessageView, (float)1.0f);
        ViewCompat.animate((View)this.mMessageView).alpha(0.0f).setDuration((long)duration).setStartDelay((long)delay).start();
        if (this.mActionView.getVisibility() == 0) {
            ViewCompat.setAlpha((View)this.mActionView, (float)1.0f);
            ViewCompat.animate((View)this.mActionView).alpha(0.0f).setDuration((long)duration).setStartDelay((long)delay).start();
        }
    }
}

