/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react;

import com.facebook.react.LazyReactPackage;
import com.facebook.react.ReactInstanceManager;
import com.facebook.react.bridge.ModuleSpec;
import com.facebook.react.bridge.NativeModule;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactMarker;
import com.facebook.react.bridge.ReactMarkerConstants;
import com.facebook.react.module.model.ReactModuleInfoProvider;
import com.facebook.react.uimanager.UIImplementationProvider;
import com.facebook.react.uimanager.UIManagerModule;
import com.facebook.react.uimanager.ViewManager;
import com.facebook.systrace.Systrace;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Provider;

public class ReactNativeCorePackage
extends LazyReactPackage {
    private final ReactInstanceManager mReactInstanceManager;
    private final UIImplementationProvider mUIImplementationProvider;
    private final boolean mLazyViewManagersEnabled;
    private final int mMinTimeLeftInFrameForNonBatchedOperationMs;

    public ReactNativeCorePackage(ReactInstanceManager reactInstanceManager, UIImplementationProvider uiImplementationProvider, boolean lazyViewManagersEnabled, int minTimeLeftInFrameForNonBatchedOperationMs) {
        this.mReactInstanceManager = reactInstanceManager;
        this.mUIImplementationProvider = uiImplementationProvider;
        this.mLazyViewManagersEnabled = lazyViewManagersEnabled;
        this.mMinTimeLeftInFrameForNonBatchedOperationMs = minTimeLeftInFrameForNonBatchedOperationMs;
    }

    @Override
    public List<ModuleSpec> getNativeModules(final ReactApplicationContext reactContext) {
        ArrayList<ModuleSpec> moduleSpecList = new ArrayList<ModuleSpec>();
        moduleSpecList.add(new ModuleSpec(UIManagerModule.class, (Provider<? extends NativeModule>)new Provider<NativeModule>(){

            public NativeModule get() {
                return ReactNativeCorePackage.this.createUIManager(reactContext);
            }
        }));
        return moduleSpecList;
    }

    @Override
    public ReactModuleInfoProvider getReactModuleInfoProvider() {
        ReactModuleInfoProvider reactModuleInfoProvider = LazyReactPackage.getReactModuleInfoProviderViaReflection(this);
        return reactModuleInfoProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UIManagerModule createUIManager(ReactApplicationContext reactContext) {
        ReactMarker.logMarker(ReactMarkerConstants.CREATE_UI_MANAGER_MODULE_START);
        Systrace.beginSection(0L, "createUIManagerModule");
        try {
            List<ViewManager> viewManagersList = this.mReactInstanceManager.createAllViewManagers(reactContext);
            UIManagerModule uIManagerModule = new UIManagerModule(reactContext, viewManagersList, this.mUIImplementationProvider, this.mLazyViewManagersEnabled, this.mMinTimeLeftInFrameForNonBatchedOperationMs);
            return uIManagerModule;
        }
        finally {
            Systrace.endSection(0L);
            ReactMarker.logMarker(ReactMarkerConstants.CREATE_UI_MANAGER_MODULE_END);
        }
    }
}

