/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.location;

import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import com.facebook.common.logging.FLog;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.common.SystemClock;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.modules.core.DeviceEventManagerModule;
import com.facebook.react.modules.location.PositionError;
import javax.annotation.Nullable;

@ReactModule(name="LocationObserver")
public class LocationModule
extends ReactContextBaseJavaModule {
    @Nullable
    private String mWatchedProvider;
    private static final float RCT_DEFAULT_LOCATION_ACCURACY = 100.0f;
    private final LocationListener mLocationListener = new LocationListener(){

        public void onLocationChanged(Location location) {
            LocationModule.this.getReactApplicationContext().getJSModule(DeviceEventManagerModule.RCTDeviceEventEmitter.class).emit("geolocationDidChange", LocationModule.locationToMap(location));
        }

        public void onStatusChanged(String provider, int status, Bundle extras) {
            if (status == 0) {
                LocationModule.this.emitError(PositionError.POSITION_UNAVAILABLE, "Provider " + provider + " is out of service.");
            } else if (status == 1) {
                LocationModule.this.emitError(PositionError.TIMEOUT, "Provider " + provider + " is temporarily unavailable.");
            }
        }

        public void onProviderEnabled(String provider) {
        }

        public void onProviderDisabled(String provider) {
        }
    };

    public LocationModule(ReactApplicationContext reactContext) {
        super(reactContext);
    }

    @Override
    public String getName() {
        return "LocationObserver";
    }

    @ReactMethod
    public void getCurrentPosition(ReadableMap options, Callback success, Callback error) {
        LocationOptions locationOptions = LocationOptions.fromReactMap(options);
        try {
            LocationManager locationManager = (LocationManager)this.getReactApplicationContext().getSystemService("location");
            String provider = LocationModule.getValidProvider(locationManager, locationOptions.highAccuracy);
            if (provider == null) {
                error.invoke(PositionError.buildError(PositionError.PERMISSION_DENIED, "No location provider available."));
                return;
            }
            Location location = locationManager.getLastKnownLocation(provider);
            if (location != null && (double)(SystemClock.currentTimeMillis() - location.getTime()) < locationOptions.maximumAge) {
                success.invoke(LocationModule.locationToMap(location));
                return;
            }
            new SingleUpdateRequest(locationManager, provider, locationOptions.timeout, success, error).invoke(location);
        }
        catch (SecurityException e) {
            LocationModule.throwLocationPermissionMissing(e);
        }
    }

    @ReactMethod
    public void startObserving(ReadableMap options) {
        if ("gps".equals(this.mWatchedProvider)) {
            return;
        }
        LocationOptions locationOptions = LocationOptions.fromReactMap(options);
        try {
            LocationManager locationManager = (LocationManager)this.getReactApplicationContext().getSystemService("location");
            String provider = LocationModule.getValidProvider(locationManager, locationOptions.highAccuracy);
            if (provider == null) {
                this.emitError(PositionError.PERMISSION_DENIED, "No location provider available.");
                return;
            }
            if (!provider.equals(this.mWatchedProvider)) {
                locationManager.removeUpdates(this.mLocationListener);
                locationManager.requestLocationUpdates(provider, 1000L, locationOptions.distanceFilter, this.mLocationListener);
            }
            this.mWatchedProvider = provider;
        }
        catch (SecurityException e) {
            LocationModule.throwLocationPermissionMissing(e);
        }
    }

    @ReactMethod
    public void stopObserving() {
        LocationManager locationManager = (LocationManager)this.getReactApplicationContext().getSystemService("location");
        locationManager.removeUpdates(this.mLocationListener);
        this.mWatchedProvider = null;
    }

    @Nullable
    private static String getValidProvider(LocationManager locationManager, boolean highAccuracy) {
        String provider;
        String string = provider = highAccuracy ? "gps" : "network";
        if (!locationManager.isProviderEnabled(provider)) {
            String string2 = provider = provider.equals("gps") ? "network" : "gps";
            if (!locationManager.isProviderEnabled(provider)) {
                return null;
            }
        }
        return provider;
    }

    private static WritableMap locationToMap(Location location) {
        WritableMap map = Arguments.createMap();
        WritableMap coords = Arguments.createMap();
        coords.putDouble("latitude", location.getLatitude());
        coords.putDouble("longitude", location.getLongitude());
        coords.putDouble("altitude", location.getAltitude());
        coords.putDouble("accuracy", location.getAccuracy());
        coords.putDouble("heading", location.getBearing());
        coords.putDouble("speed", location.getSpeed());
        map.putMap("coords", coords);
        map.putDouble("timestamp", location.getTime());
        if (Build.VERSION.SDK_INT >= 18) {
            map.putBoolean("mocked", location.isFromMockProvider());
        }
        return map;
    }

    private void emitError(int code, String message) {
        this.getReactApplicationContext().getJSModule(DeviceEventManagerModule.RCTDeviceEventEmitter.class).emit("geolocationError", PositionError.buildError(code, message));
    }

    private static void throwLocationPermissionMissing(SecurityException e) {
        throw new SecurityException("Looks like the app doesn't have the permission to access location.\nAdd the following line to your app's AndroidManifest.xml:\n<uses-permission android:name=\"android.permission.ACCESS_FINE_LOCATION\" />", e);
    }

    private static class SingleUpdateRequest {
        private final Callback mSuccess;
        private final Callback mError;
        private final LocationManager mLocationManager;
        private final String mProvider;
        private final long mTimeout;
        private Location mOldLocation;
        private final Handler mHandler = new Handler();
        private final Runnable mTimeoutRunnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                SingleUpdateRequest singleUpdateRequest = SingleUpdateRequest.this;
                synchronized (singleUpdateRequest) {
                    if (!SingleUpdateRequest.this.mTriggered) {
                        SingleUpdateRequest.this.mError.invoke(PositionError.buildError(PositionError.TIMEOUT, "Location request timed out"));
                        SingleUpdateRequest.this.mLocationManager.removeUpdates(SingleUpdateRequest.this.mLocationListener);
                        FLog.i((String)"ReactNative", (String)"LocationModule: Location request timed out");
                        SingleUpdateRequest.this.mTriggered = true;
                    }
                }
            }
        };
        private final LocationListener mLocationListener = new LocationListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onLocationChanged(Location location) {
                SingleUpdateRequest singleUpdateRequest = SingleUpdateRequest.this;
                synchronized (singleUpdateRequest) {
                    if (!SingleUpdateRequest.this.mTriggered && SingleUpdateRequest.this.isBetterLocation(location, SingleUpdateRequest.this.mOldLocation)) {
                        SingleUpdateRequest.this.mSuccess.invoke(LocationModule.locationToMap(location));
                        SingleUpdateRequest.this.mHandler.removeCallbacks(SingleUpdateRequest.this.mTimeoutRunnable);
                        SingleUpdateRequest.this.mTriggered = true;
                        SingleUpdateRequest.this.mLocationManager.removeUpdates(SingleUpdateRequest.this.mLocationListener);
                    }
                    SingleUpdateRequest.this.mOldLocation = location;
                }
            }

            public void onStatusChanged(String provider, int status, Bundle extras) {
            }

            public void onProviderEnabled(String provider) {
            }

            public void onProviderDisabled(String provider) {
            }
        };
        private boolean mTriggered;
        private static final int TWO_MINUTES = 120000;

        private SingleUpdateRequest(LocationManager locationManager, String provider, long timeout, Callback success, Callback error) {
            this.mLocationManager = locationManager;
            this.mProvider = provider;
            this.mTimeout = timeout;
            this.mSuccess = success;
            this.mError = error;
        }

        public void invoke(Location location) {
            this.mOldLocation = location;
            this.mLocationManager.requestLocationUpdates(this.mProvider, 100L, 1.0f, this.mLocationListener);
            this.mHandler.postDelayed(this.mTimeoutRunnable, this.mTimeout);
        }

        private boolean isBetterLocation(Location location, Location currentBestLocation) {
            boolean isNewer;
            if (currentBestLocation == null) {
                return true;
            }
            long timeDelta = location.getTime() - currentBestLocation.getTime();
            boolean isSignificantlyNewer = timeDelta > 120000L;
            boolean isSignificantlyOlder = timeDelta < -120000L;
            boolean bl = isNewer = timeDelta > 0L;
            if (isSignificantlyNewer) {
                return true;
            }
            if (isSignificantlyOlder) {
                return false;
            }
            int accuracyDelta = (int)(location.getAccuracy() - currentBestLocation.getAccuracy());
            boolean isLessAccurate = accuracyDelta > 0;
            boolean isMoreAccurate = accuracyDelta < 0;
            boolean isSignificantlyLessAccurate = accuracyDelta > 200;
            boolean isFromSameProvider = this.isSameProvider(location.getProvider(), currentBestLocation.getProvider());
            if (isMoreAccurate) {
                return true;
            }
            if (isNewer && !isLessAccurate) {
                return true;
            }
            return isNewer && !isSignificantlyLessAccurate && isFromSameProvider;
        }

        private boolean isSameProvider(String provider1, String provider2) {
            if (provider1 == null) {
                return provider2 == null;
            }
            return provider1.equals(provider2);
        }
    }

    private static class LocationOptions {
        private final long timeout;
        private final double maximumAge;
        private final boolean highAccuracy;
        private final float distanceFilter;

        private LocationOptions(long timeout, double maximumAge, boolean highAccuracy, float distanceFilter) {
            this.timeout = timeout;
            this.maximumAge = maximumAge;
            this.highAccuracy = highAccuracy;
            this.distanceFilter = distanceFilter;
        }

        private static LocationOptions fromReactMap(ReadableMap map) {
            long timeout = map.hasKey("timeout") ? (long)map.getDouble("timeout") : Long.MAX_VALUE;
            double maximumAge = map.hasKey("maximumAge") ? map.getDouble("maximumAge") : Double.POSITIVE_INFINITY;
            boolean highAccuracy = map.hasKey("enableHighAccuracy") && map.getBoolean("enableHighAccuracy");
            float distanceFilter = map.hasKey("distanceFilter") ? (float)map.getDouble("distanceFilter") : 100.0f;
            return new LocationOptions(timeout, maximumAge, highAccuracy, distanceFilter);
        }
    }
}

