/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.cxxbridge;

import com.facebook.proguard.annotations.DoNotStrip;
import com.facebook.react.bridge.BaseJavaModule;
import com.facebook.react.bridge.JSInstance;
import com.facebook.react.bridge.NativeArray;
import com.facebook.react.bridge.NativeModule;
import com.facebook.react.bridge.ReactMarker;
import com.facebook.react.bridge.ReactMarkerConstants;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.ReadableNativeArray;
import com.facebook.react.bridge.WritableNativeArray;
import com.facebook.react.bridge.WritableNativeMap;
import com.facebook.react.cxxbridge.Arguments;
import com.facebook.react.cxxbridge.JavaMethodWrapper;
import com.facebook.react.cxxbridge.ModuleHolder;
import com.facebook.systrace.Systrace;
import com.facebook.systrace.SystraceMessage;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

@DoNotStrip
public class JavaModuleWrapper {
    private final JSInstance mJSInstance;
    private final ModuleHolder mModuleHolder;
    private final Class<? extends NativeModule> mModuleClass;
    private final ArrayList<NativeModule.NativeMethod> mMethods;
    private final ArrayList<MethodDescriptor> mDescs;

    public JavaModuleWrapper(JSInstance jsInstance, Class<? extends NativeModule> moduleClass, ModuleHolder moduleHolder) {
        this.mJSInstance = jsInstance;
        this.mModuleHolder = moduleHolder;
        this.mModuleClass = moduleClass;
        this.mMethods = new ArrayList();
        this.mDescs = new ArrayList();
    }

    @DoNotStrip
    public BaseJavaModule getModule() {
        return (BaseJavaModule)this.mModuleHolder.getModule();
    }

    @DoNotStrip
    public String getName() {
        return this.mModuleHolder.getName();
    }

    @DoNotStrip
    private void findMethods() {
        Method[] targetMethods;
        Systrace.beginSection(0L, "findMethods");
        HashSet methodNames = new HashSet();
        for (Method targetMethod : targetMethods = this.mModuleClass.getDeclaredMethods()) {
            ReactMethod annotation = targetMethod.getAnnotation(ReactMethod.class);
            if (annotation == null) continue;
            String methodName = targetMethod.getName();
            if (methodNames.contains(methodName)) {
                throw new IllegalArgumentException("Java Module " + this.getName() + " method name already registered: " + methodName);
            }
            MethodDescriptor md = new MethodDescriptor();
            JavaMethodWrapper method = new JavaMethodWrapper(this, targetMethod, annotation.isBlockingSynchronousMethod());
            md.name = methodName;
            md.type = method.getType();
            if (md.type == "sync") {
                md.signature = method.getSignature();
                md.method = targetMethod;
            }
            this.mMethods.add(method);
            this.mDescs.add(md);
        }
        Systrace.endSection(0L);
    }

    @DoNotStrip
    public List<MethodDescriptor> getMethodDescriptors() {
        if (this.mDescs.isEmpty()) {
            this.findMethods();
        }
        return this.mDescs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @DoNotStrip
    public NativeArray getConstants() {
        WritableNativeMap writableNativeMap;
        if (!this.mModuleHolder.getHasConstants()) {
            return null;
        }
        BaseJavaModule baseJavaModule = this.getModule();
        ReactMarker.logMarker(ReactMarkerConstants.GET_CONSTANTS_START, this.getName());
        SystraceMessage.beginSection(0L, "Map constants").arg("moduleName", this.getName()).flush();
        Map<String, Object> map = baseJavaModule.getConstants();
        Systrace.endSection(0L);
        SystraceMessage.beginSection(0L, "WritableNativeMap constants").arg("moduleName", this.getName()).flush();
        ReactMarker.logMarker(ReactMarkerConstants.CONVERT_CONSTANTS_START, this.getName());
        try {
            writableNativeMap = Arguments.makeNativeMap(map);
        }
        finally {
            Systrace.endSection(0L);
        }
        WritableNativeArray array = new WritableNativeArray();
        array.pushMap(writableNativeMap);
        ReactMarker.logMarker(ReactMarkerConstants.CONVERT_CONSTANTS_END);
        ReactMarker.logMarker(ReactMarkerConstants.GET_CONSTANTS_END);
        return array;
    }

    @DoNotStrip
    public void invoke(int methodId, ReadableNativeArray parameters) {
        if (this.mMethods == null || methodId >= this.mMethods.size()) {
            return;
        }
        this.mMethods.get(methodId).invoke(this.mJSInstance, parameters);
    }

    @DoNotStrip
    public class MethodDescriptor {
        @DoNotStrip
        Method method;
        @DoNotStrip
        String signature;
        @DoNotStrip
        String name;
        @DoNotStrip
        String type;
    }
}

