/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.textinput;

import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.uimanager.events.Event;
import com.facebook.react.uimanager.events.RCTEventEmitter;

class ReactTextInputSelectionEvent
extends Event<ReactTextInputSelectionEvent> {
    private static final String EVENT_NAME = "topSelectionChange";
    private int mSelectionStart;
    private int mSelectionEnd;

    public ReactTextInputSelectionEvent(int viewId, long timestampMs, int selectionStart, int selectionEnd) {
        super(viewId, timestampMs);
        this.mSelectionStart = selectionStart;
        this.mSelectionEnd = selectionEnd;
    }

    @Override
    public String getEventName() {
        return EVENT_NAME;
    }

    @Override
    public void dispatch(RCTEventEmitter rctEventEmitter) {
        rctEventEmitter.receiveEvent(this.getViewTag(), this.getEventName(), this.serializeEventData());
    }

    private WritableMap serializeEventData() {
        WritableMap eventData = Arguments.createMap();
        WritableMap selectionData = Arguments.createMap();
        selectionData.putInt("start", this.mSelectionStart);
        selectionData.putInt("end", this.mSelectionEnd);
        eventData.putMap("selection", selectionData);
        return eventData;
    }
}

