/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drawee.backends.pipeline;

import android.content.res.Resources;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import com.facebook.cache.common.CacheKey;
import com.facebook.common.internal.ImmutableList;
import com.facebook.common.internal.Objects;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.internal.Supplier;
import com.facebook.common.logging.FLog;
import com.facebook.common.references.CloseableReference;
import com.facebook.datasource.DataSource;
import com.facebook.drawable.base.DrawableWithCaches;
import com.facebook.drawee.backends.pipeline.DrawableFactory;
import com.facebook.drawee.components.DeferredReleaser;
import com.facebook.drawee.controller.AbstractDraweeController;
import com.facebook.drawee.debug.DebugControllerOverlayDrawable;
import com.facebook.drawee.drawable.OrientedDrawable;
import com.facebook.drawee.drawable.ScaleTypeDrawable;
import com.facebook.drawee.drawable.ScalingUtils;
import com.facebook.drawee.interfaces.DraweeHierarchy;
import com.facebook.imagepipeline.animated.factory.AnimatedDrawableFactory;
import com.facebook.imagepipeline.cache.MemoryCache;
import com.facebook.imagepipeline.image.CloseableImage;
import com.facebook.imagepipeline.image.CloseableStaticBitmap;
import com.facebook.imagepipeline.image.ImageInfo;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;

public class PipelineDraweeController
extends AbstractDraweeController<CloseableReference<CloseableImage>, ImageInfo> {
    private static final Class<?> TAG = PipelineDraweeController.class;
    private final Resources mResources;
    private final AnimatedDrawableFactory mAnimatedDrawableFactory;
    @Nullable
    private final ImmutableList<DrawableFactory> mDrawableFactories;
    @Nullable
    private MemoryCache<CacheKey, CloseableImage> mMemoryCache;
    private CacheKey mCacheKey;
    private Supplier<DataSource<CloseableReference<CloseableImage>>> mDataSourceSupplier;
    private boolean mDrawDebugOverlay;
    private final DrawableFactory mDefaultDrawableFactory = new DrawableFactory(){

        @Override
        public boolean supportsImageType(CloseableImage image) {
            return true;
        }

        @Override
        public Drawable createDrawable(CloseableImage closeableImage) {
            if (closeableImage instanceof CloseableStaticBitmap) {
                CloseableStaticBitmap closeableStaticBitmap = (CloseableStaticBitmap)closeableImage;
                BitmapDrawable bitmapDrawable = new BitmapDrawable(PipelineDraweeController.this.mResources, closeableStaticBitmap.getUnderlyingBitmap());
                if (closeableStaticBitmap.getRotationAngle() == 0 || closeableStaticBitmap.getRotationAngle() == -1) {
                    return bitmapDrawable;
                }
                return new OrientedDrawable((Drawable)bitmapDrawable, closeableStaticBitmap.getRotationAngle());
            }
            if (PipelineDraweeController.this.mAnimatedDrawableFactory != null) {
                return PipelineDraweeController.this.mAnimatedDrawableFactory.create(closeableImage);
            }
            return null;
        }
    };

    public PipelineDraweeController(Resources resources, DeferredReleaser deferredReleaser, AnimatedDrawableFactory animatedDrawableFactory, Executor uiThreadExecutor, MemoryCache<CacheKey, CloseableImage> memoryCache, Supplier<DataSource<CloseableReference<CloseableImage>>> dataSourceSupplier, String id, CacheKey cacheKey, Object callerContext) {
        this(resources, deferredReleaser, animatedDrawableFactory, uiThreadExecutor, memoryCache, dataSourceSupplier, id, cacheKey, callerContext, null);
    }

    public PipelineDraweeController(Resources resources, DeferredReleaser deferredReleaser, AnimatedDrawableFactory animatedDrawableFactory, Executor uiThreadExecutor, MemoryCache<CacheKey, CloseableImage> memoryCache, Supplier<DataSource<CloseableReference<CloseableImage>>> dataSourceSupplier, String id, CacheKey cacheKey, Object callerContext, @Nullable ImmutableList<DrawableFactory> drawableFactories) {
        super(deferredReleaser, uiThreadExecutor, id, callerContext);
        this.mResources = resources;
        this.mAnimatedDrawableFactory = animatedDrawableFactory;
        this.mMemoryCache = memoryCache;
        this.mCacheKey = cacheKey;
        this.mDrawableFactories = drawableFactories;
        this.init(dataSourceSupplier);
    }

    public void initialize(Supplier<DataSource<CloseableReference<CloseableImage>>> dataSourceSupplier, String id, CacheKey cacheKey, Object callerContext) {
        super.initialize(id, callerContext);
        this.init(dataSourceSupplier);
        this.mCacheKey = cacheKey;
    }

    public void setDrawDebugOverlay(boolean drawDebugOverlay) {
        this.mDrawDebugOverlay = drawDebugOverlay;
    }

    private void init(Supplier<DataSource<CloseableReference<CloseableImage>>> dataSourceSupplier) {
        this.mDataSourceSupplier = dataSourceSupplier;
        this.maybeUpdateDebugOverlay(null);
    }

    protected Resources getResources() {
        return this.mResources;
    }

    protected DataSource<CloseableReference<CloseableImage>> getDataSource() {
        if (FLog.isLoggable((int)2)) {
            FLog.v(TAG, (String)"controller %x: getDataSource", (Object)System.identityHashCode((Object)this));
        }
        return (DataSource)this.mDataSourceSupplier.get();
    }

    protected Drawable createDrawable(CloseableReference<CloseableImage> image) {
        Drawable defaultDrawable;
        Preconditions.checkState((boolean)CloseableReference.isValid(image));
        CloseableImage closeableImage = (CloseableImage)image.get();
        this.maybeUpdateDebugOverlay(closeableImage);
        if (this.mDrawableFactories != null) {
            for (DrawableFactory factory : this.mDrawableFactories) {
                Drawable drawable;
                if (!factory.supportsImageType(closeableImage) || (drawable = factory.createDrawable(closeableImage)) == null) continue;
                return drawable;
            }
        }
        if ((defaultDrawable = this.mDefaultDrawableFactory.createDrawable(closeableImage)) != null) {
            return defaultDrawable;
        }
        throw new UnsupportedOperationException("Unrecognized image class: " + closeableImage);
    }

    public void setHierarchy(@Nullable DraweeHierarchy hierarchy) {
        super.setHierarchy(hierarchy);
        this.maybeUpdateDebugOverlay(null);
    }

    private void maybeUpdateDebugOverlay(@Nullable CloseableImage image) {
        if (!this.mDrawDebugOverlay) {
            return;
        }
        Drawable controllerOverlay = this.getControllerOverlay();
        if (controllerOverlay == null) {
            controllerOverlay = new DebugControllerOverlayDrawable();
            this.setControllerOverlay(controllerOverlay);
        }
        if (controllerOverlay instanceof DebugControllerOverlayDrawable) {
            DebugControllerOverlayDrawable debugOverlay = (DebugControllerOverlayDrawable)controllerOverlay;
            debugOverlay.setControllerId(this.getId());
            DraweeHierarchy draweeHierarchy = this.getHierarchy();
            ScalingUtils.ScaleType scaleType = null;
            if (draweeHierarchy != null) {
                ScaleTypeDrawable scaleTypeDrawable = ScalingUtils.getActiveScaleTypeDrawable((Drawable)draweeHierarchy.getTopLevelDrawable());
                scaleType = scaleTypeDrawable != null ? scaleTypeDrawable.getScaleType() : null;
            }
            debugOverlay.setScaleType(scaleType);
            if (image != null) {
                debugOverlay.setDimensions(image.getWidth(), image.getHeight());
                debugOverlay.setImageSize(image.getSizeInBytes());
            } else {
                debugOverlay.reset();
            }
        }
    }

    protected ImageInfo getImageInfo(CloseableReference<CloseableImage> image) {
        Preconditions.checkState((boolean)CloseableReference.isValid(image));
        return (ImageInfo)image.get();
    }

    protected int getImageHash(@Nullable CloseableReference<CloseableImage> image) {
        return image != null ? image.getValueHash() : 0;
    }

    protected void releaseImage(@Nullable CloseableReference<CloseableImage> image) {
        CloseableReference.closeSafely(image);
    }

    protected void releaseDrawable(@Nullable Drawable drawable) {
        if (drawable instanceof DrawableWithCaches) {
            ((DrawableWithCaches)drawable).dropCaches();
        }
    }

    protected CloseableReference<CloseableImage> getCachedImage() {
        if (this.mMemoryCache == null || this.mCacheKey == null) {
            return null;
        }
        CloseableReference closeableImage = this.mMemoryCache.get((Object)this.mCacheKey);
        if (closeableImage != null && !((CloseableImage)closeableImage.get()).getQualityInfo().isOfFullQuality()) {
            closeableImage.close();
            return null;
        }
        return closeableImage;
    }

    public String toString() {
        return Objects.toStringHelper((Object)((Object)this)).add("super", (Object)super.toString()).add("dataSourceSupplier", this.mDataSourceSupplier).toString();
    }
}

