/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Process;
import android.util.Log;
import com.facebook.common.logging.FLog;
import com.facebook.infer.annotation.Assertions;
import com.facebook.infer.annotation.ThreadConfined;
import com.facebook.infer.annotation.ThreadSafe;
import com.facebook.react.BridgeCorePackage;
import com.facebook.react.CoreModulesPackage;
import com.facebook.react.DebugCorePackage;
import com.facebook.react.MemoryPressureRouter;
import com.facebook.react.NativeModuleRegistryBuilder;
import com.facebook.react.ReactInstanceManagerBuilder;
import com.facebook.react.ReactNativeCorePackage;
import com.facebook.react.ReactPackage;
import com.facebook.react.ReactPackageLogger;
import com.facebook.react.ReactRootView;
import com.facebook.react.bridge.CatalystInstance;
import com.facebook.react.bridge.CatalystInstanceImpl;
import com.facebook.react.bridge.JSBundleLoader;
import com.facebook.react.bridge.JavaJSExecutor;
import com.facebook.react.bridge.JavaScriptExecutor;
import com.facebook.react.bridge.JavaScriptExecutorFactory;
import com.facebook.react.bridge.NativeArray;
import com.facebook.react.bridge.NativeModuleCallExceptionHandler;
import com.facebook.react.bridge.NativeModuleRegistry;
import com.facebook.react.bridge.NotThreadSafeBridgeIdleDebugListener;
import com.facebook.react.bridge.ProxyJavaScriptExecutor;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReactMarker;
import com.facebook.react.bridge.ReactMarkerConstants;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.bridge.queue.ReactQueueConfigurationSpec;
import com.facebook.react.common.LifecycleState;
import com.facebook.react.common.annotations.VisibleForTesting;
import com.facebook.react.devsupport.DevSupportManagerFactory;
import com.facebook.react.devsupport.ReactInstanceDevCommandsHandler;
import com.facebook.react.devsupport.RedBoxHandler;
import com.facebook.react.devsupport.interfaces.DevBundleDownloadListener;
import com.facebook.react.devsupport.interfaces.DevSupportManager;
import com.facebook.react.devsupport.interfaces.PackagerStatusCallback;
import com.facebook.react.modules.appregistry.AppRegistry;
import com.facebook.react.modules.core.DefaultHardwareBackBtnHandler;
import com.facebook.react.modules.core.DeviceEventManagerModule;
import com.facebook.react.modules.core.ReactChoreographer;
import com.facebook.react.modules.debug.interfaces.DeveloperSettings;
import com.facebook.react.uimanager.DisplayMetricsHolder;
import com.facebook.react.uimanager.UIImplementationProvider;
import com.facebook.react.uimanager.UIManagerModule;
import com.facebook.react.uimanager.ViewManager;
import com.facebook.react.views.imagehelper.ResourceDrawableIdHelper;
import com.facebook.soloader.SoLoader;
import com.facebook.systrace.Systrace;
import com.facebook.systrace.SystraceMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;

@ThreadSafe
public class ReactInstanceManager {
    private static final String TAG = ReactInstanceManager.class.getSimpleName();
    private final List<ReactRootView> mAttachedRootViews = Collections.synchronizedList(new ArrayList());
    private volatile LifecycleState mLifecycleState;
    @Nullable
    @ThreadConfined(value="UI")
    private ReactContextInitParams mPendingReactContextInitParams;
    @Nullable
    private volatile Thread mCreateReactContextThread;
    private final JavaScriptExecutorFactory mJavaScriptExecutorFactory;
    @Nullable
    private final JSBundleLoader mBundleLoader;
    @Nullable
    private final String mJSMainModulePath;
    private final List<ReactPackage> mPackages;
    private final List<CatalystInstanceImpl.PendingJSCall> mInitFunctions;
    private final DevSupportManager mDevSupportManager;
    private final boolean mUseDeveloperSupport;
    @Nullable
    private final NotThreadSafeBridgeIdleDebugListener mBridgeIdleDebugListener;
    @Nullable
    private volatile ReactContext mCurrentReactContext;
    private final Context mApplicationContext;
    @Nullable
    @ThreadConfined(value="UI")
    private DefaultHardwareBackBtnHandler mDefaultBackButtonImpl;
    @Nullable
    private Activity mCurrentActivity;
    private final Collection<ReactInstanceEventListener> mReactInstanceEventListeners = Collections.synchronizedSet(new HashSet());
    private volatile boolean mHasStartedCreatingInitialContext = false;
    private final UIImplementationProvider mUIImplementationProvider;
    private final MemoryPressureRouter mMemoryPressureRouter;
    @Nullable
    private final NativeModuleCallExceptionHandler mNativeModuleCallExceptionHandler;
    private final boolean mLazyNativeModulesEnabled;
    private final boolean mLazyViewManagersEnabled;
    private final boolean mUseSeparateUIBackgroundThread;
    private final int mMinNumShakes;
    private final int mMinTimeLeftInFrameForNonBatchedOperationMs;
    private final ReactInstanceDevCommandsHandler mDevInterface = new ReactInstanceDevCommandsHandler(){

        @Override
        public void onReloadWithJSDebugger(JavaJSExecutor.Factory jsExecutorFactory) {
            ReactInstanceManager.this.onReloadWithJSDebugger(jsExecutorFactory);
        }

        @Override
        public void onJSBundleLoadedFromServer() {
            ReactInstanceManager.this.onJSBundleLoadedFromServer();
        }

        @Override
        public void toggleElementInspector() {
            ReactInstanceManager.this.toggleElementInspector();
        }
    };
    private final DefaultHardwareBackBtnHandler mBackBtnHandler = new DefaultHardwareBackBtnHandler(){

        @Override
        public void invokeDefaultOnBackPressed() {
            ReactInstanceManager.this.invokeDefaultOnBackPressed();
        }
    };

    public static ReactInstanceManagerBuilder builder() {
        return new ReactInstanceManagerBuilder();
    }

    ReactInstanceManager(Context applicationContext, @Nullable Activity currentActivity, @Nullable DefaultHardwareBackBtnHandler defaultHardwareBackBtnHandler, JavaScriptExecutorFactory javaScriptExecutorFactory, @Nullable JSBundleLoader bundleLoader, @Nullable String jsMainModulePath, List<ReactPackage> packages, boolean useDeveloperSupport, @Nullable NotThreadSafeBridgeIdleDebugListener bridgeIdleDebugListener, LifecycleState initialLifecycleState, UIImplementationProvider uiImplementationProvider, NativeModuleCallExceptionHandler nativeModuleCallExceptionHandler, @Nullable RedBoxHandler redBoxHandler, boolean lazyNativeModulesEnabled, boolean lazyViewManagersEnabled, @Nullable DevBundleDownloadListener devBundleDownloadListener, boolean useSeparateUIBackgroundThread, int minNumShakes, boolean splitPackagesEnabled, boolean useOnlyDefaultPackages, int minTimeLeftInFrameForNonBatchedOperationMs) {
        Log.d((String)"ReactNative", (String)"ReactInstanceManager.ctor()");
        ReactInstanceManager.initializeSoLoaderIfNecessary(applicationContext);
        DisplayMetricsHolder.initDisplayMetricsIfNotInitialized(applicationContext);
        this.mApplicationContext = applicationContext;
        this.mCurrentActivity = currentActivity;
        this.mDefaultBackButtonImpl = defaultHardwareBackBtnHandler;
        this.mJavaScriptExecutorFactory = javaScriptExecutorFactory;
        this.mBundleLoader = bundleLoader;
        this.mJSMainModulePath = jsMainModulePath;
        this.mPackages = new ArrayList<ReactPackage>();
        this.mInitFunctions = new ArrayList<CatalystInstanceImpl.PendingJSCall>();
        this.mUseDeveloperSupport = useDeveloperSupport;
        this.mDevSupportManager = DevSupportManagerFactory.create(applicationContext, this.mDevInterface, this.mJSMainModulePath, useDeveloperSupport, redBoxHandler, devBundleDownloadListener, minNumShakes);
        this.mBridgeIdleDebugListener = bridgeIdleDebugListener;
        this.mLifecycleState = initialLifecycleState;
        this.mUIImplementationProvider = uiImplementationProvider;
        this.mMemoryPressureRouter = new MemoryPressureRouter(applicationContext);
        this.mNativeModuleCallExceptionHandler = nativeModuleCallExceptionHandler;
        this.mLazyNativeModulesEnabled = lazyNativeModulesEnabled;
        this.mLazyViewManagersEnabled = lazyViewManagersEnabled;
        this.mMinTimeLeftInFrameForNonBatchedOperationMs = minTimeLeftInFrameForNonBatchedOperationMs;
        this.mUseSeparateUIBackgroundThread = useSeparateUIBackgroundThread;
        this.mMinNumShakes = minNumShakes;
        if (!splitPackagesEnabled) {
            CoreModulesPackage coreModulesPackage = new CoreModulesPackage(this, this.mBackBtnHandler, this.mUIImplementationProvider, this.mLazyViewManagersEnabled, this.mMinTimeLeftInFrameForNonBatchedOperationMs);
            this.mPackages.add(coreModulesPackage);
        } else {
            this.mPackages.add(new BridgeCorePackage(this, this.mBackBtnHandler));
            if (this.mUseDeveloperSupport) {
                this.mPackages.add(new DebugCorePackage());
            }
            if (!useOnlyDefaultPackages) {
                this.mPackages.add(new ReactNativeCorePackage(this, this.mUIImplementationProvider, this.mLazyViewManagersEnabled, this.mMinTimeLeftInFrameForNonBatchedOperationMs));
            }
        }
        this.mPackages.addAll(packages);
        ReactChoreographer.initialize();
        if (this.mUseDeveloperSupport) {
            this.mDevSupportManager.startInspector();
        }
    }

    public DevSupportManager getDevSupportManager() {
        return this.mDevSupportManager;
    }

    public MemoryPressureRouter getMemoryPressureRouter() {
        return this.mMemoryPressureRouter;
    }

    private static void initializeSoLoaderIfNecessary(Context applicationContext) {
        SoLoader.init((Context)applicationContext, (boolean)false);
    }

    @ThreadConfined(value="UI")
    public void createReactContextInBackground() {
        Log.d((String)"ReactNative", (String)"ReactInstanceManager.createReactContextInBackground()");
        Assertions.assertCondition((!this.mHasStartedCreatingInitialContext ? 1 : 0) != 0, (String)"createReactContextInBackground should only be called when creating the react application for the first time. When reloading JS, e.g. from a new file, explicitlyuse recreateReactContextInBackground");
        this.mHasStartedCreatingInitialContext = true;
        this.recreateReactContextInBackgroundInner();
    }

    @ThreadConfined(value="UI")
    public void registerAdditionalPackages(List<ReactPackage> packages) {
        if (packages == null || packages.isEmpty()) {
            return;
        }
        if (!this.hasStartedCreatingInitialContext()) {
            for (ReactPackage p : packages) {
                if (this.mPackages.contains(p)) continue;
                this.mPackages.add(p);
            }
            return;
        }
        ReactContext context = this.getCurrentReactContext();
        CatalystInstance catalystInstance = context != null ? context.getCatalystInstance() : null;
        Assertions.assertNotNull((Object)catalystInstance, (String)"CatalystInstance null after hasStartedCreatingInitialContext true.");
        ReactApplicationContext reactContext = new ReactApplicationContext(this.mApplicationContext);
        NativeModuleRegistry nativeModuleRegistry = this.processPackages(reactContext, packages, true);
        catalystInstance.extendNativeModules(nativeModuleRegistry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerInitFunction(String module, String method, @Nullable NativeArray arguments) {
        CatalystInstance catalystInstance;
        CatalystInstanceImpl.PendingJSCall init = new CatalystInstanceImpl.PendingJSCall(module, method, arguments);
        ReactInstanceManager reactInstanceManager = this;
        synchronized (reactInstanceManager) {
            this.mInitFunctions.add(init);
        }
        ReactContext context = this.getCurrentReactContext();
        CatalystInstance catalystInstance2 = catalystInstance = context == null ? null : context.getCatalystInstance();
        if (catalystInstance == null) {
            return;
        }
        ((CatalystInstanceImpl)catalystInstance).callFunction(init);
    }

    @ThreadConfined(value="UI")
    public void recreateReactContextInBackground() {
        Assertions.assertCondition((boolean)this.mHasStartedCreatingInitialContext, (String)"recreateReactContextInBackground should only be called after the initial createReactContextInBackground call.");
        this.recreateReactContextInBackgroundInner();
    }

    @ThreadConfined(value="UI")
    private void recreateReactContextInBackgroundInner() {
        Log.d((String)"ReactNative", (String)"ReactInstanceManager.recreateReactContextInBackgroundInner()");
        UiThreadUtil.assertOnUiThread();
        if (this.mUseDeveloperSupport && this.mJSMainModulePath != null && !Systrace.isTracing(0L)) {
            final DeveloperSettings devSettings = this.mDevSupportManager.getDevSettings();
            if (this.mDevSupportManager.hasUpToDateJSBundleInCache() && !devSettings.isRemoteJSDebugEnabled()) {
                this.onJSBundleLoadedFromServer();
            } else if (this.mBundleLoader == null) {
                this.mDevSupportManager.handleReloadJS();
            } else {
                this.mDevSupportManager.isPackagerRunning(new PackagerStatusCallback(){

                    @Override
                    public void onPackagerStatusFetched(final boolean packagerIsRunning) {
                        UiThreadUtil.runOnUiThread(new Runnable(){

                            @Override
                            public void run() {
                                if (packagerIsRunning) {
                                    ReactInstanceManager.this.mDevSupportManager.handleReloadJS();
                                } else {
                                    devSettings.setRemoteJSDebugEnabled(false);
                                    ReactInstanceManager.this.recreateReactContextInBackgroundFromBundleLoader();
                                }
                            }
                        });
                    }
                });
            }
            return;
        }
        this.recreateReactContextInBackgroundFromBundleLoader();
    }

    @ThreadConfined(value="UI")
    private void recreateReactContextInBackgroundFromBundleLoader() {
        Log.d((String)"ReactNative", (String)"ReactInstanceManager.recreateReactContextInBackgroundFromBundleLoader()");
        this.recreateReactContextInBackground(this.mJavaScriptExecutorFactory, this.mBundleLoader);
    }

    public boolean hasStartedCreatingInitialContext() {
        return this.mHasStartedCreatingInitialContext;
    }

    public void onBackPressed() {
        UiThreadUtil.assertOnUiThread();
        ReactContext reactContext = this.mCurrentReactContext;
        if (this.mCurrentReactContext == null) {
            FLog.w((String)"ReactNative", (String)"Instance detached from instance manager");
            this.invokeDefaultOnBackPressed();
        } else {
            DeviceEventManagerModule deviceEventManagerModule = ((ReactContext)((Object)Assertions.assertNotNull((Object)((Object)reactContext)))).getNativeModule(DeviceEventManagerModule.class);
            deviceEventManagerModule.emitHardwareBackPressed();
        }
    }

    private void invokeDefaultOnBackPressed() {
        UiThreadUtil.assertOnUiThread();
        if (this.mDefaultBackButtonImpl != null) {
            this.mDefaultBackButtonImpl.invokeDefaultOnBackPressed();
        }
    }

    @ThreadConfined(value="UI")
    public void onNewIntent(Intent intent) {
        UiThreadUtil.assertOnUiThread();
        if (this.mCurrentReactContext == null) {
            FLog.w((String)"ReactNative", (String)"Instance detached from instance manager");
        } else {
            String action = intent.getAction();
            Uri uri = intent.getData();
            if ("android.intent.action.VIEW".equals(action) && uri != null) {
                DeviceEventManagerModule deviceEventManagerModule = ((ReactContext)((Object)Assertions.assertNotNull((Object)((Object)this.mCurrentReactContext)))).getNativeModule(DeviceEventManagerModule.class);
                deviceEventManagerModule.emitNewIntentReceived(uri);
            }
            this.mCurrentReactContext.onNewIntent(this.mCurrentActivity, intent);
        }
    }

    private void toggleElementInspector() {
        if (this.mCurrentReactContext != null) {
            this.mCurrentReactContext.getJSModule(DeviceEventManagerModule.RCTDeviceEventEmitter.class).emit("toggleElementInspector", null);
        }
    }

    @ThreadConfined(value="UI")
    public void onHostPause() {
        UiThreadUtil.assertOnUiThread();
        this.mDefaultBackButtonImpl = null;
        if (this.mUseDeveloperSupport) {
            this.mDevSupportManager.setDevSupportEnabled(false);
        }
        this.moveToBeforeResumeLifecycleState();
    }

    @ThreadConfined(value="UI")
    public void onHostPause(Activity activity) {
        Assertions.assertNotNull((Object)this.mCurrentActivity);
        Assertions.assertCondition((activity == this.mCurrentActivity ? 1 : 0) != 0, (String)("Pausing an activity that is not the current activity, this is incorrect! Current activity: " + this.mCurrentActivity.getClass().getSimpleName() + " " + "Paused activity: " + activity.getClass().getSimpleName()));
        this.onHostPause();
    }

    @ThreadConfined(value="UI")
    public void onHostResume(Activity activity, DefaultHardwareBackBtnHandler defaultBackButtonImpl) {
        UiThreadUtil.assertOnUiThread();
        this.mDefaultBackButtonImpl = defaultBackButtonImpl;
        if (this.mUseDeveloperSupport) {
            this.mDevSupportManager.setDevSupportEnabled(true);
        }
        this.mCurrentActivity = activity;
        this.moveToResumedLifecycleState(false);
    }

    @ThreadConfined(value="UI")
    public void onHostDestroy() {
        UiThreadUtil.assertOnUiThread();
        if (this.mUseDeveloperSupport) {
            this.mDevSupportManager.setDevSupportEnabled(false);
        }
        this.moveToBeforeCreateLifecycleState();
        this.mCurrentActivity = null;
    }

    @ThreadConfined(value="UI")
    public void onHostDestroy(Activity activity) {
        if (activity == this.mCurrentActivity) {
            this.onHostDestroy();
        }
    }

    @ThreadConfined(value="UI")
    public void destroy() {
        UiThreadUtil.assertOnUiThread();
        if (this.mUseDeveloperSupport) {
            this.mDevSupportManager.setDevSupportEnabled(false);
            this.mDevSupportManager.stopInspector();
        }
        this.moveToBeforeCreateLifecycleState();
        if (this.mCreateReactContextThread != null) {
            this.mCreateReactContextThread.interrupt();
            this.mCreateReactContextThread = null;
        }
        this.mMemoryPressureRouter.destroy(this.mApplicationContext);
        if (this.mCurrentReactContext != null) {
            this.mCurrentReactContext.destroy();
            this.mCurrentReactContext = null;
            this.mHasStartedCreatingInitialContext = false;
        }
        this.mCurrentActivity = null;
        ResourceDrawableIdHelper.getInstance().clear();
    }

    private synchronized void moveToResumedLifecycleState(boolean force) {
        if (this.mCurrentReactContext != null && (force || this.mLifecycleState == LifecycleState.BEFORE_RESUME || this.mLifecycleState == LifecycleState.BEFORE_CREATE)) {
            this.mCurrentReactContext.onHostResume(this.mCurrentActivity);
        }
        this.mLifecycleState = LifecycleState.RESUMED;
    }

    private synchronized void moveToBeforeResumeLifecycleState() {
        if (this.mCurrentReactContext != null) {
            if (this.mLifecycleState == LifecycleState.BEFORE_CREATE) {
                this.mCurrentReactContext.onHostResume(this.mCurrentActivity);
                this.mCurrentReactContext.onHostPause();
            } else if (this.mLifecycleState == LifecycleState.RESUMED) {
                this.mCurrentReactContext.onHostPause();
            }
        }
        this.mLifecycleState = LifecycleState.BEFORE_RESUME;
    }

    private synchronized void moveToBeforeCreateLifecycleState() {
        if (this.mCurrentReactContext != null) {
            if (this.mLifecycleState == LifecycleState.RESUMED) {
                this.mCurrentReactContext.onHostPause();
                this.mLifecycleState = LifecycleState.BEFORE_RESUME;
            }
            if (this.mLifecycleState == LifecycleState.BEFORE_RESUME) {
                this.mCurrentReactContext.onHostDestroy();
            }
        }
        this.mLifecycleState = LifecycleState.BEFORE_CREATE;
    }

    private synchronized void moveReactContextToCurrentLifecycleState() {
        if (this.mLifecycleState == LifecycleState.RESUMED) {
            this.moveToResumedLifecycleState(true);
        }
    }

    @ThreadConfined(value="UI")
    public void onActivityResult(Activity activity, int requestCode, int resultCode, Intent data) {
        if (this.mCurrentReactContext != null) {
            this.mCurrentReactContext.onActivityResult(activity, requestCode, resultCode, data);
        }
    }

    @ThreadConfined(value="UI")
    public void showDevOptionsDialog() {
        UiThreadUtil.assertOnUiThread();
        this.mDevSupportManager.showDevOptionsDialog();
    }

    @ThreadConfined(value="UI")
    public void attachRootView(ReactRootView rootView) {
        UiThreadUtil.assertOnUiThread();
        this.mAttachedRootViews.add(rootView);
        rootView.removeAllViews();
        rootView.setId(-1);
        if (this.mCreateReactContextThread == null && this.mCurrentReactContext != null) {
            this.attachRootViewToInstance(rootView, this.mCurrentReactContext.getCatalystInstance());
        }
    }

    @ThreadConfined(value="UI")
    public void detachRootView(ReactRootView rootView) {
        UiThreadUtil.assertOnUiThread();
        if (this.mAttachedRootViews.remove(rootView) && this.mCurrentReactContext != null && this.mCurrentReactContext.hasActiveCatalystInstance()) {
            this.detachViewFromInstance(rootView, this.mCurrentReactContext.getCatalystInstance());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ViewManager> createAllViewManagers(ReactApplicationContext catalystApplicationContext) {
        ReactMarker.logMarker(ReactMarkerConstants.CREATE_VIEW_MANAGERS_START);
        Systrace.beginSection(0L, "createAllViewManagers");
        try {
            ArrayList<ViewManager> allViewManagers = new ArrayList<ViewManager>();
            for (ReactPackage reactPackage : this.mPackages) {
                allViewManagers.addAll(reactPackage.createViewManagers(catalystApplicationContext));
            }
            ArrayList<ViewManager> arrayList = allViewManagers;
            return arrayList;
        }
        finally {
            Systrace.endSection(0L);
            ReactMarker.logMarker(ReactMarkerConstants.CREATE_VIEW_MANAGERS_END);
        }
    }

    public void addReactInstanceEventListener(ReactInstanceEventListener listener) {
        this.mReactInstanceEventListeners.add(listener);
    }

    public void removeReactInstanceEventListener(ReactInstanceEventListener listener) {
        this.mReactInstanceEventListeners.remove(listener);
    }

    @Nullable
    @VisibleForTesting
    public ReactContext getCurrentReactContext() {
        return this.mCurrentReactContext;
    }

    public LifecycleState getLifecycleState() {
        return this.mLifecycleState;
    }

    public int getMinNumShakes() {
        return this.mMinNumShakes;
    }

    @ThreadConfined(value="UI")
    private void onReloadWithJSDebugger(JavaJSExecutor.Factory jsExecutorFactory) {
        Log.d((String)"ReactNative", (String)"ReactInstanceManager.onReloadWithJSDebugger()");
        this.recreateReactContextInBackground(new ProxyJavaScriptExecutor.Factory(jsExecutorFactory), JSBundleLoader.createRemoteDebuggerBundleLoader(this.mDevSupportManager.getJSBundleURLForRemoteDebugging(), this.mDevSupportManager.getSourceUrl()));
    }

    @ThreadConfined(value="UI")
    private void onJSBundleLoadedFromServer() {
        Log.d((String)"ReactNative", (String)"ReactInstanceManager.onJSBundleLoadedFromServer()");
        this.recreateReactContextInBackground(this.mJavaScriptExecutorFactory, JSBundleLoader.createCachedBundleFromNetworkLoader(this.mDevSupportManager.getSourceUrl(), this.mDevSupportManager.getDownloadedJSBundleFile()));
    }

    @ThreadConfined(value="UI")
    private void recreateReactContextInBackground(JavaScriptExecutorFactory jsExecutorFactory, JSBundleLoader jsBundleLoader) {
        Log.d((String)"ReactNative", (String)"ReactInstanceManager.recreateReactContextInBackground()");
        UiThreadUtil.assertOnUiThread();
        ReactContextInitParams initParams = new ReactContextInitParams(jsExecutorFactory, jsBundleLoader);
        if (this.mCreateReactContextThread == null) {
            this.runCreateReactContextOnNewThread(initParams);
        } else {
            this.mPendingReactContextInitParams = initParams;
        }
    }

    @ThreadConfined(value="UI")
    private void runCreateReactContextOnNewThread(final ReactContextInitParams initParams) {
        Log.d((String)"ReactNative", (String)"ReactInstanceManager.runCreateReactContextOnNewThread()");
        UiThreadUtil.assertOnUiThread();
        if (this.mCurrentReactContext != null) {
            this.tearDownReactContext(this.mCurrentReactContext);
            this.mCurrentReactContext = null;
        }
        this.mCreateReactContextThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Process.setThreadPriority((int)-4);
                    final ReactApplicationContext reactApplicationContext = ReactInstanceManager.this.createReactContext(initParams.getJsExecutorFactory().create(), initParams.getJsBundleLoader());
                    ReactInstanceManager.this.mCreateReactContextThread = null;
                    ReactMarker.logMarker(ReactMarkerConstants.PRE_SETUP_REACT_CONTEXT_START);
                    Runnable maybeRecreateReactContextRunnable = new Runnable(){

                        @Override
                        public void run() {
                            if (ReactInstanceManager.this.mPendingReactContextInitParams != null) {
                                ReactInstanceManager.this.runCreateReactContextOnNewThread(ReactInstanceManager.this.mPendingReactContextInitParams);
                                ReactInstanceManager.this.mPendingReactContextInitParams = null;
                            }
                        }
                    };
                    Runnable setupReactContextRunnable = new Runnable(){

                        @Override
                        public void run() {
                            try {
                                ReactInstanceManager.this.setupReactContext(reactApplicationContext);
                            }
                            catch (Exception e) {
                                ReactInstanceManager.this.mDevSupportManager.handleException(e);
                            }
                        }
                    };
                    reactApplicationContext.runOnNativeModulesQueueThread(setupReactContextRunnable);
                    UiThreadUtil.runOnUiThread(maybeRecreateReactContextRunnable);
                }
                catch (Exception e) {
                    ReactInstanceManager.this.mDevSupportManager.handleException(e);
                }
            }
        });
        this.mCreateReactContextThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupReactContext(final ReactApplicationContext reactContext) {
        Log.d((String)"ReactNative", (String)"ReactInstanceManager.setupReactContext()");
        ReactMarker.logMarker(ReactMarkerConstants.PRE_SETUP_REACT_CONTEXT_END);
        ReactMarker.logMarker(ReactMarkerConstants.SETUP_REACT_CONTEXT_START);
        Systrace.beginSection(0L, "setupReactContext");
        this.mCurrentReactContext = (ReactContext)((Object)Assertions.assertNotNull((Object)((Object)reactContext)));
        CatalystInstance catalystInstance = (CatalystInstance)Assertions.assertNotNull((Object)reactContext.getCatalystInstance());
        catalystInstance.initialize();
        this.mDevSupportManager.onNewReactContextCreated(reactContext);
        this.mMemoryPressureRouter.addMemoryPressureListener(catalystInstance);
        this.moveReactContextToCurrentLifecycleState();
        ReactMarker.logMarker(ReactMarkerConstants.ATTACH_MEASURED_ROOT_VIEWS_START);
        List<ReactRootView> list = this.mAttachedRootViews;
        synchronized (list) {
            for (ReactRootView rootView : this.mAttachedRootViews) {
                this.attachRootViewToInstance(rootView, catalystInstance);
            }
        }
        ReactMarker.logMarker(ReactMarkerConstants.ATTACH_MEASURED_ROOT_VIEWS_END);
        ReactInstanceEventListener[] listeners = new ReactInstanceEventListener[this.mReactInstanceEventListeners.size()];
        final ReactInstanceEventListener[] finalListeners = this.mReactInstanceEventListeners.toArray(listeners);
        UiThreadUtil.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                for (ReactInstanceEventListener listener : finalListeners) {
                    listener.onReactContextInitialized(reactContext);
                }
            }
        });
        Systrace.endSection(0L);
        ReactMarker.logMarker(ReactMarkerConstants.SETUP_REACT_CONTEXT_END);
        this.mCurrentReactContext.runOnJSQueueThread(new Runnable(){

            @Override
            public void run() {
                Process.setThreadPriority((int)0);
            }
        });
        this.mCurrentReactContext.runOnNativeModulesQueueThread(new Runnable(){

            @Override
            public void run() {
                Process.setThreadPriority((int)0);
            }
        });
        if (this.mUseSeparateUIBackgroundThread) {
            this.mCurrentReactContext.runOnUiBackgroundQueueThread(new Runnable(){

                @Override
                public void run() {
                    Process.setThreadPriority((int)0);
                }
            });
        }
    }

    private void attachRootViewToInstance(final ReactRootView rootView, CatalystInstance catalystInstance) {
        Log.d((String)"ReactNative", (String)"ReactInstanceManager.attachRootViewToInstance()");
        Systrace.beginSection(0L, "attachRootViewToInstance");
        UIManagerModule uiManagerModule = catalystInstance.getNativeModule(UIManagerModule.class);
        final int rootTag = uiManagerModule.addRootView(rootView);
        rootView.setRootViewTag(rootTag);
        rootView.runApplication();
        Systrace.beginAsyncSection(0L, "pre_rootView.onAttachedToReactInstance", rootTag);
        UiThreadUtil.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                Systrace.endAsyncSection(0L, "pre_rootView.onAttachedToReactInstance", rootTag);
                rootView.onAttachedToReactInstance();
            }
        });
        Systrace.endSection(0L);
    }

    private void detachViewFromInstance(ReactRootView rootView, CatalystInstance catalystInstance) {
        Log.d((String)"ReactNative", (String)"ReactInstanceManager.detachViewFromInstance()");
        UiThreadUtil.assertOnUiThread();
        catalystInstance.getJSModule(AppRegistry.class).unmountApplicationComponentAtRootTag(rootView.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tearDownReactContext(ReactContext reactContext) {
        Log.d((String)"ReactNative", (String)"ReactInstanceManager.tearDownReactContext()");
        UiThreadUtil.assertOnUiThread();
        if (this.mLifecycleState == LifecycleState.RESUMED) {
            reactContext.onHostPause();
        }
        List<ReactRootView> list = this.mAttachedRootViews;
        synchronized (list) {
            for (ReactRootView rootView : this.mAttachedRootViews) {
                rootView.removeAllViews();
                rootView.setId(-1);
            }
        }
        reactContext.destroy();
        this.mDevSupportManager.onReactInstanceDestroyed(reactContext);
        this.mMemoryPressureRouter.removeMemoryPressureListener(reactContext.getCatalystInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReactApplicationContext createReactContext(JavaScriptExecutor jsExecutor, JSBundleLoader jsBundleLoader) {
        CatalystInstanceImpl catalystInstance;
        Log.d((String)"ReactNative", (String)"ReactInstanceManager.createReactContext()");
        ReactMarker.logMarker(ReactMarkerConstants.CREATE_REACT_CONTEXT_START);
        ReactApplicationContext reactContext = new ReactApplicationContext(this.mApplicationContext);
        if (this.mUseDeveloperSupport) {
            reactContext.setNativeModuleCallExceptionHandler(this.mDevSupportManager);
        }
        NativeModuleRegistry nativeModuleRegistry = this.processPackages(reactContext, this.mPackages, false);
        NativeModuleCallExceptionHandler exceptionHandler = this.mNativeModuleCallExceptionHandler != null ? this.mNativeModuleCallExceptionHandler : this.mDevSupportManager;
        CatalystInstanceImpl.Builder catalystInstanceBuilder = new CatalystInstanceImpl.Builder().setReactQueueConfigurationSpec(this.mUseSeparateUIBackgroundThread ? ReactQueueConfigurationSpec.createWithSeparateUIBackgroundThread() : ReactQueueConfigurationSpec.createDefault()).setJSExecutor(jsExecutor).setRegistry(nativeModuleRegistry).setJSBundleLoader(jsBundleLoader).setNativeModuleCallExceptionHandler(exceptionHandler);
        ReactMarker.logMarker(ReactMarkerConstants.CREATE_CATALYST_INSTANCE_START);
        Systrace.beginSection(0L, "createCatalystInstance");
        try {
            catalystInstance = catalystInstanceBuilder.build();
        }
        finally {
            Systrace.endSection(0L);
            ReactMarker.logMarker(ReactMarkerConstants.CREATE_CATALYST_INSTANCE_END);
        }
        if (this.mBridgeIdleDebugListener != null) {
            catalystInstance.addBridgeIdleDebugListener(this.mBridgeIdleDebugListener);
        }
        if (Systrace.isTracing(0L)) {
            catalystInstance.setGlobalVariable("__RCTProfileIsProfiling", "true");
        }
        ReactMarker.logMarker(ReactMarkerConstants.PRE_RUN_JS_BUNDLE_START);
        catalystInstance.runJSBundle();
        if (!this.mInitFunctions.isEmpty()) {
            for (CatalystInstanceImpl.PendingJSCall function : this.mInitFunctions) {
                catalystInstance.callFunction(function);
            }
        }
        reactContext.initializeWithInstance(catalystInstance);
        return reactContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NativeModuleRegistry processPackages(ReactApplicationContext reactContext, List<ReactPackage> packages, boolean checkAndUpdatePackageMembership) {
        NativeModuleRegistry nativeModuleRegistry;
        NativeModuleRegistryBuilder nativeModuleRegistryBuilder = new NativeModuleRegistryBuilder(reactContext, this, this.mLazyNativeModulesEnabled);
        ReactMarker.logMarker(ReactMarkerConstants.PROCESS_PACKAGES_START);
        for (ReactPackage reactPackage : packages) {
            if (checkAndUpdatePackageMembership && this.mPackages.contains(reactPackage)) continue;
            Systrace.beginSection(0L, "createAndProcessCustomReactPackage");
            try {
                if (checkAndUpdatePackageMembership) {
                    this.mPackages.add(reactPackage);
                }
                this.processPackage(reactPackage, nativeModuleRegistryBuilder);
            }
            finally {
                Systrace.endSection(0L);
            }
        }
        ReactMarker.logMarker(ReactMarkerConstants.PROCESS_PACKAGES_END);
        ReactMarker.logMarker(ReactMarkerConstants.BUILD_NATIVE_MODULE_REGISTRY_START);
        Systrace.beginSection(0L, "buildNativeModuleRegistry");
        try {
            nativeModuleRegistry = nativeModuleRegistryBuilder.build();
        }
        finally {
            Systrace.endSection(0L);
            ReactMarker.logMarker(ReactMarkerConstants.BUILD_NATIVE_MODULE_REGISTRY_END);
        }
        return nativeModuleRegistry;
    }

    private void processPackage(ReactPackage reactPackage, NativeModuleRegistryBuilder nativeModuleRegistryBuilder) {
        SystraceMessage.beginSection(0L, "processPackage").arg("className", reactPackage.getClass().getSimpleName()).flush();
        if (reactPackage instanceof ReactPackageLogger) {
            ((ReactPackageLogger)((Object)reactPackage)).startProcessPackage();
        }
        nativeModuleRegistryBuilder.processPackage(reactPackage);
        if (reactPackage instanceof ReactPackageLogger) {
            ((ReactPackageLogger)((Object)reactPackage)).endProcessPackage();
        }
        SystraceMessage.endSection(0L).flush();
    }

    private class ReactContextInitParams {
        private final JavaScriptExecutorFactory mJsExecutorFactory;
        private final JSBundleLoader mJsBundleLoader;

        public ReactContextInitParams(JavaScriptExecutorFactory jsExecutorFactory, JSBundleLoader jsBundleLoader) {
            this.mJsExecutorFactory = (JavaScriptExecutorFactory)Assertions.assertNotNull((Object)jsExecutorFactory);
            this.mJsBundleLoader = (JSBundleLoader)Assertions.assertNotNull((Object)jsBundleLoader);
        }

        public JavaScriptExecutorFactory getJsExecutorFactory() {
            return this.mJsExecutorFactory;
        }

        public JSBundleLoader getJsBundleLoader() {
            return this.mJsBundleLoader;
        }
    }

    public static interface ReactInstanceEventListener {
        public void onReactContextInitialized(ReactContext var1);
    }
}

