/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.flat;

import android.text.Layout;
import android.text.Spanned;
import com.facebook.react.flat.NodeRegion;
import com.facebook.react.flat.RCTRawText;
import javax.annotation.Nullable;

final class TextNodeRegion
extends NodeRegion {
    @Nullable
    private Layout mLayout;

    TextNodeRegion(float left, float top, float right, float bottom, int tag, boolean isVirtual, @Nullable Layout layout2) {
        super(left, top, right, bottom, tag, isVirtual);
        this.mLayout = layout2;
    }

    public void setLayout(Layout layout2) {
        this.mLayout = layout2;
    }

    @Nullable
    Layout getLayout() {
        return this.mLayout;
    }

    @Override
    int getReactTag(float touchX, float touchY) {
        int y;
        CharSequence text;
        if (this.mLayout != null && (text = this.mLayout.getText()) instanceof Spanned && (y = Math.round(touchY - this.getTop())) >= this.mLayout.getLineTop(0) && y < this.mLayout.getLineBottom(this.mLayout.getLineCount() - 1)) {
            int off;
            Spanned spanned;
            RCTRawText[] link;
            float x = Math.round(touchX - this.getLeft());
            int line = this.mLayout.getLineForVertical(y);
            if (this.mLayout.getLineLeft(line) <= x && x <= this.mLayout.getLineRight(line) && (link = (RCTRawText[])(spanned = (Spanned)text).getSpans(off = this.mLayout.getOffsetForHorizontal(line, x), off, RCTRawText.class)).length != 0) {
                return link[0].getReactTag();
            }
        }
        return super.getReactTag(touchX, touchY);
    }

    @Override
    boolean matchesTag(int tag) {
        if (super.matchesTag(tag)) {
            return true;
        }
        if (this.mLayout != null) {
            RCTRawText[] spans;
            Spanned text = (Spanned)this.mLayout.getText();
            for (RCTRawText span : spans = (RCTRawText[])text.getSpans(0, text.length(), RCTRawText.class)) {
                if (span.getReactTag() != tag) continue;
                return true;
            }
        }
        return false;
    }
}

