/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import android.graphics.Bitmap;
import android.net.Uri;
import com.facebook.common.internal.ImmutableMap;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.references.CloseableReference;
import com.facebook.common.util.UriUtil;
import com.facebook.imagepipeline.common.ImageDecodeOptions;
import com.facebook.imagepipeline.decoder.ImageDecoder;
import com.facebook.imagepipeline.decoder.ProgressiveJpegConfig;
import com.facebook.imagepipeline.decoder.ProgressiveJpegParser;
import com.facebook.imagepipeline.image.CloseableImage;
import com.facebook.imagepipeline.image.CloseableStaticBitmap;
import com.facebook.imagepipeline.image.EncodedImage;
import com.facebook.imagepipeline.image.ImmutableQualityInfo;
import com.facebook.imagepipeline.image.QualityInfo;
import com.facebook.imagepipeline.memory.ByteArrayPool;
import com.facebook.imagepipeline.producers.BaseProducerContextCallbacks;
import com.facebook.imagepipeline.producers.Consumer;
import com.facebook.imagepipeline.producers.DelegatingConsumer;
import com.facebook.imagepipeline.producers.DownsampleUtil;
import com.facebook.imagepipeline.producers.JobScheduler;
import com.facebook.imagepipeline.producers.Producer;
import com.facebook.imagepipeline.producers.ProducerContext;
import com.facebook.imagepipeline.producers.ProducerListener;
import com.facebook.imagepipeline.request.ImageRequest;
import java.io.Closeable;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

public class DecodeProducer
implements Producer<CloseableReference<CloseableImage>> {
    public static final String PRODUCER_NAME = "DecodeProducer";
    private static final String BITMAP_SIZE_KEY = "bitmapSize";
    private static final String HAS_GOOD_QUALITY_KEY = "hasGoodQuality";
    private static final String IS_FINAL_KEY = "isFinal";
    private final ByteArrayPool mByteArrayPool;
    private final Executor mExecutor;
    private final ImageDecoder mImageDecoder;
    private final ProgressiveJpegConfig mProgressiveJpegConfig;
    private final Producer<EncodedImage> mInputProducer;
    private final boolean mDownsampleEnabled;
    private final boolean mDownsampleEnabledForNetwork;

    public DecodeProducer(ByteArrayPool byteArrayPool, Executor executor, ImageDecoder imageDecoder, ProgressiveJpegConfig progressiveJpegConfig, boolean downsampleEnabled, boolean downsampleEnabledForNetwork, Producer<EncodedImage> inputProducer) {
        this.mByteArrayPool = (ByteArrayPool)Preconditions.checkNotNull((Object)byteArrayPool);
        this.mExecutor = (Executor)Preconditions.checkNotNull((Object)executor);
        this.mImageDecoder = (ImageDecoder)Preconditions.checkNotNull((Object)imageDecoder);
        this.mProgressiveJpegConfig = (ProgressiveJpegConfig)Preconditions.checkNotNull((Object)progressiveJpegConfig);
        this.mDownsampleEnabled = downsampleEnabled;
        this.mDownsampleEnabledForNetwork = downsampleEnabledForNetwork;
        this.mInputProducer = (Producer)Preconditions.checkNotNull(inputProducer);
    }

    @Override
    public void produceResults(Consumer<CloseableReference<CloseableImage>> consumer, ProducerContext producerContext) {
        ProgressiveDecoder progressiveDecoder;
        ImageRequest imageRequest = producerContext.getImageRequest();
        if (!UriUtil.isNetworkUri((Uri)imageRequest.getSourceUri())) {
            progressiveDecoder = new LocalImagesProgressiveDecoder(consumer, producerContext);
        } else {
            ProgressiveJpegParser jpegParser = new ProgressiveJpegParser(this.mByteArrayPool);
            progressiveDecoder = new NetworkImagesProgressiveDecoder(consumer, producerContext, jpegParser, this.mProgressiveJpegConfig);
        }
        this.mInputProducer.produceResults(progressiveDecoder, producerContext);
    }

    private class NetworkImagesProgressiveDecoder
    extends ProgressiveDecoder {
        private final ProgressiveJpegParser mProgressiveJpegParser;
        private final ProgressiveJpegConfig mProgressiveJpegConfig;
        private int mLastScheduledScanNumber;

        public NetworkImagesProgressiveDecoder(Consumer<CloseableReference<CloseableImage>> consumer, ProducerContext producerContext, ProgressiveJpegParser progressiveJpegParser, ProgressiveJpegConfig progressiveJpegConfig) {
            super(consumer, producerContext);
            this.mProgressiveJpegParser = (ProgressiveJpegParser)Preconditions.checkNotNull((Object)progressiveJpegParser);
            this.mProgressiveJpegConfig = (ProgressiveJpegConfig)Preconditions.checkNotNull((Object)progressiveJpegConfig);
            this.mLastScheduledScanNumber = 0;
        }

        @Override
        protected synchronized boolean updateDecodeJob(EncodedImage encodedImage, boolean isLast) {
            boolean ret = super.updateDecodeJob(encodedImage, isLast);
            if (!isLast && EncodedImage.isValid(encodedImage)) {
                if (!this.mProgressiveJpegParser.parseMoreData(encodedImage)) {
                    return false;
                }
                int scanNum = this.mProgressiveJpegParser.getBestScanNumber();
                if (scanNum <= this.mLastScheduledScanNumber || scanNum < this.mProgressiveJpegConfig.getNextScanNumberToDecode(this.mLastScheduledScanNumber)) {
                    return false;
                }
                this.mLastScheduledScanNumber = scanNum;
            }
            return ret;
        }

        @Override
        protected int getIntermediateImageEndOffset(EncodedImage encodedImage) {
            return this.mProgressiveJpegParser.getBestScanEndOffset();
        }

        @Override
        protected QualityInfo getQualityInfo() {
            return this.mProgressiveJpegConfig.getQualityInfo(this.mProgressiveJpegParser.getBestScanNumber());
        }
    }

    private class LocalImagesProgressiveDecoder
    extends ProgressiveDecoder {
        public LocalImagesProgressiveDecoder(Consumer<CloseableReference<CloseableImage>> consumer, ProducerContext producerContext) {
            super(consumer, producerContext);
        }

        @Override
        protected synchronized boolean updateDecodeJob(EncodedImage encodedImage, boolean isLast) {
            if (!isLast) {
                return false;
            }
            return super.updateDecodeJob(encodedImage, isLast);
        }

        @Override
        protected int getIntermediateImageEndOffset(EncodedImage encodedImage) {
            return encodedImage.getSize();
        }

        @Override
        protected QualityInfo getQualityInfo() {
            return ImmutableQualityInfo.of(0, false, false);
        }
    }

    private abstract class ProgressiveDecoder
    extends DelegatingConsumer<EncodedImage, CloseableReference<CloseableImage>> {
        private final ProducerContext mProducerContext;
        private final ProducerListener mProducerListener;
        private final ImageDecodeOptions mImageDecodeOptions;
        @GuardedBy(value="this")
        private boolean mIsFinished;
        private final JobScheduler mJobScheduler;

        public ProgressiveDecoder(Consumer<CloseableReference<CloseableImage>> consumer, final ProducerContext producerContext) {
            super(consumer);
            this.mProducerContext = producerContext;
            this.mProducerListener = producerContext.getListener();
            this.mImageDecodeOptions = producerContext.getImageRequest().getImageDecodeOptions();
            this.mIsFinished = false;
            JobScheduler.JobRunnable job = new JobScheduler.JobRunnable(){

                @Override
                public void run(EncodedImage encodedImage, boolean isLast) {
                    if (encodedImage != null) {
                        if (DecodeProducer.this.mDownsampleEnabled) {
                            ImageRequest request = producerContext.getImageRequest();
                            if (DecodeProducer.this.mDownsampleEnabledForNetwork || !UriUtil.isNetworkUri((Uri)request.getSourceUri())) {
                                encodedImage.setSampleSize(DownsampleUtil.determineSampleSize(request, encodedImage));
                            }
                        }
                        ProgressiveDecoder.this.doDecode(encodedImage, isLast);
                    }
                }
            };
            this.mJobScheduler = new JobScheduler(DecodeProducer.this.mExecutor, job, this.mImageDecodeOptions.minDecodeIntervalMs);
            this.mProducerContext.addCallbacks(new BaseProducerContextCallbacks(){

                @Override
                public void onIsIntermediateResultExpectedChanged() {
                    if (ProgressiveDecoder.this.mProducerContext.isIntermediateResultExpected()) {
                        ProgressiveDecoder.this.mJobScheduler.scheduleJob();
                    }
                }
            });
        }

        @Override
        public void onNewResultImpl(EncodedImage newResult, boolean isLast) {
            if (isLast && !EncodedImage.isValid(newResult)) {
                this.handleError(new NullPointerException("Encoded image is not valid."));
                return;
            }
            if (!this.updateDecodeJob(newResult, isLast)) {
                return;
            }
            if (isLast || this.mProducerContext.isIntermediateResultExpected()) {
                this.mJobScheduler.scheduleJob();
            }
        }

        @Override
        public void onFailureImpl(Throwable t) {
            this.handleError(t);
        }

        @Override
        public void onCancellationImpl() {
            this.handleCancellation();
        }

        protected boolean updateDecodeJob(EncodedImage ref, boolean isLast) {
            return this.mJobScheduler.updateJob(ref, isLast);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doDecode(EncodedImage encodedImage, boolean isLast) {
            if (this.isFinished() || !EncodedImage.isValid(encodedImage)) {
                return;
            }
            try {
                long queueTime = this.mJobScheduler.getQueuedTime();
                int length = isLast ? encodedImage.getSize() : this.getIntermediateImageEndOffset(encodedImage);
                QualityInfo quality = isLast ? ImmutableQualityInfo.FULL_QUALITY : this.getQualityInfo();
                this.mProducerListener.onProducerStart(this.mProducerContext.getId(), DecodeProducer.PRODUCER_NAME);
                CloseableImage image = null;
                try {
                    image = DecodeProducer.this.mImageDecoder.decodeImage(encodedImage, length, quality, this.mImageDecodeOptions);
                }
                catch (Exception e) {
                    Map<String, String> extraMap = this.getExtraMap(image, queueTime, quality, isLast);
                    this.mProducerListener.onProducerFinishWithFailure(this.mProducerContext.getId(), DecodeProducer.PRODUCER_NAME, e, extraMap);
                    this.handleError(e);
                    EncodedImage.closeSafely(encodedImage);
                    return;
                }
                Map<String, String> extraMap = this.getExtraMap(image, queueTime, quality, isLast);
                this.mProducerListener.onProducerFinishWithSuccess(this.mProducerContext.getId(), DecodeProducer.PRODUCER_NAME, extraMap);
                this.handleResult(image, isLast);
            }
            finally {
                EncodedImage.closeSafely(encodedImage);
            }
        }

        private Map<String, String> getExtraMap(@Nullable CloseableImage image, long queueTime, QualityInfo quality, boolean isFinal) {
            if (!this.mProducerListener.requiresExtraMap(this.mProducerContext.getId())) {
                return null;
            }
            String queueStr = String.valueOf(queueTime);
            String qualityStr = String.valueOf(quality.isOfGoodEnoughQuality());
            String finalStr = String.valueOf(isFinal);
            if (image instanceof CloseableStaticBitmap) {
                Bitmap bitmap = ((CloseableStaticBitmap)image).getUnderlyingBitmap();
                String sizeStr = bitmap.getWidth() + "x" + bitmap.getHeight();
                return ImmutableMap.of((Object)DecodeProducer.BITMAP_SIZE_KEY, (Object)sizeStr, (Object)"queueTime", (Object)queueStr, (Object)DecodeProducer.HAS_GOOD_QUALITY_KEY, (Object)qualityStr, (Object)DecodeProducer.IS_FINAL_KEY, (Object)finalStr);
            }
            return ImmutableMap.of((Object)"queueTime", (Object)queueStr, (Object)DecodeProducer.HAS_GOOD_QUALITY_KEY, (Object)qualityStr, (Object)DecodeProducer.IS_FINAL_KEY, (Object)finalStr);
        }

        private synchronized boolean isFinished() {
            return this.mIsFinished;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void maybeFinish(boolean shouldFinish) {
            ProgressiveDecoder progressiveDecoder = this;
            synchronized (progressiveDecoder) {
                if (!shouldFinish || this.mIsFinished) {
                    return;
                }
                this.mIsFinished = true;
            }
            this.mJobScheduler.clearJob();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleResult(CloseableImage decodedImage, boolean isFinal) {
            CloseableReference decodedImageRef = CloseableReference.of((Closeable)decodedImage);
            try {
                this.maybeFinish(isFinal);
                this.getConsumer().onNewResult(decodedImageRef, isFinal);
            }
            finally {
                CloseableReference.closeSafely((CloseableReference)decodedImageRef);
            }
        }

        private void handleError(Throwable t) {
            this.maybeFinish(true);
            this.getConsumer().onFailure(t);
        }

        private void handleCancellation() {
            this.maybeFinish(true);
            this.getConsumer().onCancellation();
        }

        protected abstract int getIntermediateImageEndOffset(EncodedImage var1);

        protected abstract QualityInfo getQualityInfo();
    }
}

