/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.JSCConfig;
import com.facebook.react.ReactInstanceManager;
import com.facebook.react.ReactPackage;
import com.facebook.react.bridge.JSBundleLoader;
import com.facebook.react.bridge.NativeModuleCallExceptionHandler;
import com.facebook.react.bridge.NotThreadSafeBridgeIdleDebugListener;
import com.facebook.react.common.LifecycleState;
import com.facebook.react.devsupport.RedBoxHandler;
import com.facebook.react.devsupport.interfaces.DevBundleDownloadListener;
import com.facebook.react.modules.core.DefaultHardwareBackBtnHandler;
import com.facebook.react.uimanager.UIImplementationProvider;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class ReactInstanceManagerBuilder {
    protected final List<ReactPackage> mPackages = new ArrayList<ReactPackage>();
    @Nullable
    protected String mJSBundleAssetUrl;
    @Nullable
    protected JSBundleLoader mJSBundleLoader;
    @Nullable
    protected String mJSMainModuleName;
    @Nullable
    protected NotThreadSafeBridgeIdleDebugListener mBridgeIdleDebugListener;
    @Nullable
    protected Application mApplication;
    protected boolean mUseDeveloperSupport;
    @Nullable
    protected LifecycleState mInitialLifecycleState;
    @Nullable
    protected UIImplementationProvider mUIImplementationProvider;
    @Nullable
    protected NativeModuleCallExceptionHandler mNativeModuleCallExceptionHandler;
    protected JSCConfig mJSCConfig = JSCConfig.EMPTY;
    @Nullable
    protected Activity mCurrentActivity;
    @Nullable
    protected DefaultHardwareBackBtnHandler mDefaultHardwareBackBtnHandler;
    @Nullable
    protected RedBoxHandler mRedBoxHandler;
    protected boolean mLazyNativeModulesEnabled;
    protected boolean mLazyViewManagersEnabled;
    @Nullable
    protected DevBundleDownloadListener mDevBundleDownloadListener;
    protected boolean mSetupReactContextInBackground;
    protected boolean mUseSeparateUIBackgroundThread;
    protected int mMinNumShakes = 1;
    protected boolean mEnableSplitPackage;

    ReactInstanceManagerBuilder() {
    }

    public ReactInstanceManagerBuilder setUIImplementationProvider(@Nullable UIImplementationProvider uiImplementationProvider) {
        this.mUIImplementationProvider = uiImplementationProvider;
        return this;
    }

    public ReactInstanceManagerBuilder setBundleAssetName(String bundleAssetName) {
        this.mJSBundleAssetUrl = bundleAssetName == null ? null : "assets://" + bundleAssetName;
        this.mJSBundleLoader = null;
        return this;
    }

    public ReactInstanceManagerBuilder setJSBundleFile(String jsBundleFile) {
        if (jsBundleFile.startsWith("assets://")) {
            this.mJSBundleAssetUrl = jsBundleFile;
            this.mJSBundleLoader = null;
            return this;
        }
        return this.setJSBundleLoader(JSBundleLoader.createFileLoader(jsBundleFile));
    }

    public ReactInstanceManagerBuilder setJSBundleLoader(JSBundleLoader jsBundleLoader) {
        this.mJSBundleLoader = jsBundleLoader;
        this.mJSBundleAssetUrl = null;
        return this;
    }

    public ReactInstanceManagerBuilder setJSMainModuleName(String jsMainModuleName) {
        this.mJSMainModuleName = jsMainModuleName;
        return this;
    }

    public ReactInstanceManagerBuilder addPackage(ReactPackage reactPackage) {
        this.mPackages.add(reactPackage);
        return this;
    }

    public ReactInstanceManagerBuilder setBridgeIdleDebugListener(NotThreadSafeBridgeIdleDebugListener bridgeIdleDebugListener) {
        this.mBridgeIdleDebugListener = bridgeIdleDebugListener;
        return this;
    }

    public ReactInstanceManagerBuilder setApplication(Application application) {
        this.mApplication = application;
        return this;
    }

    public ReactInstanceManagerBuilder setCurrentActivity(Activity activity) {
        this.mCurrentActivity = activity;
        return this;
    }

    public ReactInstanceManagerBuilder setDefaultHardwareBackBtnHandler(DefaultHardwareBackBtnHandler defaultHardwareBackBtnHandler) {
        this.mDefaultHardwareBackBtnHandler = defaultHardwareBackBtnHandler;
        return this;
    }

    public ReactInstanceManagerBuilder setUseDeveloperSupport(boolean useDeveloperSupport) {
        this.mUseDeveloperSupport = useDeveloperSupport;
        return this;
    }

    public ReactInstanceManagerBuilder setInitialLifecycleState(LifecycleState initialLifecycleState) {
        this.mInitialLifecycleState = initialLifecycleState;
        return this;
    }

    public ReactInstanceManagerBuilder setNativeModuleCallExceptionHandler(NativeModuleCallExceptionHandler handler) {
        this.mNativeModuleCallExceptionHandler = handler;
        return this;
    }

    public ReactInstanceManagerBuilder setJSCConfig(JSCConfig jscConfig) {
        this.mJSCConfig = jscConfig;
        return this;
    }

    public ReactInstanceManagerBuilder setRedBoxHandler(@Nullable RedBoxHandler redBoxHandler) {
        this.mRedBoxHandler = redBoxHandler;
        return this;
    }

    public ReactInstanceManagerBuilder setLazyNativeModulesEnabled(boolean lazyNativeModulesEnabled) {
        this.mLazyNativeModulesEnabled = lazyNativeModulesEnabled;
        return this;
    }

    public ReactInstanceManagerBuilder setLazyViewManagersEnabled(boolean lazyViewManagersEnabled) {
        this.mLazyViewManagersEnabled = lazyViewManagersEnabled;
        return this;
    }

    public ReactInstanceManagerBuilder setDevBundleDownloadListener(@Nullable DevBundleDownloadListener listener) {
        this.mDevBundleDownloadListener = listener;
        return this;
    }

    public ReactInstanceManagerBuilder setSetupReactContextInBackgroundEnabled(boolean setupReactContextInBackground) {
        this.mSetupReactContextInBackground = setupReactContextInBackground;
        return this;
    }

    public ReactInstanceManagerBuilder setUseSeparateUIBackgroundThread(boolean useSeparateUIBackgroundThread) {
        this.mUseSeparateUIBackgroundThread = useSeparateUIBackgroundThread;
        return this;
    }

    public ReactInstanceManagerBuilder setMinNumShakes(int minNumShakes) {
        this.mMinNumShakes = minNumShakes;
        return this;
    }

    public ReactInstanceManagerBuilder setEnableSplitPackage(boolean enableSplitPackage) {
        this.mEnableSplitPackage = enableSplitPackage;
        return this;
    }

    public ReactInstanceManager build() {
        Assertions.assertNotNull((Object)this.mApplication, (String)"Application property has not been set with this builder");
        Assertions.assertCondition((this.mUseDeveloperSupport || this.mJSBundleAssetUrl != null || this.mJSBundleLoader != null ? 1 : 0) != 0, (String)"JS Bundle File or Asset URL has to be provided when dev support is disabled");
        Assertions.assertCondition((this.mJSMainModuleName != null || this.mJSBundleAssetUrl != null || this.mJSBundleLoader != null ? 1 : 0) != 0, (String)"Either MainModuleName or JS Bundle File needs to be provided");
        if (this.mUIImplementationProvider == null) {
            this.mUIImplementationProvider = new UIImplementationProvider();
        }
        return new ReactInstanceManager((Context)this.mApplication, this.mCurrentActivity, this.mDefaultHardwareBackBtnHandler, this.mJSBundleLoader == null && this.mJSBundleAssetUrl != null ? JSBundleLoader.createAssetLoader((Context)this.mApplication, this.mJSBundleAssetUrl, false) : this.mJSBundleLoader, this.mJSMainModuleName, this.mPackages, this.mUseDeveloperSupport, this.mBridgeIdleDebugListener, (LifecycleState)((Object)Assertions.assertNotNull((Object)((Object)this.mInitialLifecycleState), (String)"Initial lifecycle state was not set")), this.mUIImplementationProvider, this.mNativeModuleCallExceptionHandler, this.mJSCConfig, this.mRedBoxHandler, this.mLazyNativeModulesEnabled, this.mLazyViewManagersEnabled, this.mDevBundleDownloadListener, this.mSetupReactContextInBackground, this.mUseSeparateUIBackgroundThread, this.mMinNumShakes, this.mEnableSplitPackage);
    }
}

