/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.art;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.SurfaceTexture;
import android.view.Surface;
import android.view.TextureView;
import com.facebook.common.logging.FLog;
import com.facebook.react.uimanager.LayoutShadowNode;
import com.facebook.react.uimanager.ReactShadowNode;
import com.facebook.react.uimanager.UIViewOperationQueue;
import com.facebook.react.views.art.ARTVirtualNode;
import javax.annotation.Nullable;

public class ARTSurfaceViewShadowNode
extends LayoutShadowNode
implements TextureView.SurfaceTextureListener {
    @Nullable
    private Surface mSurface;

    @Override
    public boolean isVirtual() {
        return false;
    }

    @Override
    public boolean isVirtualAnchor() {
        return true;
    }

    @Override
    public void onCollectExtraUpdates(UIViewOperationQueue uiUpdater) {
        super.onCollectExtraUpdates(uiUpdater);
        this.drawOutput();
        uiUpdater.enqueueUpdateExtraData(this.getReactTag(), this);
    }

    private void drawOutput() {
        if (this.mSurface == null || !this.mSurface.isValid()) {
            this.markChildrenUpdatesSeen(this);
            return;
        }
        try {
            Canvas canvas = this.mSurface.lockCanvas(null);
            canvas.drawColor(0, PorterDuff.Mode.CLEAR);
            Paint paint = new Paint();
            for (int i = 0; i < this.getChildCount(); ++i) {
                ARTVirtualNode child = (ARTVirtualNode)this.getChildAt(i);
                child.draw(canvas, paint, 1.0f);
                child.markUpdateSeen();
            }
            if (this.mSurface == null) {
                return;
            }
            this.mSurface.unlockCanvasAndPost(canvas);
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            FLog.e((String)"ReactNative", (String)(e.getClass().getSimpleName() + " in Surface.unlockCanvasAndPost"));
        }
    }

    private void markChildrenUpdatesSeen(ReactShadowNode shadowNode) {
        for (int i = 0; i < shadowNode.getChildCount(); ++i) {
            ReactShadowNode child = shadowNode.getChildAt(i);
            child.markUpdateSeen();
            this.markChildrenUpdatesSeen(child);
        }
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
        this.mSurface = new Surface(surface);
        this.drawOutput();
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
        surface.release();
        this.mSurface = null;
        return true;
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surface) {
    }
}

