/*
 * Decompiled with CFR 0.152.
 */
package com.rnnestedscrollview;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.support.v4.widget.NestedScrollView;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.OverScroller;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.uimanager.MeasureSpecAssertions;
import com.facebook.react.uimanager.ReactClippingViewGroup;
import com.facebook.react.uimanager.ReactClippingViewGroupHelper;
import com.facebook.react.uimanager.events.NativeGestureUtil;
import com.facebook.react.views.scroll.FpsListener;
import com.facebook.react.views.scroll.OnScrollDispatchHelper;
import com.facebook.react.views.scroll.VelocityHelper;
import com.facebook.react.views.view.ReactViewBackgroundDrawable;
import com.rnnestedscrollview.ReactNestedScrollViewHelper;
import java.lang.reflect.Field;
import javax.annotation.Nullable;

public class ReactNestedScrollView
extends NestedScrollView
implements ReactClippingViewGroup,
ViewGroup.OnHierarchyChangeListener,
View.OnLayoutChangeListener {
    private static Field sScrollerField;
    private static boolean sTriedToGetScrollerField;
    private final OnScrollDispatchHelper mOnScrollDispatchHelper = new OnScrollDispatchHelper();
    private final OverScroller mScroller;
    private final VelocityHelper mVelocityHelper = new VelocityHelper();
    @Nullable
    private Rect mClippingRect;
    private boolean mDoneFlinging;
    private boolean mDragging;
    private boolean mFlinging;
    private boolean mRemoveClippedSubviews;
    private boolean mScrollEnabled = true;
    private boolean mSendMomentumEvents;
    @Nullable
    private FpsListener mFpsListener = null;
    @Nullable
    private String mScrollPerfTag;
    @Nullable
    private Drawable mEndBackground;
    private int mEndFillColor = 0;
    private View mContentView;
    @Nullable
    private ReactViewBackgroundDrawable mReactBackgroundDrawable;

    public ReactNestedScrollView(ReactContext context) {
        this(context, null);
    }

    public ReactNestedScrollView(ReactContext context, @Nullable FpsListener fpsListener) {
        super((Context)context);
        this.mFpsListener = fpsListener;
        if (!sTriedToGetScrollerField) {
            sTriedToGetScrollerField = true;
            try {
                sScrollerField = NestedScrollView.class.getDeclaredField("mScroller");
                sScrollerField.setAccessible(true);
            }
            catch (NoSuchFieldException e) {
                Log.w((String)"ReactNative", (String)"Failed to get mScroller field for ScrollView! This app will exhibit the bounce-back scrolling bug :(");
            }
        }
        if (sScrollerField != null) {
            try {
                Object scroller = sScrollerField.get((Object)this);
                if (scroller instanceof OverScroller) {
                    this.mScroller = (OverScroller)scroller;
                }
                Log.w((String)"ReactNative", (String)"Failed to cast mScroller field in ScrollView (probably due to OEM changes to AOSP)! This app will exhibit the bounce-back scrolling bug :(");
                this.mScroller = null;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Failed to get mScroller from ScrollView!", e);
            }
        } else {
            this.mScroller = null;
        }
        this.setOnHierarchyChangeListener(this);
        this.setScrollBarStyle(0x2000000);
    }

    public void setSendMomentumEvents(boolean sendMomentumEvents) {
        this.mSendMomentumEvents = sendMomentumEvents;
    }

    public void setScrollPerfTag(String scrollPerfTag) {
        this.mScrollPerfTag = scrollPerfTag;
    }

    public void setScrollEnabled(boolean scrollEnabled) {
        this.mScrollEnabled = scrollEnabled;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        MeasureSpecAssertions.assertExplicitMeasureSpec((int)widthMeasureSpec, (int)heightMeasureSpec);
        this.setMeasuredDimension(View.MeasureSpec.getSize((int)widthMeasureSpec), View.MeasureSpec.getSize((int)heightMeasureSpec));
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        this.scrollTo(this.getScrollX(), this.getScrollY());
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (this.mRemoveClippedSubviews) {
            this.updateClippingRect();
        }
    }

    protected void onScrollChanged(int x, int y, int oldX, int oldY) {
        super.onScrollChanged(x, y, oldX, oldY);
        if (this.mOnScrollDispatchHelper.onScrollChanged(x, y)) {
            if (this.mRemoveClippedSubviews) {
                this.updateClippingRect();
            }
            if (this.mFlinging) {
                this.mDoneFlinging = false;
            }
            ReactNestedScrollViewHelper.emitScrollEvent((ViewGroup)this, this.mOnScrollDispatchHelper.getXFlingVelocity(), this.mOnScrollDispatchHelper.getYFlingVelocity());
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (!this.mScrollEnabled) {
            return false;
        }
        if (super.onInterceptTouchEvent(ev)) {
            NativeGestureUtil.notifyNativeGestureStarted((View)this, (MotionEvent)ev);
            ReactNestedScrollViewHelper.emitScrollBeginDragEvent((ViewGroup)this);
            this.mDragging = true;
            this.enableFpsListener();
            return true;
        }
        return false;
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (!this.mScrollEnabled) {
            return false;
        }
        this.mVelocityHelper.calculateVelocity(ev);
        int action = ev.getAction() & 0xFF;
        if (action == 1 && this.mDragging) {
            ReactNestedScrollViewHelper.emitScrollEndDragEvent((ViewGroup)this, this.mVelocityHelper.getXVelocity(), this.mVelocityHelper.getYVelocity());
            this.mDragging = false;
            this.disableFpsListener();
        }
        return super.onTouchEvent(ev);
    }

    public void setRemoveClippedSubviews(boolean removeClippedSubviews) {
        if (removeClippedSubviews && this.mClippingRect == null) {
            this.mClippingRect = new Rect();
        }
        this.mRemoveClippedSubviews = removeClippedSubviews;
        this.updateClippingRect();
    }

    public boolean getRemoveClippedSubviews() {
        return this.mRemoveClippedSubviews;
    }

    public void updateClippingRect() {
        if (!this.mRemoveClippedSubviews) {
            return;
        }
        Assertions.assertNotNull((Object)this.mClippingRect);
        ReactClippingViewGroupHelper.calculateClippingRect((View)this, (Rect)this.mClippingRect);
        View contentView = this.getChildAt(0);
        if (contentView instanceof ReactClippingViewGroup) {
            ((ReactClippingViewGroup)contentView).updateClippingRect();
        }
    }

    public void getClippingRect(Rect outClippingRect) {
        outClippingRect.set((Rect)Assertions.assertNotNull((Object)this.mClippingRect));
    }

    public void fling(int velocityY) {
        if (this.mScroller != null) {
            int scrollWindowHeight = this.getHeight() - this.getPaddingBottom() - this.getPaddingTop();
            this.mScroller.fling(this.getScrollX(), this.getScrollY(), 0, velocityY, 0, 0, 0, Integer.MAX_VALUE, 0, scrollWindowHeight / 2);
            this.postInvalidateOnAnimation();
        } else {
            super.fling(velocityY);
        }
        if (this.mSendMomentumEvents || this.isScrollPerfLoggingEnabled()) {
            this.mFlinging = true;
            this.enableFpsListener();
            ReactNestedScrollViewHelper.emitScrollMomentumBeginEvent((ViewGroup)this);
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    if (ReactNestedScrollView.this.mDoneFlinging) {
                        ReactNestedScrollView.this.mFlinging = false;
                        ReactNestedScrollView.this.disableFpsListener();
                        ReactNestedScrollViewHelper.emitScrollMomentumEndEvent((ViewGroup)ReactNestedScrollView.this);
                    } else {
                        ReactNestedScrollView.this.mDoneFlinging = true;
                        ReactNestedScrollView.this.postOnAnimationDelayed(this, 20L);
                    }
                }
            };
            this.postOnAnimationDelayed(r, 20L);
        }
    }

    private void enableFpsListener() {
        if (this.isScrollPerfLoggingEnabled()) {
            Assertions.assertNotNull((Object)this.mFpsListener);
            Assertions.assertNotNull((Object)this.mScrollPerfTag);
            this.mFpsListener.enable(this.mScrollPerfTag);
        }
    }

    private void disableFpsListener() {
        if (this.isScrollPerfLoggingEnabled()) {
            Assertions.assertNotNull((Object)this.mFpsListener);
            Assertions.assertNotNull((Object)this.mScrollPerfTag);
            this.mFpsListener.disable(this.mScrollPerfTag);
        }
    }

    private boolean isScrollPerfLoggingEnabled() {
        return this.mFpsListener != null && this.mScrollPerfTag != null && !this.mScrollPerfTag.isEmpty();
    }

    private int getMaxScrollY() {
        int contentHeight = this.mContentView.getHeight();
        int viewportHeight = this.getHeight() - this.getPaddingBottom() - this.getPaddingTop();
        return Math.max(0, contentHeight - viewportHeight);
    }

    public void draw(Canvas canvas) {
        if (this.mEndFillColor != 0) {
            View content = this.getChildAt(0);
            if (this.mEndBackground != null && content != null && content.getBottom() < this.getHeight()) {
                this.mEndBackground.setBounds(0, content.getBottom(), this.getWidth(), this.getHeight());
                this.mEndBackground.draw(canvas);
            }
        }
        super.draw(canvas);
    }

    public void setEndFillColor(int color) {
        if (color != this.mEndFillColor) {
            this.mEndFillColor = color;
            this.mEndBackground = new ColorDrawable(this.mEndFillColor);
        }
    }

    protected void onOverScrolled(int scrollX, int scrollY, boolean clampedX, boolean clampedY) {
        int scrollRange;
        if (this.mScroller != null && !this.mScroller.isFinished() && this.mScroller.getCurrY() != this.mScroller.getFinalY() && scrollY >= (scrollRange = this.getMaxScrollY())) {
            this.mScroller.abortAnimation();
            scrollY = scrollRange;
        }
        super.onOverScrolled(scrollX, scrollY, clampedX, clampedY);
    }

    public void onChildViewAdded(View parent, View child) {
        this.mContentView = child;
        this.mContentView.addOnLayoutChangeListener((View.OnLayoutChangeListener)this);
    }

    public void onChildViewRemoved(View parent, View child) {
        this.mContentView.removeOnLayoutChangeListener((View.OnLayoutChangeListener)this);
        this.mContentView = null;
    }

    public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
        int maxScrollY;
        if (this.mContentView == null) {
            return;
        }
        int currentScrollY = this.getScrollY();
        if (currentScrollY > (maxScrollY = this.getMaxScrollY())) {
            this.scrollTo(this.getScrollX(), maxScrollY);
        }
    }

    public void setBackgroundColor(int color) {
        if (color != 0 || this.mReactBackgroundDrawable != null) {
            this.getOrCreateReactViewBackground().setColor(color);
        }
    }

    public void setBorderWidth(int position, float width) {
        this.getOrCreateReactViewBackground().setBorderWidth(position, width);
    }

    public void setBorderColor(int position, float color, float alpha) {
        this.getOrCreateReactViewBackground().setBorderColor(position, color, alpha);
    }

    public void setBorderRadius(float borderRadius) {
        this.getOrCreateReactViewBackground().setRadius(borderRadius);
    }

    public void setBorderRadius(float borderRadius, int position) {
        this.getOrCreateReactViewBackground().setRadius(borderRadius, position);
    }

    public void setBorderStyle(@Nullable String style) {
        this.getOrCreateReactViewBackground().setBorderStyle(style);
    }

    private ReactViewBackgroundDrawable getOrCreateReactViewBackground() {
        if (this.mReactBackgroundDrawable == null) {
            this.mReactBackgroundDrawable = new ReactViewBackgroundDrawable();
            Drawable backgroundDrawable = this.getBackground();
            super.setBackground(null);
            if (backgroundDrawable == null) {
                super.setBackground((Drawable)this.mReactBackgroundDrawable);
            } else {
                LayerDrawable layerDrawable = new LayerDrawable(new Drawable[]{this.mReactBackgroundDrawable, backgroundDrawable});
                super.setBackground((Drawable)layerDrawable);
            }
        }
        return this.mReactBackgroundDrawable;
    }

    static {
        sTriedToGetScrollerField = false;
    }
}

