/*
 * Decompiled with CFR 0.152.
 */
package com.rnnestedscrollview;

import android.view.View;
import android.view.ViewGroup;
import com.facebook.react.bridge.JSApplicationIllegalArgumentException;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.uimanager.UIManagerModule;
import com.facebook.react.uimanager.events.Event;
import com.facebook.react.views.scroll.ScrollEvent;
import com.facebook.react.views.scroll.ScrollEventType;

public class ReactNestedScrollViewHelper {
    public static final long MOMENTUM_DELAY = 20L;
    public static final String OVER_SCROLL_ALWAYS = "always";
    public static final String AUTO = "auto";
    public static final String OVER_SCROLL_NEVER = "never";

    public static void emitScrollEvent(ViewGroup scrollView, float xVelocity, float yVelocity) {
        ReactNestedScrollViewHelper.emitScrollEvent(scrollView, ScrollEventType.SCROLL, xVelocity, yVelocity);
    }

    public static void emitScrollBeginDragEvent(ViewGroup scrollView) {
        ReactNestedScrollViewHelper.emitScrollEvent(scrollView, ScrollEventType.BEGIN_DRAG);
    }

    public static void emitScrollEndDragEvent(ViewGroup scrollView, float xVelocity, float yVelocity) {
        ReactNestedScrollViewHelper.emitScrollEvent(scrollView, ScrollEventType.END_DRAG, xVelocity, yVelocity);
    }

    public static void emitScrollMomentumBeginEvent(ViewGroup scrollView) {
        ReactNestedScrollViewHelper.emitScrollEvent(scrollView, ScrollEventType.MOMENTUM_BEGIN);
    }

    public static void emitScrollMomentumEndEvent(ViewGroup scrollView) {
        ReactNestedScrollViewHelper.emitScrollEvent(scrollView, ScrollEventType.MOMENTUM_END);
    }

    private static void emitScrollEvent(ViewGroup scrollView, ScrollEventType scrollEventType) {
        ReactNestedScrollViewHelper.emitScrollEvent(scrollView, scrollEventType, 0.0f, 0.0f);
    }

    private static void emitScrollEvent(ViewGroup scrollView, ScrollEventType scrollEventType, float xVelocity, float yVelocity) {
        View contentView = scrollView.getChildAt(0);
        if (contentView == null) {
            return;
        }
        ReactContext reactContext = (ReactContext)scrollView.getContext();
        ((UIManagerModule)reactContext.getNativeModule(UIManagerModule.class)).getEventDispatcher().dispatchEvent((Event)ScrollEvent.obtain((int)scrollView.getId(), (ScrollEventType)scrollEventType, (int)scrollView.getScrollX(), (int)scrollView.getScrollY(), (float)xVelocity, (float)yVelocity, (int)contentView.getWidth(), (int)contentView.getHeight(), (int)scrollView.getWidth(), (int)scrollView.getHeight()));
    }

    public static int parseOverScrollMode(String jsOverScrollMode) {
        if (jsOverScrollMode == null || jsOverScrollMode.equals(AUTO)) {
            return 1;
        }
        if (jsOverScrollMode.equals(OVER_SCROLL_ALWAYS)) {
            return 0;
        }
        if (jsOverScrollMode.equals(OVER_SCROLL_NEVER)) {
            return 2;
        }
        throw new JSApplicationIllegalArgumentException("wrong overScrollMode: " + jsOverScrollMode);
    }
}

